#include <stdio.h>
#include "vort.h"

/*
 * readrgbaline
 *
 *	reads in a scanline from file in and puts the scanline into red, green,
 * blue, and alpha.
 */
int
readrgbaline(in, red, green, blue, alpha)
	image		*in;
	unsigned char	*red, *green, *blue, *alpha;
{
	register int	x, i;
	unsigned char	r, g, b, a, run;

	switch (imagetype(in)) {
	case PIX_CMAP:
		for (x = 0; x < imagewidth(in); x++) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			red[x] = in->red[i];
			green[x] = in->green[i];
			blue[x] = in->blue[i];
			alpha[x] = 255;
		}
		break;
	case PIX_RLECMAP:
		x = 0;  
		while (x < imagewidth(in)) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			run = i;
			if (run & 0x80) {
				while ((run & 0x7f) && x < imagewidth(in)) {
					i = readbyte(in);
					red[x] = in->red[i];
					green[x] = in->green[i];
					blue[x] = in->blue[i];
					alpha[x] = 255;
					run--;
					x++;
				}
			} else {
				i = readbyte(in);
				r = red[x] = in->red[i];
				g = green[x] = in->green[i];
				b = blue[x] = in->blue[i];
				alpha[x] = 255;
				x++;
				while (run && x < imagewidth(in)) {
					red[x] = r;
					green[x] = g;
					blue[x] = b;
					alpha[x] = 255;
					run--;
					x++;
				}
			}
		}
		break;
	case PIX_RGB:
		for (x = 0; x < imagewidth(in); x++) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			red[x] = i;
			green[x] = readbyte(in);
			blue[x] = readbyte(in);
			alpha[x] = 255;
		}
		break;
	case PIX_RGBA:
		for (x = 0; x < imagewidth(in); x++) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			red[x] = i;
			green[x] = readbyte(in);
			blue[x] = readbyte(in);
			alpha[x] = readbyte(in);
		}
		break;
	case PIX_RLEA:
		x = 0;
		while (x < imagewidth(in)) {
			if ((i = readbyte(in)) == EOF)
				return(0);
			run = i;
			if (run & 0x80) {
				while ((run & 0x7f) && x < imagewidth(in)) {
					red[x] = readbyte(in);
					green[x] = readbyte(in);
					blue[x] = readbyte(in);
					alpha[x] = readbyte(in);
					run--;
					x++;
				}
			} else {
				r = red[x] = readbyte(in);
				g = green[x] = readbyte(in);
				b = blue[x] = readbyte(in);
				a = alpha[x] = readbyte(in);
				x++;
				while (run && x < imagewidth(in)) {
					red[x] = r;
					green[x] = g;
					blue[x] = b;
					alpha[x] = a;
					run--;
					x++;
				}
			}
		}
		break;
	default:
		fprintf(stderr, "readrgbaline: bad file format.\n");
		return(0);
	}

	return(1);
}
