#include <stdio.h>
#include <math.h>
#ifdef MSC
#include <fcntl.h>
#else
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#endif
#include "art.h"
#include "gram.h"
#include "macro.h"

extern attr	*astackp;

/*
 * tileinit
 *
 *	initialise the function pointers and fields for a tile pattern. 
 */
void
tileinit(txt, name, wdim, hdim)
	texture		*txt;
	char		*name;
	double		wdim, hdim;
{
	int	i;
	image	*im;
	char	*cp, *red, *green, *blue, buf[BUFSIZ];

	if ((im = openimage(name, "r")) == (image *)NULL) {
		sprintf(buf, "art: error opening tile file %s.\n", name);
		fatal(buf);
	}

	txt->scalew *= imagewidth(im) / wdim;
	txt->scaleh *= imageheight(im) / hdim;

	txt->pixw = imagewidth(im);
	txt->pixh = imageheight(im);

	red = (char *)smalloc(imagewidth(im));
	green = (char *)smalloc(imagewidth(im));
	blue = (char *)smalloc(imagewidth(im));

	cp = txt->map = (char *)smalloc(imagewidth(im) * imageheight(im) * 3);

	while (readrgbline(im, red, green, blue))
		for (i = 0; i < imagewidth(im); i++) {
			*cp++ = red[i];
			*cp++ = green[i];
			*cp++ = blue[i];
		}

	closeimage(im);
}
