#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp;
extern hlist	*fhlist;

/*
 * spherei
 *
 *	returns a list of intersection points for the ray r and sphere o.
 */
hlist *
spherei(r, o, last)
	register ray	*r;
	register object	*o;
	hlist		**last;
{
	vector		c;
	hlist		*hitlist, *hp;
	register float	b, d;

	vadd(c, r->org, o->bs.cent);

	b = -dprod(c, r->dir);
	d = b * b - (dprod(c, c) - o->bs.radsqu);

	if (d < 0)
		return((hlist *)NULL);
	
	d = sqrt((double)d);

	fetch(hp);
	hitlist = hp;
	hp->t = b - d;

	if (hp->t > TOLERANCE) {
		hitlist->obj = o;
		fetch(hp);
		hitlist->nxt = hp;
		hp->t = b + d;
	} else {
		hp->t = b + d;
		if (hp->t < TOLERANCE) {
			release(hp);
			return((hlist *)NULL);
		}
	}

	hp->obj = o;
	hp->nxt = (hlist *)NULL;
	*last = hp;

	return(hitlist);
}

/*
 * spheren
 *
 *	returns the normal to the sphere s
 */
void
spheren(n, l, o)
	register vector	*n;
	register vector	*l;
	register object	*o;
{
	vadd(*n, *l, o->bs.cent);

	normalise(*n);
}

/*
 * spherec
 *
 *	return the color of a sphere o at a the intersection point l.
 *
 */
void
spherec(o, txt, l, n, pcol, type)
	object	*o;
	texture	*txt;
	vector	*l, *n;
	pixel	*pcol;
	int	type;
{
	vector	tmp;
	float	u, v;
	int	w, h, indx;

	totexture(txt, tmp, *n);

	spheremap(&tmp, txt, &u, &v);

	w = u * txt->scalew;
	h = v * txt->scaleh;

	indx = (w % txt->pixw + (h % txt->pixh) * txt->pixw) * 3;

	pcol->r = (unsigned char)txt->map[indx] / 255.0;
	pcol->g = (unsigned char)txt->map[indx + 1] / 255.0;
	pcol->b = (unsigned char)txt->map[indx + 2] / 255.0;
}

/*
 * sphereinit
 *
 *	initialise the function pointers and fields for a sphere object,
 * returning its pointer.
 */
object *
sphereinit(d)
	details *d;
{
	object	*o;
	tlist	*tl;
	details	*ld;
	float	radius;
	vector	cent, v;

	o = (object *)smalloc(sizeof(object));
	o->type = SPHERE;
	o->intersects = spherei;
	o->normal = spheren;

	cent.x = cent.y = cent.z = 0.0;

	while (d != (details *)NULL) {
		switch (d->type) {
		case CENTER:
			cent = d->u.v;
			break;
		case RADIUS:
			radius = d->u.f;
			break;
		default:
			warning("art: illegal field in sphere ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	makebsphere(&o->bs, &cent, radius * radius);

	objtranslate(cent.x, cent.y, cent.z);

	scale(radius, radius, radius);
			  
	setattributes(o);

	for (tl = o->s.txtlist; tl != (tlist *)NULL; tl = tl->nxt)
		if (tl->txtcol == (void (*)())NULL) {
			if (!tl->txt.refset) {
				tl->txt.vref1.y = 1.0;
				tl->txt.vref1.x = tl->txt.vref1.z = 0.0;
				tl->txt.vref2.x = 1.0;
				tl->txt.vref2.y = tl->txt.vref2.z = 0.0;
			}

			tl->txtcol = spherec;

			v3x3tmult(v, tl->txt.vref1, astackp->m);
			tl->txt.vref1 = v;
			v3x3tmult(v, tl->txt.vref2, astackp->m);
			tl->txt.vref2 = v;
		}

	return(o);
}
