#include <stdio.h>
#include <math.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern object	*oblist;
extern light	*lights;
extern hlist	*fhlist;
extern int	maxhitlevel;

extern pixel	backcol;
extern colour	ambient;

extern double	power();

/*
 * trace
 *
 *	returns a list of hits on the first object hit by r
 */
hlist *
trace(r, olist, last)
	register ray	*r;
	object		*olist;
	hlist		**last;
{
	register object	*o;
	register hlist	*hit, *prevhits, *pend, *p, *np;
	hlist		*end;

	prevhits = (hlist *)NULL;

	for (o = olist; o != (object *)NULL; o = o->nxt)
		if ((hit = o->intersects(r, o, &end)) != (hlist *)NULL) {
			if (prevhits == (hlist *)NULL) {
				prevhits = hit;
				pend = end;
			} else {
				if (prevhits->t > hit->t) {
					for (p = prevhits; p != (hlist *)NULL; p = np) {
						np = p->nxt;
						release(p)
					}
					prevhits = hit;
					pend = end;
				} else {
					for (p = hit; p != (hlist *)NULL; p = np) {
						np = p->nxt;
						release(p)
					}
				}
			}
		}

	*last = pend;

	return(prevhits);
}
