#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp;
extern hlist	*fhlist;

/*
 * ringi
 *
 *	returns an intersection point for the ray and ring o
 */
hlist *
ringi(r, o, last)
	register ray	*r;
	register object	*o;
	hlist		**last;
{
	vector		cv;
	hlist		*hitlist;
	ray		nr;
	register float	x, y, z, prod, t;
	register ring	*rng;

	vadd(cv, r->org, o->bs.cent);
	prod = dprod(cv, r->dir);

	if ((dprod(cv, cv) - o->bs.radsqu) > prod * prod)
		return((hlist *)NULL);

	transray(o, nr, *r);

	rng = o->obj.rng;

	t = dprod(rng->n, nr.dir);

	if (t == 0.0)
		return((hlist *)NULL);

	t = -dprod(rng->n, nr.org) / t;

	if (t < TOLERANCE)
		return((hlist *)NULL);

	x = t * nr.dir.x + nr.org.x;
	y = t * nr.dir.y + nr.org.y;
	z = t * nr.dir.z + nr.org.z;

	prod = x * x + y * y + z * z;
	if (prod > 1.0)
		return((hlist *)NULL);
	
	if (prod < rng->intradsqu)
		return((hlist *)NULL);

	fetch(hitlist);
	hitlist->t = t;
	hitlist->obj = o;
	hitlist->nxt = (hlist *)NULL;
	*last = hitlist;

	return(hitlist);
}

/*
 * ringn
 *
 *	returns the normal to the ring o
 */
void
ringn(n, l, o)
	register vector	*n;
	register vector	*l;
	register object	*o;
{
	n->x = o->obj.rng->n.x;
	n->y = o->obj.rng->n.y;
	n->z = o->obj.rng->n.z;
}

/*
 * ringc
 *
 *	return the color of the ring o at the point l
 *
 */
void
ringc(o, txt, l, n, pcol, type)
	object  *o;
	texture *txt;
	vector  *l, *n;
	pixel   *pcol;
	int     type;
{
	ring	*rng;
	float	u, v;
	int	w, h, indx;
	vector	loc, tmp;

	rng = o->obj.rng;

	toobject(o, tmp, *l);

	totexture(txt, loc, tmp);

	v = 1.0 - (loc.x - rng->intrad) / (1.0 - rng->intrad);

	if (fabs(loc.x) > 1.0)
		loc.x = (loc.x < 0.0) ? -1.0 : 1.0;
	

	if (loc.y < 0.0)
		u = 1.0 - acos(loc.x) / (2 * M_PI);
	else
		u = acos(loc.x) / (2 * M_PI);

	w = u * txt->scalew;
	h = v * txt->scaleh;

	indx = (w % txt->pixw + (h % txt->pixh) * txt->pixw) * 3;

	pcol->r = (unsigned char)txt->map[indx] / 255.0;
	pcol->g = (unsigned char)txt->map[indx + 1] / 255.0;
	pcol->b = (unsigned char)txt->map[indx + 2] / 255.0;
}

/*
 * ringinit
 *
 *	initialise the function pointers and fields for a sphere object,
 * returning its pointer.
 */
object *
ringinit(d)
	details *d;
{
	object	*o;
	ring	*rng;
	details	*ld;
	vector	cent, v, radii1, radii2;
	tlist	*tl;
	int	first;

	o = (object *)smalloc(sizeof(object));
	o->type = RING;
	o->intersects = ringi;
	o->normal = ringn;

	rng = o->obj.rng = (ring *)smalloc(sizeof(ring));

	cent.x = cent.y = cent.z = 0.0;
	first = 1;
	radii1.x = radii1.y = 1.0;
	radii2.x = 0.0;

	while (d != (details *)NULL) {
		switch (d->type) {
		case CENTER:
			cent = d->u.v;
			break;
		case RADIUS:
			if (first) {
				radii2.x = radii2.y = d->u.f;
				radii1.x = radii1.y = d->u.f;
				first = 0;
			} else
				radii1.x = radii1.y = d->u.f;
			break;
		case RADII:
			if (first) {
				radii1.x = radii2.x = d->u.v.x;
				radii1.y = radii2.y = d->u.v.y;
				first = 0;
			} else {
				radii1.x = d->u.v.x;
				radii1.y = d->u.v.y;
			}
			break;
		default:
			warning("art: illegal field in sphere ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	if (radii1.x > radii1.y)
		makebsphere(&o->bs, &cent, radii1.x * radii1.x);
	else
		makebsphere(&o->bs, &cent, radii1.y * radii1.y);

	scale(radii1.x, radii1.y, 1.0);

	rng->intrad = radii2.x / radii1.x;
	rng->intradsqu = (radii2.x * radii2.x) / (radii1.x * radii1.x);

	setattributes(o);

	if (o->mat != (mat3x3 *)NULL) {
		v.x = v.y = 0.0;
		v.z = 1.0;
		v3x3tmult(rng->n, v, (*o->mat));
	} else {
		rng->n.x = rng->n.y = 0.0;
		rng->n.z = 1.0;
	}

	for (tl = o->s.txtlist; tl != (tlist *)NULL; tl = tl->nxt)
		if (tl->txtcol == (void (*)())NULL) {
			if (!tl->txt.refset) {
				tl->txt.vref1.y = 1.0;
				tl->txt.vref1.x = tl->txt.vref1.z = 0.0;
				tl->txt.vref2.x = 1.0;
				tl->txt.vref2.y = tl->txt.vref2.z = 0.0;
			}

			tl->txtcol = ringc;

			v3x3tmult(v, tl->txt.vref1, astackp->m);
			tl->txt.vref1 = v;
			v3x3tmult(v, tl->txt.vref2, astackp->m);
			tl->txt.vref2 = v;
		}

	return(o);
}
