#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp;
extern hlist	*fhlist;

/*
 * spheremap
 *
 *	return the (u, v) values for teh invers mapping of a sphere given
 * the surface normal and the two reference vectors
 *
 */
void
spheremap(n, txt, u, v)
	vector	*n;
	texture	*txt;
	float	*u, *v;
{
	vector	tmp;
	double	t;
	double	phi, theta;

	t = -dprod(*n, txt->vref1);

	if (fabs(t) > 1.0)		/* precision check */
		t = (t < 0.0) ? -1.0 : 1.0;

	phi = acos(t);

	*v = phi / M_PI;

	if (*v != 0.0 && *v != 1.0) {
		t = dprod(txt->vref2, *n) / sin(phi); 

		if (fabs(t) > 1.0)		/* precision check */
			t = (t < 0.0) ? -1.0 : 1.0;

		theta = acos(t) / (2 * M_PI);

		xprod(tmp, txt->vref1, txt->vref2)

		if (dprod(tmp, *n) > 0)
			*u = theta;
		else
			*u = 1 - theta;
	} else
		*u = 0.0;
}

