%{
#include <math.h>
#include "art.h"
#include "gram.h"

extern attr	*astackp;
extern int	linecount;

%}

%p 3000

%%

sphere		return(SPHERE);

polygon		return(POLYGON);

geometry	return(GEOMETRY);

box		return(BOX);

cylinder	return(CYLINDER);

ellipsoid	return(ELLIPSOID);

composite	return(COMPOSITE);

cone		return(CONE);

disk		return(RING);

ring		return(RING);

geofile		return(OFFFILE);

offfile		return(OFFFILE);

vortfile	return(VORTFILE);

top		return(TOP);

base		return(BASE);

constant	return(CONST);

coefficients	return(COEFFS);

order		return(ORDER);

torus		return(TORUS);

superquadric	return(SUPERQUADRIC);

csg		return(CSG);

phongshading	{
			yylval.y_int = PHONGSHADING;
			return(OPTION);
		}

backfacing	{
			yylval.y_int = BACKFACING;
			return(OPTION);
		}

on		return(ON);

off		return(OFF);

material	return(MATERIAL);

center		return(CENTER);

colour		return(COLOUR);

color		return(COLOUR);

ambient		return(AMBIENT);

reflectance	return(REFLECTANCE);

absorption	return(ABSORPTION);

transparency	return(TRANSPARENCY);

radius		return(RADIUS);

radii		return(RADII);

light		return(LIGHT);

direction	return(DIRECTION);

angle		return(ANGLE);

numrays		return(NUMRAYS);

vertex		return(VERTEX);

location	return(LOCATION);

algebraic	return(ALGEBRAIC);

tile		return(TILE);

texture		return(TEXTURE);

map		return(MAP);

range		return(RANGE);

blendcolor	return(BLENDCOLOR);

blendcolour	return(BLENDCOLOR);

scalefactors	return(SCALEFACTORS);

size		return(SIZE);

equation	return(EQUATION);

translate	return(TRANSLATE);

rotate		return(ROTATE);

scale		return(SCALE);

lookat		return(LOOKAT);

up		return(UP);

fieldofview	return(FIELDOFVIEW);

raysperpixel	return(RAYSPERPIXEL);

refpoint	return(VREF1);

pole		return(VREF1);

equator		return(VREF2);

title		return(TITLE);

background	return(BACKGROUND);

maxhitlevel	return(MAXHITLEVEL);

output		return(OUTPUT);

twentyfivebit	return(TWENTYFIVEBIT);

rgb		{
			yylval.y_int = PIX_RGB;
			return(FILETYPE);
		}

rle		{
			yylval.y_int = PIX_RLE;
			return(FILETYPE);
		}

rgba		{
			yylval.y_int = PIX_RGBA;
			return(FILETYPE);
		}

rlea		{
			yylval.y_int = PIX_RLEA;
			return(FILETYPE);
		}

[a-zA-Z_][a-zA-Z_.0-9]*	{
			yylval.y_str = (char *)smalloc(strlen(yytext) + 1);
			strcpy(yylval.y_str, yytext);
			return(NAME);
		}

[0-9]*	{
			yylval.y_int = atoi(yytext);
			return(INTEGER);
		}

[0-9]*\.[0-9]*	{
			yylval.y_flt = atof(yytext);
			return(FLOAT);
		}

"+"		return(PLUS);

"-"		return(MINUS);

"*"		return(MULT);

"/"		return(DIV);

"%"		return(PCENT);

"^"		return(POWER);

","		return(COMMA);

"("		return(LP);

")"		return(RP);

"="		return(EQUALS);

"."		return(DOT);

"$$"		return(DOLS);

"\""		{
			char	buf[BUFSIZ], *p;
			
			for (p = buf; (*p = getchar()) != '"'; p++)
				if (*p == '\n' || *p == EOF)
					yyerror("syntax error");

			*p = 0;

			yylval.y_str = (char *)smalloc(strlen(buf) + 1);
			strcpy(yylval.y_str, buf);

			return(STRING);
		}

"{"		{
			astackp++;
			*astackp = *(astackp - 1);
			return(LBRACE);
		}

"}"		{
			return(RBRACE);
		}

"\n"		{
			linecount++;
		}

[ \t]		{
			;
		}

"/*"		{
			char	c1, c2;
			int	comline;
			char	buf[BUFSIZ];

			comline = linecount;

			do {
				while ((c1 = getchar()) != '*' && c1 != EOF)
					if (c1 == '\n')
						linecount++;
				c2 = getchar();
				if (c2 == '\n')
					linecount++;
			} while (c2 != '/' && c2 != EOF);

			if (c1 == EOF || c2 == EOF) {
				sprintf(buf, "art: unterminated comment - started line %d.\n", comline);
				fatal(buf);
			}
		}
