
# line 6 "gram.y"
#include <stdio.h>
#include <math.h>
#include "art.h"
#include "macro.h"

extern object	*sphereinit(),
		*boxinit(),
		*csginit(),
		*getcsgobj(),
		*getcsgexp(),
		*alginit(),
		*ringinit(),
		*torusinit(),
		*polygoninit(),
		*compinit(),
		*geometryinit(),
		*coneinit(),
		*ellipsinit(),
		*cylinit(),
		*superinit();

extern light	*lightinit();
extern tlist	*tileinit();
extern tlist	*textureinit();

extern attr	*astackp;
extern object	*oblist;
extern light	*lights;

extern vector	org, up;

extern matrix	trans;
extern float	focallength;

extern char	*title;
extern int	maxhitlevel, raysperpix;
extern long	filetype;

extern colour	backcol;

#ifndef M_PI
#define M_PI	3.14159265358979323846
#endif


# line 52 "gram.y"
typedef union {
	object	*y_obj;
	light	*y_lht;
	vector	*y_pnt;
	details	*y_det;
	char	*y_str;
	eqn	*y_eqn;
	term	*y_trm;
	float	y_flt;
	int	y_int;
} YYSTYPE;
# define BOX 257
# define CSG 258
# define CONE 259
# define RING 260
# define TORUS 261
# define SPHERE 262
# define POLYGON 263
# define GEOMETRY 264
# define CYLINDER 265
# define ALGEBRAIC 266
# define COMPOSITE 267
# define ELLIPSOID 268
# define SUPERQUADRIC 269
# define FLOAT 270
# define INTEGER 271
# define FILETYPE 272
# define OPTION 273
# define STRING 274
# define NAME 275
# define LBRACE 276
# define RBRACE 277
# define LP 278
# define RP 279
# define RADIUS 280
# define RADII 281
# define COLOUR 282
# define CENTER 283
# define VERTEX 284
# define COMMA 285
# define PCENT 286
# define MATERIAL 287
# define REFI 288
# define MINUS 289
# define AMBIENT 290
# define LIGHT 291
# define INTENSITY 292
# define LOCATION 293
# define DOLS 294
# define EQUATION 295
# define TILE 296
# define OFFFILE 297
# define BASE 298
# define TOP 299
# define CONST 300
# define COEFFS 301
# define SCALE 302
# define ROTATE 303
# define TRANSLATE 304
# define TITLE 305
# define REFLECTANCE 306
# define DOT 307
# define ON 308
# define OFF 309
# define LOOKAT 310
# define FIELDOFVIEW 311
# define TRANSPARENCY 312
# define RAYSPERPIXEL 313
# define BACKGROUND 314
# define SIZE 315
# define MAXHITLEVEL 316
# define OUTPUT 317
# define ORDER 318
# define ABSORPTION 319
# define VREF1 320
# define VREF2 321
# define NUMRAYS 322
# define OBJECT 323
# define TEXTURE 324
# define DIRECTION 325
# define ANGLE 326
# define UP 327
# define TWENTYFIVEBIT 328
# define RANGE 329
# define MAP 330
# define BLENDCOLOR 331
# define SCALEFACTORS 332
# define VORTFILE 333
# define PLUS 334
# define MULT 335
# define DIV 336
# define COMBINE 337
# define POWER 338
# define UMINUS 339
# define EQUALS 340
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 121
# define YYLAST 2189
short yyact[]={

  51,  52,  54,  55,  96, 366, 363, 270, 310,  56,
 269,  54,  55,  61,  62, 227, 270, 228, 276, 269,
 340, 308,  71,  72,  73,  74,  75,  76, 228, 225,
 308, 156, 107,  68,   4,  45, 306,  64,  65, 362,
 146, 228, 219, 150, 117, 147,  57,  58, 389,  95,
  97,  98, 387, 384,  69,  99, 149,  54,  55, 369,
 100, 101, 226, 227, 368, 367, 307, 103, 104, 361,
 359, 170, 305, 226, 227, 307,  53, 358, 111, 112,
 113, 357, 342, 335, 331, 151, 226, 227, 153, 152,
 327, 326, 325, 322, 304, 302, 301, 128, 129, 130,
 131, 300, 296, 134, 272, 265, 261, 260, 139, 140,
 141, 142, 259, 243, 242, 240, 239, 204, 203, 202,
 201, 196, 145, 144, 143, 136, 135, 133, 132, 110,
 109, 108, 102, 194, 195, 382, 197, 198, 381,  54,
  55, 380, 379, 330, 270, 206, 207, 269, 208, 171,
 329, 210, 211, 212, 324, 323, 321, 258, 218, 215,
 216, 217, 214, 213, 220, 221, 222, 223, 173, 209,
  79, 174,  78,  77,  67,  66,  60,  59,  16, 385,
 375, 295, 253, 374, 341, 285, 284,  21, 283, 282,
 281, 280,  22, 279, 278,  23, 277, 241, 106, 105,
  93,  20, 254, 255, 256, 257,  92,  29,  27,  28,
 262,  24,  91,  90, 263, 264,  89,  25,  88, 266,
 250, 271,  87,  86,  26,  17,  18,  85,  84,  19,
  83, 246, 246,  82, 248, 247, 249, 251, 252,  81,
 286, 287,  80, 288, 289, 290, 229, 238, 237, 291,
 292, 293, 294, 236, 235, 234, 267, 233, 232, 231,
 297, 298, 299, 230, 224, 205, 303,  70,  50, 271,
  63, 271, 383, 311,  33,  34,  40,  35,  43,  32,
  36,  37,  42,  39,  44,  41,  38, 364,  54,  55,
 199,   5, 172, 138, 137,  46,  48, 328, 273, 274,
 275, 332, 333, 334,   2, 336, 309, 337, 271, 271,
 271, 271,  15,   1, 245, 148,  47, 114, 155, 268,
   3,   0,   0, 352,   0,   0, 353, 354, 355,   0,
 320,   0, 356,   0,   0,   0, 360,  94,   0,   0,
 271, 271,   0, 365, 338, 339,   0,   0,   0,   0,
   0,   0, 171,   0,   0,   0,   0,   0, 370, 371,
 372,   0, 373,   0,   0,   0,   0,   0, 376, 377,
 378,  33,  34,  40,  35,  43,  32,  36,  37,  42,
  39,  44,  41,  38,   0, 386,   0,  16, 388,   0,
   0,   0, 351,   0,   0,   0,  21,   0,   0,   0,
   0,  22,   0,   0,  23,  31,   0,   0,   0,   0,
  20,   0,   0,   0,   0,   0,  29,  27,  28,   6,
  24,   0,   0,   0,  11,   7,  25,   8,  12, 200,
  13,  14,   0,  26,  17,  18,   0,   0,  19,   0,
   0,  10,   9,  33,  34,  40,  35,  43,  32,  36,
  37,  42,  39,  44,  41,  38,   0,   0,   0,  16,
   0,   0,   0, 350,   0,   0, 159, 160,  21, 157,
 161,   0,   0,  22,   0,   0,  23,   0,   0,   0,
   0, 162,  20, 167, 166, 165, 164, 163,  29,  27,
  28,   0,  24,   0,   0,   0,   0,   0,  25,   0,
   0,   0,   0,   0, 158,  26,  17,  18,   0,   0,
  19,  33,  34,  40,  35,  43,  32,  36,  37,  42,
  39,  44,  41,  38,   0,   0,   0,  16,   0,   0,
   0, 349,   0,   0, 159, 160,  21, 157, 161,   0,
   0,  22,   0,   0,  23,   0,   0,   0,   0, 162,
  20, 167, 166, 165, 164, 163,  29,  27,  28,   0,
  24,   0,   0,   0,   0,   0,  25,   0,   0,   0,
   0,   0, 158,  26,  17,  18,   0,   0,  19,  33,
  34,  40,  35,  43,  32,  36,  37,  42,  39,  44,
  41,  38,   0,   0,   0,  16,   0,   0,   0, 348,
   0,   0, 159, 160,  21, 157, 161,   0,   0,  22,
   0,   0,  23,   0,   0,   0,   0, 162,  20, 167,
 166, 165, 164, 163,  29,  27,  28,   0,  24,   0,
   0,   0,   0,   0,  25,   0,   0,   0,   0,   0,
 158,  26,  17,  18,   0,   0,  19,  33,  34,  40,
  35,  43,  32,  36,  37,  42,  39,  44,  41,  38,
   0,   0,   0,  16,   0,   0,   0, 347,   0,   0,
 159, 160,  21, 157, 161,   0,   0,  22,   0,   0,
  23,   0,   0,   0,   0, 162,  20, 167, 166, 165,
 164, 163,  29,  27,  28,   0,  24,   0,   0,   0,
   0,   0,  25,   0,   0,   0,   0,   0, 158,  26,
  17,  18,   0,   0,  19,  33,  34,  40,  35,  43,
  32,  36,  37,  42,  39,  44,  41,  38,   0,   0,
   0,  16,   0,   0,   0, 346,   0,   0, 159, 160,
  21, 157, 161,   0,   0,  22,   0,   0,  23,   0,
   0,   0,   0, 162,  20, 167, 166, 165, 164, 163,
  29,  27,  28,   0,  24,   0,   0,   0,   0,   0,
  25,   0,   0,   0,   0,   0, 158,  26,  17,  18,
   0,   0,  19,  33,  34,  40,  35,  43,  32,  36,
  37,  42,  39,  44,  41,  38,   0,   0,   0,  16,
   0,   0,   0, 345,   0,   0, 159, 160,  21, 157,
 161,   0,   0,  22,   0,   0,  23,   0,   0,   0,
   0, 162,  20, 167, 166, 165, 164, 163,  29,  27,
  28,   0,  24,   0,   0,   0,   0,   0,  25,   0,
   0,   0,   0,   0, 158,  26,  17,  18,   0,   0,
  19,  33,  34,  40,  35,  43,  32,  36,  37,  42,
  39,  44,  41,  38,   0,   0,   0,  16,   0,   0,
   0, 344,   0,   0, 159, 160,  21, 157, 161,   0,
   0,  22,   0,   0,  23,   0,   0,   0,   0, 162,
  20, 167, 166, 165, 164, 163,  29,  27,  28,   0,
  24,   0,   0,   0,   0,   0,  25,   0,   0,   0,
   0,   0, 158,  26,  17,  18,   0,   0,  19,  33,
  34,  40,  35,  43,  32,  36,  37,  42,  39,  44,
  41,  38,   0,   0,   0,  16,   0,   0,   0, 343,
   0,   0, 159, 160,  21, 157, 161,   0,   0,  22,
   0,   0,  23,   0,   0,   0,   0, 162,  20, 167,
 166, 165, 164, 163,  29,  27,  28,   0,  24,   0,
   0,   0,   0,   0,  25,   0,   0,   0,   0,   0,
 158,  26,  17,  18,   0,   0,  19,  33,  34,  40,
  35,  43,  32,  36,  37,  42,  39,  44,  41,  38,
   0,   0,   0,  16,   0,   0,   0, 193,   0,   0,
 159, 160,  21, 157, 161,   0,   0,  22,   0,   0,
  23,   0,   0,   0,   0, 162,  20, 167, 166, 165,
 164, 163,  29,  27,  28,   0,  24,   0,   0,   0,
   0,   0,  25,   0,   0,   0,   0,   0, 158,  26,
  17,  18,   0,   0,  19,  33,  34,  40,  35,  43,
  32,  36,  37,  42,  39,  44,  41,  38,   0,   0,
   0,  16,   0,   0,   0, 192,   0,   0, 159, 160,
  21, 157, 161,   0,   0,  22,   0,   0,  23,   0,
   0,   0,   0, 162,  20, 167, 166, 165, 164, 163,
  29,  27,  28,   0,  24,   0,   0,   0,   0,   0,
  25,   0,   0,   0,   0,   0, 158,  26,  17,  18,
   0,   0,  19,  33,  34,  40,  35,  43,  32,  36,
  37,  42,  39,  44,  41,  38,   0,   0,   0,  16,
   0,   0,   0, 191,   0,   0, 159, 160,  21, 157,
 161,   0,   0,  22,   0,   0,  23,   0,   0,   0,
   0, 162,  20, 167, 166, 165, 164, 163,  29,  27,
  28,   0,  24,   0,   0,   0,   0,   0,  25,   0,
   0,   0,   0,   0, 158,  26,  17,  18,   0,   0,
  19,  33,  34,  40,  35,  43,  32,  36,  37,  42,
  39,  44,  41,  38,   0,   0,   0,  16,   0,   0,
   0, 190,   0,   0, 159, 160,  21, 157, 161,   0,
   0,  22,   0,   0,  23,   0,   0,   0,   0, 162,
  20, 167, 166, 165, 164, 163,  29,  27,  28,   0,
  24,   0,   0,   0,   0,   0,  25,   0,   0,   0,
   0,   0, 158,  26,  17,  18,   0,   0,  19,  33,
  34,  40,  35,  43,  32,  36,  37,  42,  39,  44,
  41,  38,   0,   0,   0,  16,   0,   0,   0, 189,
   0,   0, 159, 160,  21, 157, 161,   0,   0,  22,
   0,   0,  23,   0,   0,   0,   0, 162,  20, 167,
 166, 165, 164, 163,  29,  27,  28,   0,  24,   0,
   0,   0,   0,   0,  25,   0,   0,   0,   0,   0,
 158,  26,  17,  18,   0,   0,  19,  33,  34,  40,
  35,  43,  32,  36,  37,  42,  39,  44,  41,  38,
   0,   0,   0,  16,   0,   0,   0, 188,   0,   0,
 159, 160,  21, 157, 161,   0,   0,  22,   0,   0,
  23,   0,   0,   0,   0, 162,  20, 167, 166, 165,
 164, 163,  29,  27,  28,   0,  24,   0,   0,   0,
   0,   0,  25,   0,   0,   0,   0,   0, 158,  26,
  17,  18,   0,   0,  19,  33,  34,  40,  35,  43,
  32,  36,  37,  42,  39,  44,  41,  38,   0,   0,
   0,  16,   0,   0,   0, 187,   0,   0, 159, 160,
  21, 157, 161,   0,   0,  22,   0,   0,  23,   0,
   0,   0,   0, 162,  20, 167, 166, 165, 164, 163,
  29,  27,  28,   0,  24,   0,   0,   0,   0,   0,
  25,   0,   0,   0,   0,   0, 158,  26,  17,  18,
   0,   0,  19,  33,  34,  40,  35,  43,  32,  36,
  37,  42,  39,  44,  41,  38,   0,   0,   0,  16,
   0,   0,   0, 186,   0,   0, 159, 160,  21, 157,
 161,   0,   0,  22,   0,   0,  23,   0,   0,   0,
   0, 162,  20, 167, 166, 165, 164, 163,  29,  27,
  28,   0,  24,   0,   0,   0,   0,   0,  25,   0,
   0,   0,   0,   0, 158,  26,  17,  18,   0,   0,
  19,  33,  34,  40,  35,  43,  32,  36,  37,  42,
  39,  44,  41,  38,   0,   0,   0,  16,   0,   0,
   0, 185,   0,   0, 159, 160,  21, 157, 161,   0,
   0,  22,   0,   0,  23,   0,   0,   0,   0, 162,
  20, 167, 166, 165, 164, 163,  29,  27,  28,   0,
  24,   0,   0,   0,   0,   0,  25,   0,   0,   0,
   0,   0, 158,  26,  17,  18,   0,   0,  19,  33,
  34,  40,  35,  43,  32,  36,  37,  42,  39,  44,
  41,  38,   0,   0,   0,  16,   0,   0,   0, 184,
   0,   0, 159, 160,  21, 157, 161,   0,   0,  22,
   0,   0,  23,   0,   0,   0,   0, 162,  20, 167,
 166, 165, 164, 163,  29,  27,  28,   0,  24,   0,
   0,   0,   0,   0,  25,   0,   0,   0,   0,   0,
 158,  26,  17,  18,   0,   0,  19,  33,  34,  40,
  35,  43,  32,  36,  37,  42,  39,  44,  41,  38,
   0,   0,   0,  16,   0,   0,   0, 169,   0,   0,
 159, 160,  21, 157, 161,   0,   0,  22,   0,   0,
  23,   0,   0,   0,   0, 162,  20, 167, 166, 165,
 164, 163,  29,  27,  28,   0,  24,   0,   0,   0,
 168,   0,  25,  30,  30,  30,  49,   0, 158,  26,
  17,  18,   0,   0,  19,  33,  34,  40,  35,  43,
  32,  36,  37,  42,  39,  44,  41,  38,   0,   0,
   0,  16,   0,   0,   0, 154,   0,   0, 159, 160,
  21, 157, 161,   0,   0,  22,  30,  49,  23,  49,
   0,   0,   0, 162,  20, 167, 166, 165, 164, 163,
  29,  27,  28,   0,  24,   0,   0,   0,   0,   0,
  25,  16,   0,   0,   0, 244, 158,  26,  17,  18,
  21,   0,  19,   0,   0,  22,   0,   0,  23,   0,
   0,   0,   0,   0,  20,  49,   0,   0,   0,   0,
  29,  27,  28,   0,  24,   0,   0,   0,   0,   0,
  25,   0,   0, 250,   0,   0,   0,  26,  17,  18,
   0,   0,  19,   0,   0,   0,   0, 248, 247, 249,
 251, 252,  33,  34,  40,  35,  43,  32,  36,  37,
  42,  39,  44,  41,  38,   0,   0,   0,  16,   0,
   0,   0,   0,   0,   0,   0,   0,  21,   0,   0,
   0,   0,  22,   0,   0,  23,  31,   0,   0,   0,
   0,  20,   0,   0,   0,   0,   0,  29,  27,  28,
   0,  24,   0, 115,   0,   0,   0,  25,   0,   0,
   0,   0,   0,   0,  26,  17,  18,   0,   0,  19,
 176, 183, 179,   0, 182, 175,   0,   0, 181, 178,
   0, 180, 177,   0,   0,   0,  16,   0, 173,   0,
   0, 174,   0,   0,   0,  21,   0,   0,   0,   0,
  22,   0,   0,  23,   0,   0,   0,   0,   0,  20,
   0,   0,   0,   0,   0,  29,  27,  28,   0,  24,
   0,   0,   0,   0,   0,  25,   0,   0,   0,   0,
   0,   0,  26,  17,  18,   0, 116,  19, 118, 119,
 120, 121, 122, 123, 124, 125, 126, 127,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 312, 313, 314, 315, 316, 317, 318, 319 };
short yypact[]={

-1000,-1000, 114,1595,  17,  17,  -6,-213,-213,-262,
-101,-102,-213,-213,  -2,-1000,-271,-103,-104,-242,
  -8,-213,-213,-213,-213,-213,-213,-105,-106,-108,
-1000, -34, -37, -43, -46, -48, -49, -53, -54, -58,
 -60, -63, -64, -70, -76,  17,  17,-1000,  17,-1000,
-1000,-1000,-285,  18,-1000,-1000,-1000,-1000,-1000,-213,
-213,-153,-1000,-1000,-1000,-1000,-213,-213, -77, -78,
-283,-154,-155,-156,-1000,-1000,-1000,-213,-213,-213,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,  17,  18,  18,  18,  18,-1000,
-157,-158,-213,-159,-160,-1000,-1000,-213,-213,-213,
-213,-161,-162,-163,-237,1478,1410,1663,1342,1274,
1206,1138,1070,1002, 934, 866, 798, 730,-1000,-1000,
-1000,-1000,-213,-213,-164,-213,-213,-1000,-1000,-165,
-166,-167,-168, -10,-213,-213,-1000,-213,-1000,-109,
-213,-213,-213,-115,-1000,-1000,-1000,-116,-213,-213,
-213,-120,-252,-213,-213,-213,-213, -11,-1000,-1000,
-248,-1000,-1000,-1000,-107, -12, -16, -17, -18, -20,
 -21, -22, -27, -28,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-169,-170,-213,-171,-172,1518,
 -95,-213,-213,-213,-213,-122,-173,-178,-179,-213,
-1000,-1000,-1000,-213,-213,-1000,-1000,-180,-213,-131,
-181,-1000,-1000,-1000,-1000,-1000,-107,-107,-107,-261,
 -80, -82, -83, -85, -86, -87, -88, -90, -91,-213,
-213,-1000,-213,-213,-1000,-1000,-1000, -30,-213,-213,
-213,-213, -94,-1000,-1000,-1000,-183,-1000,-1000,-213,
-213,-213,-184,-189,-190,-213,-191,-268,-1000,-131,
-330,-1000,-213,-320,-1000,-320,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-123,-192,-124,-125,
-1000,-1000,-193,-194,-195,-1000,-213,-129,-136,-201,
-213,-213,-213,-202,-213,  18,-131,-131,-131,-259,
 -92,-203, 662, 594, 526, 458, 390, 322, 254, 186,
1663,-1000,-213,-1000,-1000,-213,-213,-213,-1000,-1000,
-1000,-213,-204,-208,-215,-213,-216,-255,-131,-131,
-332,  16,-213,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-272,-220,-221,-1000,-226,-1000,-213,-213,-213,
-1000,-213,-1000, -93, -97,-1000,-1000,-213,-213,-213,
-137,-138,-141,-144,   1,-1000,-232,-1000,-1000,-1000,
-1000,-1000,-1000, -98,-213,-1000,-233,-213,-231,-1000 };
short yypgo[]={

   0, 312, 320,   0,   1,  36, 319,1720, 291,  71,
1903, 318,  31, 317, 315, 290, 314, 313, 304,  44,
 294, 293, 292 };
short yyr1[]={

   0,  17,  17,  17,  17,  17,  17,  18,  18,  18,
  18,  18,  18,  18,  18,  18,  18,  18,   2,   2,
   1,  13,  13,  13,  14,  14,  14,  14,  14,   8,
   8,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,  10,  10,  10,  11,  11,  11,
  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,
  12,  12,  12,  12,  20,  12,  21,  12,  12,  12,
  12,  12,  12,  12,  12,  12,  12,  12,  15,  15,
  15,  16,  16,  16,  16,  16,  16,  19,  19,  19,
  22,  22,  22,  22,  22,  22,  22,  22,  22,   9,
   9,   9,   9,   9,   5,   5,   5,   5,   5,   5,
   6,   6,   6,   3,   3,   3,   3,   3,   3,   4,
   4 };
short yyr2[]={

   0,   4,   3,   3,   3,   2,   2,   0,   3,   3,
   3,   3,   3,   9,  17,   7,   3,   3,   1,   2,
   4,   0,   7,   2,   8,   2,   2,   2,   8,   1,
   2,   4,   4,   5,   4,   4,   4,   4,   4,   4,
   4,   4,   4,   4,   0,   2,   2,   8,   2,   2,
   4,   6,   8,   6,   6,   2,   2,   2,   2,   1,
   2,   2,   8,   8,   0,   6,   0,   6,   6,   6,
   8,   6,   2,   2,   2,   6,   8,   8,   0,   2,
   2,   2,   2,   6,   4,   6,   2,   0,   2,   2,
   5,   5,   5,   5,   5,   5,   5,   5,   6,   1,
   3,   3,   3,   3,   1,   2,   3,   7,   3,   3,
   1,   5,   1,   1,   3,   3,   3,   3,   2,   1,
   1 };
short yychk[]={

-1000, -17, -18,  -2, -12,  -8, 305, 311, 313, 328,
 327, 310, 314, 316, 317,  -1, 273, 320, 321, 324,
 296, 282, 287, 290, 306, 312, 319, 303, 304, 302,
  -7, 291, 262, 257, 258, 260, 263, 264, 269, 266,
 259, 268, 265, 261, 267, -12,  -8,  -1,  -8,  -7,
 274,  -3,  -4, 289, 270, 271,  -3, 308, 309, 278,
 278,  -3,  -3, 272, 308, 309, 278, 278, 275, 296,
 275,  -3,  -3,  -3,  -3,  -3,  -3, 278, 278, 278,
 276, 276, 276, 276, 276, 276, 276, 276, 276, 276,
 276, 276, 276, 276,  -8, 334, 289, 335, 336,  -4,
  -3,  -3, 285,  -3,  -3, 276, 276, 315, 285, 285,
 285,  -3,  -3,  -3, -13, -10, -10, -19, -10, -10,
 -10, -10, -10, -10, -10, -10, -10, -10,  -4,  -4,
  -4,  -4, 285, 285,  -3, 285, 285, -20, -21,  -3,
  -3,  -3,  -3, 285, 285, 285, 277, 282, -14, 293,
 280, 322, 326, 325, 277, -11, -12, 283, 318, 280,
 281, 284, 295, 301, 300, 299, 298, 297,  -7, 277,
  -9, -12, -22, 275, 278, 262, 257, 269, 266, 259,
 268, 265, 261, 258, 277, 277, 277, 277, 277, 277,
 277, 277, 277, 277,  -3,  -3, 285,  -3,  -3, -15,
 -15, 285, 285, 285, 285, 275,  -3,  -3,  -3, 278,
  -3,  -3,  -3, 278, 278,  -3,  -3,  -3, 278, 294,
  -3,  -3,  -3,  -3, 275, 277, 334, 335, 289,  -9,
 275, 275, 275, 275, 275, 275, 275, 275, 275, 285,
 285,  -3, 285, 285, 277, -16, -12, 330, 329, 331,
 315, 332, 333, 277,  -3,  -3,  -3,  -3, 279, 285,
 285, 285,  -3,  -3,  -3, 285,  -3,  -5,  -6, 278,
 275,  -4, 285,  -9,  -9,  -9, 279, 276, 276, 276,
 276, 276, 276, 276, 276, 276,  -3,  -3,  -3,  -3,
 275,  -3,  -3,  -3,  -3, 275, 285,  -3,  -3,  -3,
 285, 285, 285,  -3, 285, 340,  -5, 334, 289,  -5,
 338,  -3, -10, -10, -10, -10, -10, -10, -10, -10,
 -19, 279, 285, 279, 279, 285, 285, 285,  -3, 279,
 279, 285,  -3,  -3,  -3, 285,  -3,  -4,  -5,  -5,
 279, 276, 285, 277, 277, 277, 277, 277, 277, 277,
 277,  -9,  -3,  -3,  -3,  -3,  -3, 285, 285, 285,
  -3, 285, 294, 338, 271,  -3, 277, 285, 285, 285,
  -3,  -3,  -3,  -3, 276, 277,  -3,  -3,  -3, 279,
 279, 279, 279, 271, 285, 277,  -3, 285,  -3, 279 };
short yydef[]={

   7,  -2,   0,   5,   0,   6,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  18,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  29,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   2,   4,  19,   3,  30,
   8,   9, 113,   0, 119, 120,  10,  11,  12,   0,
   0,   0,  16,  17,  60,  61,   0,   0,   0,   0,
   0,   0,   0,   0,  72,  73,  74,   0,   0,   0,
  21,  44,  44,  87,  44,  44,  44,  44,  44,  44,
  44,  44,  44,  44,   1,   0,   0,   0,   0, 118,
   0,   0,   0,   0,   0,  64,  66,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 114, 115,
 116, 117,   0,   0,   0,   0,   0,  78,  78,   0,
   0,   0,   0,   0,   0,   0,  20,   0,  23,   0,
   0,   0,   0,   0,  31,  45,  46,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  59,  32,
   0,  88,  89,  99,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  34,  35,  36,  37,  38,  39,
  40,  41,  42,  43,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  25,  26,  27,   0,   0,  48,  49,   0,   0,   0,
   0,  55,  56,  57,  58,  33,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,  65,  79,  80,   0,   0,   0,
   0,   0,   0,  67,  68,  69,   0,  71,  75,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 104,   0,
 110, 112,   0, 100, 101, 102, 103,  44,  44,  44,
  44,  44,  44,  44,  44,  87,   0,   0,   0,   0,
  81,  82,   0,   0,   0,  86,   0,   0,   0,   0,
   0,   0,   0,  50,   0,   0, 105,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  13,   0,  62,  63,   0,   0,   0,  70,  76,
  77,   0,   0,   0,   0,   0,   0,   0, 108, 109,
 106,   0,   0,  90,  91,  92,  93,  94,  95,  96,
  97,   0,   0,   0,  84,   0,  22,   0,   0,   0,
  51,   0,  53,   0,   0,  54,  98,   0,   0,   0,
   0,   0,   0,   0,   0, 111,   0,  83,  85,  24,
  28,  47,  52,   0,   0, 107,   0,   0,   0,  14 };
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar 1.6 88/02/08 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 8:
# line 116 "gram.y"
{
		title = yypvt[-0].y_str;
	  } break;
case 9:
# line 120 "gram.y"
{
		if (yypvt[-0].y_flt == 0.0 || yypvt[-0].y_flt == 360.0)
			fatal("art: idiotic angle in field of view.\n");

		focallength = -1.0 / tan(M_PI / 360.0 * yypvt[-0].y_flt);
	  } break;
case 10:
# line 127 "gram.y"
{
		raysperpix = yypvt[-0].y_flt;
	  } break;
case 11:
# line 131 "gram.y"
{
		twentyfivebit(TRUE);
	  } break;
case 12:
# line 135 "gram.y"
{
		twentyfivebit(FALSE);
	  } break;
case 13:
# line 139 "gram.y"
{
		up.x = yypvt[-5].y_flt;
		up.y = yypvt[-3].y_flt;
		up.z = yypvt[-1].y_flt;
	  } break;
case 14:
# line 145 "gram.y"
{
		vector	t, u, s, v;
		matrix	m, tmp;
		double	vy, vz, sinval, cosval, d1, d2, d3;

		/*
		 * apply the twist
		 */
		sinval = sin(yypvt[-1].y_flt * M_PI / 180.0);
		cosval = cos(yypvt[-1].y_flt * M_PI / 180.0);
		mident4(m);
		m[0][0] = cosval;
		m[0][1] = -sinval;
		m[1][0] = sinval;
		m[1][1] = cosval;
		mcpy4(tmp, trans);
		mmult4(trans, tmp, m);

		/*
		 * calculate the lookat
		 */
		t.x = yypvt[-13].y_flt - yypvt[-7].y_flt;
		t.y = yypvt[-11].y_flt - yypvt[-5].y_flt;
		t.z = yypvt[-9].y_flt - yypvt[-3].y_flt;

		u.x = up.x;
		u.y = up.y;
		u.z = up.z;

		normalise(t);

		normalise(u);

		vz = dprod(t, u);

		if (fabs(vz) >= 1.0)
			fatal("art: up vector and direction of view are the same.\n");

		vy = sqrt(1.0 - vz * vz);

		u.x = (u.x - vz * t.x) / vy;
		u.y = (u.y - vz * t.y) / vy;
		u.z = (u.z - vz * t.z) / vy;

		xprod(s, u, t);

		mident4(m);

		m[0][0] = s.x;
		m[0][1] = s.y;
		m[0][2] = s.z;

		m[1][0] = u.x;
		m[1][1] = u.y;
		m[1][2] = u.z;

		m[2][0] = t.x;
		m[2][1] = t.y;
		m[2][2] = t.z;

		mcpy4(tmp, trans);
		mmult4(trans, tmp, m);

		mident4(m);
		m[3][0] = yypvt[-13].y_flt;
		m[3][1] = yypvt[-11].y_flt;
		m[3][2] = yypvt[-9].y_flt;
		mcpy4(tmp, trans);
		mmult4(trans, tmp, m);

		astackp->mcopy = TRUE;
	  } break;
case 15:
# line 218 "gram.y"
{
		backcol.r = yypvt[-4].y_flt;
		backcol.g = yypvt[-2].y_flt;
		backcol.b = yypvt[-0].y_flt;
	  } break;
case 16:
# line 224 "gram.y"
{
		maxhitlevel = yypvt[-0].y_flt;
	  } break;
case 17:
# line 228 "gram.y"
{
		filetype = yypvt[-0].y_int;
	  } break;
case 18:
# line 234 "gram.y"
{
		lights = yypvt[-0].y_lht;
		lights->nxt = (light *)NULL;
	  } break;
case 19:
# line 239 "gram.y"
{
		yypvt[-0].y_lht->nxt = lights;
		lights = yypvt[-0].y_lht;
	  } break;
case 20:
# line 246 "gram.y"
{
		yyval.y_lht = lightinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 21:
# line 253 "gram.y"
{
		yyval.y_det = (details *)NULL;
	  } break;
case 22:
# line 257 "gram.y"
{
		astackp->s.c.r = yypvt[-4].y_flt;
		astackp->s.c.g = yypvt[-2].y_flt;
		astackp->s.c.b = yypvt[-0].y_flt;
		yyval.y_det = yypvt[-6].y_det;
	  } break;
case 23:
# line 264 "gram.y"
{
		yypvt[-0].y_det->nxt = yypvt[-1].y_det;
		yyval.y_det = yypvt[-0].y_det;
	  } break;
case 24:
# line 271 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = CENTER;
		yyval.y_det->u.v.x = yypvt[-5].y_flt;
		yyval.y_det->u.v.y = yypvt[-3].y_flt;
		yyval.y_det->u.v.z = yypvt[-1].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 25:
# line 280 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = RADIUS;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 26:
# line 287 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = NUMRAYS;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 27:
# line 294 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = ANGLE;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 28:
# line 301 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = DIRECTION;
		yyval.y_det->u.v.x = yypvt[-5].y_flt;
		yyval.y_det->u.v.y = yypvt[-3].y_flt;
		yyval.y_det->u.v.z = yypvt[-1].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 29:
# line 313 "gram.y"
{
		oblist = yypvt[-0].y_obj;
		oblist->nxt = (object *)NULL;
	  } break;
case 30:
# line 318 "gram.y"
{
		yypvt[-0].y_obj->nxt = oblist;
		oblist = yypvt[-0].y_obj;
	  } break;
case 31:
# line 325 "gram.y"
{
		if (astackp->scales.x == astackp->scales.y
		    && astackp->scales.y == astackp->scales.z)
			yyval.y_obj = sphereinit(yypvt[-1].y_det);
		else
			yyval.y_obj = ellipsinit(yypvt[-1].y_det);

		astackp--;
	  } break;
case 32:
# line 335 "gram.y"
{
		yyval.y_obj = boxinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 33:
# line 340 "gram.y"
{
		yyval.y_obj = yypvt[-1].y_obj;
		astackp--;
	  } break;
case 34:
# line 345 "gram.y"
{
		yyval.y_obj = ringinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 35:
# line 350 "gram.y"
{
		yyval.y_obj = polygoninit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 36:
# line 355 "gram.y"
{
		yyval.y_obj = geometryinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 37:
# line 360 "gram.y"
{
		yyval.y_obj = superinit(yypvt[-1].y_det, FALSE);
		astackp--;
	  } break;
case 38:
# line 365 "gram.y"
{
		yyval.y_obj = alginit(yypvt[-1].y_det, FALSE);
		astackp--;
	  } break;
case 39:
# line 370 "gram.y"
{
		yyval.y_obj = coneinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 40:
# line 375 "gram.y"
{
		yyval.y_obj = ellipsinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 41:
# line 380 "gram.y"
{
		yyval.y_obj = cylinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 42:
# line 385 "gram.y"
{
		yyval.y_obj = torusinit(yypvt[-1].y_det, FALSE);
		astackp--;
	  } break;
case 43:
# line 390 "gram.y"
{
		yyval.y_obj = compinit(yypvt[-1].y_det);
		astackp--;
	  } break;
case 44:
# line 397 "gram.y"
{
		yyval.y_det = (details *)NULL;
	  } break;
case 45:
# line 401 "gram.y"
{
		yypvt[-0].y_det->nxt = yypvt[-1].y_det;
		yyval.y_det = yypvt[-0].y_det;
	  } break;
case 46:
# line 406 "gram.y"
{
		yyval.y_det = yypvt[-1].y_det;
	  } break;
case 47:
# line 412 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = CENTER;
		yyval.y_det->u.v.x = yypvt[-5].y_flt;
		yyval.y_det->u.v.y = yypvt[-3].y_flt;
		yyval.y_det->u.v.z = yypvt[-1].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 48:
# line 421 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = ORDER;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 49:
# line 428 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = RADIUS;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 50:
# line 435 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = RADII;
		yyval.y_det->u.v.x = yypvt[-2].y_flt;
		yyval.y_det->u.v.y = yypvt[-0].y_flt;
		yyval.y_det->u.v.z = 0.0;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 51:
# line 444 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = RADII;
		yyval.y_det->u.v.x = yypvt[-4].y_flt;
		yyval.y_det->u.v.y = yypvt[-2].y_flt;
		yyval.y_det->u.v.z = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 52:
# line 453 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = VERTEX;
		yyval.y_det->u.v.x = yypvt[-5].y_flt;
		yyval.y_det->u.v.y = yypvt[-3].y_flt;
		yyval.y_det->u.v.z = yypvt[-1].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 53:
# line 462 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = EQUATION;
		yyval.y_det->u.t = (term *)smalloc(sizeof(term));
		yyval.y_det->u.t->coef = -yypvt[-1].y_flt;
		yyval.y_det->u.t->xp = 0;
		yyval.y_det->u.t->yp = 0;
		yyval.y_det->u.t->zp = 0;
		yyval.y_det->u.t->nxt = yypvt[-3].y_trm;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 54:
# line 474 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = COEFFS;
		yyval.y_det->u.v.x = yypvt[-4].y_flt;
		yyval.y_det->u.v.y = yypvt[-2].y_flt;
		yyval.y_det->u.v.z = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 55:
# line 483 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = CONST;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 56:
# line 490 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = TOP;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 57:
# line 497 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = BASE;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 58:
# line 504 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = OFFFILE;
		yyval.y_det->u.s = yypvt[-0].y_str;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 59:
# line 511 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = OBJECT;
		yyval.y_det->u.obj = yypvt[-0].y_obj;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 60:
# line 520 "gram.y"
{
		astackp->options |= yypvt[-1].y_int;
	  } break;
case 61:
# line 524 "gram.y"
{
		astackp->options &= ~yypvt[-1].y_int;
	  } break;
case 62:
# line 528 "gram.y"
{
		astackp->s.txtlist->txt.refset = TRUE;
		astackp->s.txtlist->txt.vref1.x = yypvt[-5].y_flt;
		astackp->s.txtlist->txt.vref1.y = yypvt[-3].y_flt;
		astackp->s.txtlist->txt.vref1.z = yypvt[-1].y_flt;

		normalise(astackp->s.txtlist->txt.vref1);
	  } break;
case 63:
# line 537 "gram.y"
{
		astackp->s.txtlist->txt.vref2.x = yypvt[-5].y_flt;
		astackp->s.txtlist->txt.vref2.y = yypvt[-3].y_flt;
		astackp->s.txtlist->txt.vref2.z = yypvt[-1].y_flt;

		normalise(astackp->s.txtlist->txt.vref2);
	  } break;
case 64:
# line 544 "gram.y"
{
		mident4(astackp->m);
		astackp->scales.x = astackp->scales.y = astackp->scales.z = 1.0;
	  } break;
case 65:
# line 548 "gram.y"
{
		tlist	*tl;

		tl = textureinit(yypvt[-4].y_str, yypvt[-1].y_det);

		astackp--;

		tl->nxt = astackp->s.txtlist;
		astackp->s.txtlist = tl;
	  } break;
case 66:
# line 558 "gram.y"
{
		mident4(astackp->m);
		astackp->scales.x = astackp->scales.y = astackp->scales.z = 1.0;
	  } break;
case 67:
# line 562 "gram.y"
{
		tlist	*tl;
		details	d;

		tl = textureinit("tile", yypvt[-1].y_det);

		astackp--;

		tl->nxt = astackp->s.txtlist;
		astackp->s.txtlist = tl;
	  } break;
case 68:
# line 574 "gram.y"
{
		tlist	*tl;

		tl = (tlist *)smalloc(sizeof(tlist));
		tl->txt.type = TILE;
		tl->txtcol = (void (*)())NULL;
		tl->txt.refset = FALSE;
		tl->txt.scalew = 1.0;
		tl->txt.scaleh = 1.0;

		tileinit(&tl->txt, yypvt[-4].y_str, yypvt[-2].y_flt, yypvt[-0].y_flt);

		tl->txt.mat[0][0] = tl->txt.mat[1][1] = tl->txt.mat[2][2] = 1.0;
		tl->txt.mat[0][1] = tl->txt.mat[0][2] = 0.0;
		tl->txt.mat[1][0] = tl->txt.mat[1][2] = 0.0;
		tl->txt.mat[2][0] = tl->txt.mat[2][1] = 0.0;

		tl->txt.scales.x = tl->txt.scales.y = tl->txt.scales.z = 1.0;
		tl->txt.trans.x = tl->txt.trans.y = tl->txt.trans.z = 0.0;

		tl->nxt = astackp->s.txtlist;
		astackp->s.txtlist = tl;
	  } break;
case 69:
# line 598 "gram.y"
{
		astackp->s.c.r = yypvt[-4].y_flt;
		astackp->s.c.g = yypvt[-2].y_flt;
		astackp->s.c.b = yypvt[-0].y_flt;
	  } break;
case 70:
# line 604 "gram.y"
{
		astackp->s.ri = yypvt[-6].y_flt;
		astackp->s.kd = yypvt[-4].y_flt;
		astackp->s.ks = yypvt[-2].y_flt;
		astackp->s.ksexp = yypvt[-0].y_flt;
	  } break;
case 71:
# line 611 "gram.y"
{
		astackp->s.a.r = yypvt[-4].y_flt;
		astackp->s.a.g = yypvt[-2].y_flt;
		astackp->s.a.b = yypvt[-0].y_flt;
	  } break;
case 72:
# line 617 "gram.y"
{
		astackp->s.refl = yypvt[-0].y_flt;
	  } break;
case 73:
# line 621 "gram.y"
{
		astackp->s.trans = yypvt[-0].y_flt;
	  } break;
case 74:
# line 625 "gram.y"
{
		astackp->s.absorb = yypvt[-0].y_flt;
	  } break;
case 75:
# line 629 "gram.y"
{
		rotate(yypvt[-3].y_flt, *yypvt[-1].y_str);
	  } break;
case 76:
# line 633 "gram.y"
{
		translate(yypvt[-5].y_flt, yypvt[-3].y_flt, yypvt[-1].y_flt);
	  } break;
case 77:
# line 637 "gram.y"
{
		scale(yypvt[-5].y_flt, yypvt[-3].y_flt, yypvt[-1].y_flt);
	  } break;
case 78:
# line 643 "gram.y"
{
		yyval.y_det = (details *)NULL;
	  } break;
case 79:
# line 647 "gram.y"
{
		yypvt[-0].y_det->nxt = yypvt[-1].y_det;
		yyval.y_det = yypvt[-0].y_det;
	  } break;
case 80:
# line 652 "gram.y"
{
		yyval.y_det = yypvt[-1].y_det;
	  } break;
case 81:
# line 658 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = MAP;
		yyval.y_det->u.s = yypvt[-0].y_str;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 82:
# line 665 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = RANGE;
		yyval.y_det->u.f = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 83:
# line 672 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = BLENDCOLOR;
		yyval.y_det->u.v.x = yypvt[-4].y_flt;
		yyval.y_det->u.v.y = yypvt[-2].y_flt;
		yyval.y_det->u.v.z = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 84:
# line 681 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = SIZE;
		yyval.y_det->u.v.x = yypvt[-2].y_flt;
		yyval.y_det->u.v.y = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 85:
# line 689 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = SCALEFACTORS;
		yyval.y_det->u.v.x = yypvt[-4].y_flt;
		yyval.y_det->u.v.y = yypvt[-2].y_flt;
		yyval.y_det->u.v.z = yypvt[-0].y_flt;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 86:
# line 698 "gram.y"
{
		yyval.y_det = (details *)smalloc(sizeof(details));
		yyval.y_det->type = VORTFILE;
		yyval.y_det->u.s = yypvt[-0].y_str;
		yyval.y_det->nxt = (details *)NULL;
	  } break;
case 90:
# line 712 "gram.y"
{
		if (astackp->scales.x == astackp->scales.y
		    && astackp->scales.y == astackp->scales.z)
			savecsgobj(yypvt[-3].y_str, sphereinit(yypvt[-1].y_det));
		else
			savecsgobj(yypvt[-3].y_str, ellipsinit(yypvt[-1].y_det));
		astackp--;
	  } break;
case 91:
# line 721 "gram.y"
{
		savecsgobj(yypvt[-3].y_str, boxinit(yypvt[-1].y_det));
		astackp--;
	  } break;
case 92:
# line 726 "gram.y"
{
		savecsgobj(yypvt[-3].y_str, superinit(yypvt[-1].y_det, TRUE));
		astackp--;
	  } break;
case 93:
# line 731 "gram.y"
{
		savecsgobj(yypvt[-3].y_str, alginit(yypvt[-1].y_det, TRUE));
		astackp--;
	  } break;
case 94:
# line 736 "gram.y"
{
		savecsgobj(yypvt[-3].y_str, coneinit(yypvt[-1].y_det));
		astackp--;
	  } break;
case 95:
# line 741 "gram.y"
{
		savecsgobj(yypvt[-3].y_str, ellipsinit(yypvt[-1].y_det));
		astackp--;
	  } break;
case 96:
# line 746 "gram.y"
{
		savecsgobj(yypvt[-3].y_str, cylinit(yypvt[-1].y_det));
		astackp--;
	  } break;
case 97:
# line 751 "gram.y"
{
		savecsgobj(yypvt[-3].y_str, torusinit(yypvt[-1].y_det, TRUE));
		astackp--;
	  } break;
case 98:
# line 756 "gram.y"
{
		savecsgobj(yypvt[-4].y_str, yypvt[-1].y_obj);
		astackp--;
	  } break;
case 99:
# line 764 "gram.y"
{
		yyval.y_obj = getcsgobj(yypvt[-0].y_str);
	  } break;
case 100:
# line 768 "gram.y"
{
		yyval.y_obj = getcsgexp(UNION, yypvt[-2].y_obj, yypvt[-0].y_obj);
	  } break;
case 101:
# line 772 "gram.y"
{
		yyval.y_obj = getcsgexp(INTERSECT, yypvt[-2].y_obj, yypvt[-0].y_obj);
	  } break;
case 102:
# line 776 "gram.y"
{
		yyval.y_obj = getcsgexp(SUBTRACT, yypvt[-2].y_obj, yypvt[-0].y_obj);
	  } break;
case 103:
# line 780 "gram.y"
{
		yyval.y_obj = yypvt[-1].y_obj;
	  } break;
case 104:
# line 786 "gram.y"
{
		yyval.y_trm = yypvt[-0].y_trm;
	  } break;
case 105:
# line 790 "gram.y"
{
		term	*t, *p, *np, *prod;
		int	i;

		prod = (term *)NULL;
		for (p = yypvt[-1].y_trm; p != (term *)NULL; p = p->nxt) {
			for (np = yypvt[-0].y_trm; np != (term *)NULL; np = np->nxt) {
				t = (term *)smalloc(sizeof(term));
				*t = *np;
				t->coef *= p->coef;
				t->xp += p->xp;
				t->yp += p->yp;
				t->zp += p->zp;
				t->nxt = prod;
				prod = t;
			}
		}

		for (t = yypvt[-1].y_trm; t != (term *)NULL; t = np) {
			np = t->nxt;
			free(t);
		}

		for (t = yypvt[-0].y_trm; t != (term *)NULL; t = np) {
			np = t->nxt;
			free(t);
		}

		yyval.y_trm = prod;
	  } break;
case 106:
# line 821 "gram.y"
{
		yyval.y_trm = yypvt[-1].y_trm;
	  } break;
case 107:
# line 825 "gram.y"
{
		term	*t, *p, *np, *prod, *nprod;
		int	i;

		prod = yypvt[-5].y_trm;

		for (i = 1; i != yypvt[-1].y_int; i++) {		/* expand out list */
			nprod = (term *)NULL;
			for (p = yypvt[-5].y_trm; p != (term *)NULL; p = p->nxt) {
				for (np = prod; np != (term *)NULL; np = np->nxt) {
					t = (term *)smalloc(sizeof(term));
					*t = *np;
					t->coef *= p->coef;
					t->xp += p->xp;
					t->yp += p->yp;
					t->zp += p->zp;
					t->nxt = nprod;
					nprod = t;
				}
			}
			if (prod != yypvt[-5].y_trm)
				for (t = prod; t != (term *)NULL; t = np) {
					np = t->nxt;
					free(t);
				}
			prod = nprod;
		}

		for (t = yypvt[-5].y_trm; t != (term *)NULL; t = np) {
			np = t->nxt;
			free(t);
		}

		yyval.y_trm = prod;
	  } break;
case 108:
# line 861 "gram.y"
{
		term	*p;

		for (p = yypvt[-0].y_trm; p->nxt != (term *)NULL; p = p->nxt)
			;
		yyval.y_trm = yypvt[-0].y_trm;
		p->nxt = yypvt[-2].y_trm;
	  } break;
case 109:
# line 870 "gram.y"
{
		term	*p, *lp;

		for (p = yypvt[-0].y_trm; p != (term *)NULL; p = p->nxt) {
			p->coef *= -1.0;
			lp = p;
		}

		yyval.y_trm = yypvt[-0].y_trm;
		lp->nxt = yypvt[-2].y_trm;
	  } break;
case 110:
# line 884 "gram.y"
{
		char	*p;

		yyval.y_trm = (term *)smalloc(sizeof(term));
		yyval.y_trm->coef = 1;
		yyval.y_trm->xp = 0;
		yyval.y_trm->yp = 0;
		yyval.y_trm->zp = 0;
		yyval.y_trm->nxt = (term *)NULL;

		for (p = yypvt[-0].y_str; *p != 0; p++)
			switch (*p) {
			case 'x':
				yyval.y_trm->xp += 1;
				break;
			case 'y':
				yyval.y_trm->yp += 1;
				break;
			case 'z':
				yyval.y_trm->zp += 1;
				break;
			default:
				fatal("art: illegal name in equation.\n");
			}
	  } break;
case 111:
# line 910 "gram.y"
{
		char	*p;

		yyval.y_trm = (term *)smalloc(sizeof(term));
		yyval.y_trm->coef = 1;
		yyval.y_trm->xp = 0;
		yyval.y_trm->yp = 0;
		yyval.y_trm->zp = 0;
		yyval.y_trm->nxt = (term *)NULL;

		for (p = yypvt[-4].y_str; *p != 0; p++)
			switch (*p) {
			case 'x':
				yyval.y_trm->xp += 1;
				break;
			case 'y':
				yyval.y_trm->yp += 1;
				break;
			case 'z':
				yyval.y_trm->zp += 1;
				break;
			default:
				fatal("art: illegal name in equation.\n");
			}

		p--;

		switch (*p) {
		case 'x':
			yyval.y_trm->xp += yypvt[-1].y_int - 1;
			break;
		case 'y':
			yyval.y_trm->yp += yypvt[-1].y_int - 1;
			break;
		case 'z':
			yyval.y_trm->zp += yypvt[-1].y_int - 1;
			break;
		default:
			fatal("art: illegal name in equation.\n");
		}
	  } break;
case 112:
# line 952 "gram.y"
{
		yyval.y_trm = (term *)smalloc(sizeof(term));
		yyval.y_trm->coef = yypvt[-0].y_flt;
		yyval.y_trm->xp = 0;
		yyval.y_trm->yp = 0;
		yyval.y_trm->zp = 0;
		yyval.y_trm->nxt = (term *)NULL;
	  } break;
case 113:
# line 963 "gram.y"
{
		yyval.y_flt = yypvt[-0].y_flt;
	  } break;
case 114:
# line 967 "gram.y"
{
		yyval.y_flt = yypvt[-2].y_flt + yypvt[-0].y_flt;
	  } break;
case 115:
# line 971 "gram.y"
{
		yyval.y_flt = yypvt[-2].y_flt - yypvt[-0].y_flt;
	  } break;
case 116:
# line 975 "gram.y"
{
		yyval.y_flt = yypvt[-2].y_flt * yypvt[-0].y_flt;
	  } break;
case 117:
# line 979 "gram.y"
{
		yyval.y_flt = yypvt[-2].y_flt / yypvt[-0].y_flt;
	  } break;
case 118:
# line 983 "gram.y"
{
		yyval.y_flt = -yypvt[-0].y_flt;
	  } break;
case 119:
# line 989 "gram.y"
{
		yyval.y_flt = yypvt[-0].y_flt;
	  } break;
case 120:
# line 993 "gram.y"
{
		yyval.y_flt = yypvt[-0].y_int;
	  } break;
		}
		goto yystack;  /* stack new state and value */

	}
