#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp;
extern hlist	*fhlist;

/*
 * boxi
 *
 *	returns a list of intersection points for the ray r and box o.
 */
hlist *
boxi(r, o, last)
	register ray	*r;
	register object	*o;
	hlist		**last;
{
	hlist		*hitlist, *hp;
	int		faces[2];
	register int	face, *fp;
	register float	x, y, z, t, *tp;
	ray		nr;
	vector		cv;
	float		ts[2];

	vadd(cv, r->org, o->bs.cent);
	t = dprod(cv, r->dir);

	if ((dprod(cv, cv) - o->bs.radsqu) > t * t)
		return((hlist *)NULL);

	transray(o, nr, *r);

	tp = ts - 1;
	fp = faces;

	ts[0] = 0.0;
	faces[0] = faces[1] = NOFACE;

	if (nr.dir.z != 0.0) {
		t = (1.0 - nr.org.z) / nr.dir.z;
		x = t * nr.dir.x + nr.org.x;
		y = t * nr.dir.y + nr.org.y;
		if ((x <= 1.0 && x >= 0.0) && (y <= 1.0 && y >= 0.0)) {
			*++tp = t;
			*fp++ = ZFACE;
		}
		t = -nr.org.z / nr.dir.z;
		x = t * nr.dir.x + nr.org.x;
		y = t * nr.dir.y + nr.org.y;
		if ((x <= 1.0 && x >= 0.0) && (y <= 1.0 && y >= 0.0)) {
			if (*fp == NOFACE || fabs(*tp - t) > TOLERANCE) {
				*++tp = t;
				*fp++ = ZFACE;
			}
		}
	}

	if (tp != &ts[1] && nr.dir.x != 0.0) {
		t = (1.0 - nr.org.x) / nr.dir.x;
		z = t * nr.dir.z + nr.org.z;
		y = t * nr.dir.y + nr.org.y;
		if ((z <= 1.0 && z >= 0.0) && (y <= 1.0 && y >= 0.0)) {
			if (*fp == NOFACE || fabs(*tp - t) > TOLERANCE) {
				*++tp = t;
				*fp++ = XFACE;
			}
		}
		t = -nr.org.x / nr.dir.x;
		z = t * nr.dir.z + nr.org.z;
		y = t * nr.dir.y + nr.org.y;
		if ((z <= 1.0 && z >= 0.0) && (y <= 1.0 && y >= 0.0)) {
			if (*fp == NOFACE || fabs(*tp - t) > TOLERANCE) {
				*++tp = t;
				*fp++ = XFACE;
			}
		}
	}

	if (tp != &ts[1] && nr.dir.y != 0.0) {
		t = (1.0 - nr.org.y) / nr.dir.y;
		x = t * nr.dir.x + nr.org.x;
		z = t * nr.dir.z + nr.org.z;
		if ((z <= 1.0 && z >= 0.0) && (x <= 1.0 && x >= 0.0)) {
			if (*fp == NOFACE || fabs(*tp - t) > TOLERANCE) {
				*++tp = t;
				*fp++ = YFACE;
			}
		}
		t = -nr.org.y / nr.dir.y;
		x = t * nr.dir.x + nr.org.x;
		z = t * nr.dir.z + nr.org.z;
		if ((z <= 1.0 && z >= 0.0) && (x <= 1.0 && x >= 0.0)) {
			if (*fp == NOFACE || fabs(*tp - t) > TOLERANCE) {
				*++tp = t;
				*fp++ = YFACE;
			}
		}
	}

	if (tp == &ts[1]) {
		if ((ts[1] > TOLERANCE && ts[1] < ts[0]) || ts[0] < TOLERANCE) {
			t = ts[0];
			ts[0] = ts[1];
			ts[1] = t;
			face = faces[0];
			faces[0] = faces[1];
			faces[1] = face;
		}

		if (ts[0] > TOLERANCE && ts[0] != ts[1]) {
			fetch(hp);
			hitlist = hp;
			hitlist->obj = o;
			hitlist->type = faces[0];
			hitlist->t = ts[0];
			if (ts[1] > TOLERANCE) {
				fetch(hp);
				hitlist->nxt = hp;
				hp->obj = o;
				hp->type = faces[1];
				hp->t = ts[1];
			}
			hp->nxt = (hlist *)NULL;
			*last = hp;
			return(hitlist);
		}
	}

	return((hlist *)NULL);
}

/*
 * boxn
 *
 *	returns the normal to the box b
 */
/*ARGSUSED*/
void
boxn(n, l, o, type)
	register vector	*n;
	vector		*l;
	object		*o;
	int		type;
{
	vector		v;

	v.x = 0.0;
	v.y = 0.0;
	v.z = 0.0;
	
	switch (type) {
	case XFACE:
		v.x = 1.0;
		break;
	case YFACE:
		v.y = 1.0;
		break;
	case ZFACE:
		v.z = 1.0;
		break;
	default:
		fatal("art: illegal face type in boxn.\n");
		exit(1);
	}

	if (o->mat != (mat3x3 *)NULL) {
		v3x3tmult(*n, v, (*o->mat));
	} else
		*n = v;
}

/*
 * boxinit
 *
 *	initialise the function pointers and extra field for a box object
 */
object *
boxinit(d)
	details *d;
{
	object	*o;
	int	first;
	vector	cent, c1, c2;
	details	*ld;

	o = (object *)smalloc(sizeof(object));
	o->type = BOX;
	o->intersects = boxi;
	o->normal = boxn;

	first = 1;

	while (d != (details *)NULL) {
		switch (d->type) {
		case VERTEX:
			if (first) {
				c1 = d->u.v;
				first = 0;
			} else
				c2 = d->u.v;
			break;
		default:
			warning("art: illegal field in box ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	cent.x = (c1.x + c2.x) / 2.0;
	cent.y = (c1.y + c2.y) / 2.0;
	cent.z = (c1.z + c2.z) / 2.0;

	makebsphere(&o->bs, &cent, sqr(cent.x - c1.x) + sqr(cent.y - c1.y) + sqr(cent.z - c1.z));

	objtranslate(c1.x, c1.y, c1.z);

	scale(c2.x - c1.x, c2.y - c1.y, c2.z - c1.z);

	setattributes(o);

	return(o);
}
