#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vort.h"

extern char	*rindex();

#define	CMAPSIZE	256
#define	W_MIN_WIDTH	286
#define EV_MASK         KeyPressMask|ButtonReleaseMask|ExposureMask|ButtonPressMask
#define MAX(a, b)       ((a) > (b) ? (a) : (b))


static char		title[BUFSIZ], *myname, **titles;
static Display		*display;
static int		theScreen, depth;
static Colormap		cmap;
static Window		winder, rootw;
static GC		theGC;
static Visual		*visual;
static Pixmap		pm;
static XImage		*xi, **xip;
static int		f, fnum;
static int		font_w, font_h, one = 1, color, dir, cur_frame = -1;
static unsigned short	oldw, oldh, do_titles, tlen, upsidedown;
static unsigned long	white, black;
static unsigned int	w, h, window_width, window_height;

static int		stopped, xf, lx1, lx2, px1, px2, rx1, rx2, sx1, sx2, qx1, qx2, by;

/*
 * program to read in a color-mapped image and display it on X11, greyscale
 * is used if the image is rgb.
 */
main(ac, av)
	int	ac;
	char	**av;
{
	register int	i, ox;
	int		val, x, y;
	unsigned char	v, *red, *green, *blue, *line, *l;
	image		*im;
	XEvent		event;

        if ((myname = rindex(av[0],'/')) == NULL)
                myname = av[0];
        else
                *myname++;

	if (ac < 2) {
                fprintf(stderr, "usage: %s [-t] [-u] files\n", myname);
                exit(1);
        }

	tlen = 0;
        do_titles = 0;
        upsidedown = 0;

        for (f = 1; f < ac && *av[f] == '-'; f++) {
                if (strcmp(av[f], "-t") == 0) {
                        do_titles = 1;
                } else if (strcmp(av[f], "-u") == 0) {
                        upsidedown = 1;
                }
        }


	xip = (XImage **)malloc((ac - f) * sizeof(XImage *));

        if (do_titles)
                titles = (char **)malloc(sizeof(char *) * (ac - f));


	strcpy(title, myname);
	strcat(title, ": ");

	if ((display = XOpenDisplay((char *)NULL)) == NULL) {
		fprintf(stderr, "Can't open display %s\n", XDisplayName((char *)NULL));
		exit(1);
	}

	theScreen = DefaultScreen(display);
	if ((depth = XDisplayPlanes(display, theScreen)) < 8) {
		fprintf(stderr, "You need a 256 colour display device\n");
		exit(1);
	}

	visual = DefaultVisual(display, theScreen);
	rootw = RootWindow(display, theScreen);
	theGC = DefaultGC(display, theScreen);
	cmap = XCreateColormap(display, rootw, visual, AllocAll);

	read_files(ac, av);

	XMapWindow(display, winder);


        /*
         * Wait for Exposure event.
         */
        do {
                XNextEvent(display, &event);
        } while (event.type != Expose);

	XSetInputFocus(display, winder, RevertToParent, CurrentTime);

	makebuttons();
	stopped = 0;

	dir = 1;
	while (1) {
		if (!stopped)
			show_frame();
		else
			XSync(display, 0);

		if (QLength(display) > 0) {
			XCheckWindowEvent(display, winder, EV_MASK, &event);
			check_events(&event);
		}
	}
}

setcolormap(im)
	image	*im;
{
	int	i;
	XColor	carray[CMAPSIZE];
	unsigned long max, min, val;

	/* 
	 *  Set up the color map.  
	 */

	max = 0;
	min = 65325 * 4;

	color = 0;
	if (colormapped(im)) {
		color = 1;
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = (unsigned long)i;
			carray[i].red = (unsigned short)(im->red[i] << 8);
			carray[i].green = (unsigned short)(im->green[i] << 8);
			carray[i].blue = (unsigned short)(im->blue[i] << 8);
			carray[i].flags = DoRed | DoGreen | DoBlue;
			val = carray[i].blue + carray[i].green + carray[i].red;
			if (val < min) {
				min = val;
				black = i;
			}
			if (val >= max) {
				max = val;
				white = i;
			}
		}
	} else {
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = (unsigned long)i;
			carray[i].red = carray[i].green = carray[i].blue = (unsigned short)(i << 8);
			carray[i].flags = DoRed | DoGreen | DoBlue;
		}
		black = 0;
		white = 255;
	}

	XStoreColors(display, cmap, carray, CMAPSIZE);
}


makewindow(w, h)
	unsigned int	w, h;
{
	unsigned int		wattrmask;
	XSetWindowAttributes	wattr;
	XSizeHints		sizehints;
	XWMHints		wmhints;
	unsigned int		bw = 1;
	XGCValues		xgcvals;
	XFontStruct		*font;

	sizehints.flags = PPosition | PSize;
	sizehints.width = window_width;
	sizehints.height = h;
	sizehints.x = 0;
	sizehints.y = 0;


        wattr.background_pixel = BlackPixel(display, theScreen);
        wattr.border_pixel = WhitePixel(display, theScreen);
	wattr.colormap = cmap;
	wattrmask = CWBackPixel | CWBorderPixel | CWColormap;

	if ((font = XLoadQueryFont(display, "fixed")) == (XFontStruct *)NULL) {		
		fprintf(stderr, "Couldn't get font\n");
		exit(1);
	}

        font_h = font->max_bounds.ascent + font->max_bounds.descent;
        font_w = font->max_bounds.width;

        xgcvals.font = XLoadFont(display, "fixed");
        XChangeGC(display, theGC, GCFont, &xgcvals);

	window_width = (w < W_MIN_WIDTH ? W_MIN_WIDTH : w);
	window_height = h + font_h + 8 + (do_titles ? (8 + font_h) : 0);

	winder = XCreateWindow(display,
			rootw,
			0, 0,
			window_width, window_height,
			bw,
			depth,
			CopyFromParent,
			CopyFromParent,
			wattrmask,
			&wattr
		);

	XSetWindowColormap(display, winder, cmap);

	XSetStandardProperties(display,
			winder,
			title, 
			myname,
			None,
			(char **)NULL, 0,
			&sizehints
	);

        wmhints.initial_state = NormalState;
        wmhints.input = True;
        wmhints.flags = StateHint | InputHint;
        XSetWMHints(display, winder, &wmhints);

        XSelectInput(display, winder, EV_MASK);
}

makebuttons()
{
	by = font_h + 4;
	lx1 = 4;
	lx2 = lx1 + font_w * 4 + 4;
	drawbut(lx1, lx2, " << ", 0);

	px1 = lx2 + 4;
	px2 = px1 + font_w * 6 + 4;
	drawbut(px1, px2, " Play ", 0);

	rx1 = px2 + 4;
	rx2 = rx1 + font_w * 4 + 4;
	drawbut(rx1, rx2, " >> ", 0);

	sx1 = rx2 + 4;
	sx2 = sx1 + font_w * 6 + 4;
	drawbut(sx1, sx2, " Stop ", 0);

	xf = font_w * 12;
	XSetForeground(display, theGC, black);
	XSetBackground(display, theGC, white);
	XFillRectangle(display, winder, theGC, sx2 + 8, 5, xf , by);
	XSetForeground(display, theGC, white);
	XDrawString(display, winder, theGC, sx2 + 12, font_h + 3, "Frame: ", 7);
	xf = sx2 + 12 + 8 * font_w;

	qx1 = xf + 3 * font_w + 12;
	qx2 = qx1 + font_w * 6 + 4;
	drawbut(qx1, qx2, " QUIT ", 0);
}

drawbut(x1, x2,  text, invert)
	int	x1, x2, invert;
	char	*text;
{
	int		xc, yc;
	unsigned long	fore, back;
	XGCValues	xgcvals;

	if (invert) {
		fore = black;
		back = white;
	} else {
		fore = white;
		back = black;
	}

	XSetForeground(display, theGC, back);
	XSetBackground(display, theGC, fore);
	XFillRectangle(display, winder, theGC, x1, 4, (unsigned)(x2 - x1),(unsigned)by);
	XSetForeground(display, theGC, fore);
	XSetBackground(display, theGC, back);
	XDrawRectangle(display, winder, theGC, x1, 4, (unsigned)(x2 - x1),(unsigned)by);
	xc = (x2 + x1) / 2 - font_w * strlen(text) / 2; 
	yc = font_h + 3;
	XDrawString(display, winder, theGC, xc, yc, text, strlen(text));
}

#define IN_RECT(b, x1, x2)	((b)->x > x1 && (b)->x < x2 && (b)->y > 4 && (b)->y < by + 4)
#define LEFT(b)	IN_RECT((b), lx1, lx2)
#define PLAY(b)	IN_RECT((b), px1, px2)
#define RIGHT(b)	IN_RECT((b), rx1, rx2)
#define STOP(b)	IN_RECT((b), sx1, sx2)
#define QUIT(b)	IN_RECT((b), qx1, qx2)

check_events(event)
	XEvent	*event;
{
	int	i;
	XButtonEvent  	*button_event;

	button_event = (XButtonEvent *)event;
	if (event->type == ButtonRelease) {
		if (button_event->button == Button1) {
			if (LEFT(button_event)) {
				dir = -1;
				drawbut(lx1, lx2, " << ", 0);
				if (stopped)
					show_frame();

			} else if (PLAY(button_event)) {
				stopped = 0;
				drawbut(px1, px2, " Play ", 0);
			} else if (RIGHT(button_event)) {
				dir = 1;
				if (stopped)
					show_frame();
				drawbut(rx1, rx2, " >> ", 0);
			} else if (STOP(button_event)) {
				stopped = 1;
				drawbut(sx1, sx2, " Stop ", 0);
			} else if (QUIT(button_event)) {
				drawbut(qx1, qx2, " QUIT ", 0);
				XUnmapWindow(display, winder);
				XFreeGC(display, theGC);
				XFreeColormap(display, cmap);
				for (i = 0; i < fnum; i++)
					XDestroyImage(xip[i]);

				exit(0);
			}

		}

	} else if (event->type == ButtonPress) {
		if (LEFT(button_event)) 
			drawbut(lx1, lx2, " << ", 1);
		else if (PLAY(button_event))
			drawbut(px1, px2, " Play ", 1);
		else if (RIGHT(button_event))
			drawbut(rx1, rx2, " >> ", 1);
		else if (STOP(button_event))
			drawbut(sx1, sx2, " Stop ", 1);
		else if (QUIT(button_event))
			drawbut(qx1, qx2, " QUIT ", 1);

	} else if (event->type == Expose) {
		drawbut(lx1, lx2, " << ", 0);
		drawbut(px1, px2, " Play ", 0);
		drawbut(rx1, rx2, " >> ", 0);
		drawbut(sx1, sx2, " Stop ", 0);
		drawbut(qx1, qx2, " QUIT ", 0);
		xf = font_w * 12;
		XSetForeground(display, theGC, black);
		XSetBackground(display, theGC, white);
		XFillRectangle(display, winder, theGC, sx2 + 8, 5, xf , by);
		XSetForeground(display, theGC, white);
		XDrawString(display, winder, theGC, sx2 + 12, font_h + 3, "Frame: ", 7);
		xf = sx2 + 12 + 8 * font_w;

		if (stopped) {
			cur_frame--;
			show_frame();
		}
	}
}

show_frame()
{
	char	buf[12];
	int	n;

	cur_frame += dir;
	if (cur_frame >= fnum)
		cur_frame = 0;
	else if (cur_frame < 0)
		cur_frame = fnum - 1;

        /*
         * Copy it to the screen
         */

	XPutImage(display, 
		winder,
		theGC, 
		xip[cur_frame],
		0, 0, 
                0, font_h + 12,
                oldw, oldh
        );
	/*
	 * update frame number display...
	 */
	sprintf(buf, "%d", cur_frame);
	n = strlen(buf);
	XSetForeground(display, theGC, black);
	XFillRectangle(display, winder, theGC, xf, 5, 3 * font_w, by);
	XSetForeground(display, theGC, white);
	XDrawString(display, winder, theGC, xf, font_h + 3, buf, n);

	/*
	 * update the title (if any)
	 */
	if (do_titles) {
		n = strlen(titles[cur_frame]);
		XSetForeground(display, theGC, black);
		XFillRectangle(display, winder, theGC, 0, h + font_h + 12, window_width, by);
		XSetForeground(display, theGC, white);
		XDrawString(display, winder, theGC, 7, h + 2 * font_h + 12, titles[cur_frame], n);
	}

	
}

read_files(ac, av)
	int	ac;
	char	**av;
{
	u_char		*line, *red, *green, *blue;
	unsigned int	w2, bytes_per_line;
	int		x, y, len;
	char		*mem, *data;
	image		*im;

	imagebufsize(3 * 4096);

	for (fnum = f; fnum < ac; fnum++) {

		fprintf(stderr, "Reading file %s\n", av[fnum]);

		if ((im = openimage(av[fnum], "r")) == (image *)NULL) {
			fprintf(stderr, "disp: can't open file %s.\n", av[fnum]);
			exit(1);
		}

		w = imagewidth(im);
		h = imageheight(im);
		/*
		 * Make it all 32 bit aligned
		 */
		w2 = w + (w % 4);

		bytes_per_line = w2;

		if (one) {
			oldw = w;
			oldh = h;
			one = 0;
			setcolormap(im);
			line = (u_char *)malloc(w2);
			if (!colormapped(im)) {
				red = (u_char *)malloc(w);
				green = (u_char *)malloc(w);
				blue = (u_char *)malloc(w);
			}

		} else if (oldw != w || oldh != h) {
			fprintf(stderr, "All images must be the same size you dork!\n");
			exit(1);
		}

		len = titlelength(im);
                tlen = MAX(tlen, len);

                if (do_titles) {
                        if (len != 0) {
                                titles[fnum - f] = (char *)malloc((unsigned)len);
                                strcpy(titles[fnum - f], imagetitle(im));
                        } else {
                                titles[fnum - f] = (char *)malloc(1);
                                titles[fnum - f][0] = '\0';
                        }
                }


		/*
		 * Allocate the XImage for this frame 
		 */

		/*
		 * Get mem for data in image
		 */
		if ((mem = data = (char *)malloc((unsigned)(w2 * h))) == NULL) {
			fprintf(stderr, "mem = NULL\n");
			exit(0);
		}

		
		xi = xip[fnum - f] =  XCreateImage(display,
					visual,
					depth,
					ZPixmap,
					0,
					data,
					w2, (unsigned int)h,
					8, 0
				);

		if (xi == (XImage *)NULL) {
			fprintf(stderr, "Unable to create ximage\n");
			exit(1);
		}
		if (upsidedown)
			mem += (h - 1) * bytes_per_line;

		y = h - 1;

		if (colormapped(im)) {
			while (y >= 0) {
				readmappedline(im, line);
				bcopy(line, mem, (int)w);
				if (upsidedown)
					mem -= bytes_per_line;
				else
					mem += bytes_per_line;
				y--;
			}
		} else {
			while (y >= 0) {
				readrgbline(im, red, green, blue);
				for (x = 0; x < w; x++)
					line[x] = red[x] * 0.3 + green[x] * 0.59 + blue[x] * 0.11;
				bcopy(line, mem, (int)w);
				if (upsidedown)
					mem -= bytes_per_line;
				else
					mem += bytes_per_line;
				y--;
			}
		}
		closeimage(im);
	}

	fnum -= f;
	fprintf(stderr, "Finished reading %d of the damned files\n", fnum);

	tlen--;
        if (tlen <= 0)
                do_titles = 0;

	makewindow(w, h);
}
