#include <stdio.h>

extern int	linecount;
extern FILE	*logfile;

/*
 * yyerror
 *
 *	error routine for yacc, assumed fatal
 */
yyerror(s)
	char	*s;
{
	fprintf(stderr, "art: line %d - %s\n", linecount, s);
	fprintf(logfile, "art: line %d - %s\n", linecount, s);
	exit(1);
}

/*
 * message
 *
 *	log a message.
 */
message(s)
	char	*s;
{
	fprintf(logfile, s);
}

/*
 * warning
 *
 *	print and log a warning.
 */
warning(s)
	char	*s;
{
	fprintf(stderr, s);
	fprintf(logfile, s);
}

/*
 * fatal
 *
 *	print and log a fatal message and exit
 */
fatal(s)
	char	*s;
{
	fprintf(stderr, s);

	if (logfile != stdout)
		fprintf(logfile, s);

	exit(1);
}

