#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp;
extern matrix	trans;

/*
 * lightinit
 *
 *	initialise the function pointers and fields for a light object,
 * returning a pointer to it.
 */
light *
lightinit(d)
	details *d;
{
	light	*l;
	details	*ld;
	matrix	tmp;

	l = (light *)smalloc(sizeof(light));

	l->rad = l->cosang = 0.0;

		/* combine viewing and current transformation matrix */
	mmult4(tmp, trans, astackp->m);

	l->rays = 1;

	l->type = POINT;

	while (d != (details *)NULL) {
		switch (d->type) {
		case CENTER:
				/* transform light into ray space */
			d->u.v.x -= tmp[3][0];
			d->u.v.y -= tmp[3][1];
			d->u.v.z -= tmp[3][2];
			v3x3tmult(l->org, d->u.v, tmp);
			break;
		case DIRECTION:
			smult(d->u.v, -1.0);
			normalise(d->u.v);
			v3x3tmult(l->dir, d->u.v, tmp)
			l->type = DIRECTIONAL;
			break;
		case RADIUS:
			l->rad = d->u.f;
			break;
		case ANGLE:
			l->cosang = cos((double)d->u.f / 180.0 * M_PI);
			break;
		case NUMRAYS:
			l->rays = d->u.f;
			break;
		default:
			warning("art: illegal field in light ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	l->c.r = astackp->s.c.r / l->rays; 
	l->c.g = astackp->s.c.g / l->rays;
	l->c.b = astackp->s.c.b / l->rays;

	return(l);
}
