#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"

/*
 * inbbox
 *
 *	checks a ray against a bounding box returning TRUE if it intersects
 * FALSE otherwise. *pt1 and *pt2 are returned with the entry and exit
 * distances of the ray. If the ray is in the box *pt1 represents the
 * distance to the box in front of the observer, *pt2 the distance behind.
 */
int
inbbox(r, bb, pt1, pt2)
	register ray	*r;
	bbox		*bb;
	float		*pt1, *pt2;
{
	register int	hit;
	register float	x, y, z, t, *tp;
	register vector	*fvert, *bvert;
	float		ts[2];

	fvert = &bb->topfr;
	bvert = &bb->botbl;

	tp = ts - 1;
	hit = FALSE;

	if (r->dir.z != 0.0) {
		t = (fvert->z - r->org.z) / r->dir.z;
		x = t * r->dir.x + r->org.x;
		y = t * r->dir.y + r->org.y;
		if ((fvert->x - x) * (bvert->x - x) <= 0.0 && (fvert->y - y) * (bvert->y - y) <= 0.0) {
			*++tp = t;
			hit = TRUE;
		}
		t = (bvert->z - r->org.z) / r->dir.z;
		x = t * r->dir.x + r->org.x;
		y = t * r->dir.y + r->org.y;
		if ((fvert->x - x) * (bvert->x - x) <= 0.0 && (fvert->y - y) * (bvert->y - y) <= 0.0) {
			if (!hit || fabs(*tp - t) > TOLERANCE)
				*++tp = t;
			hit = TRUE;
		}
	}

	if (tp != &ts[1] && r->dir.x != 0.0) {
		t = (fvert->x - r->org.x) / r->dir.x;
		z = t * r->dir.z + r->org.z;
		y = t * r->dir.y + r->org.y;
		if ((fvert->z - z) * (bvert->z - z) <= 0.0 && (fvert->y - y) * (bvert->y - y) <= 0.0) {
			if (!hit || fabs(*tp - t) > TOLERANCE)
				*++tp = t;
			hit = TRUE;
		}
		t = (bvert->x - r->org.x) / r->dir.x;
		z = t * r->dir.z + r->org.z;
		y = t * r->dir.y + r->org.y;
		if ((fvert->z - z) * (bvert->z - z) <= 0.0 && (fvert->y - y) * (bvert->y - y) <= 0.0) {
			if (!hit || fabs(*tp - t) > TOLERANCE)
				*++tp = t;
			hit = TRUE;
		}
	}

	if (tp != &ts[1] && r->dir.y != 0.0) {
		t = (fvert->y - r->org.y) / r->dir.y;
		x = t * r->dir.x + r->org.x;
		z = t * r->dir.z + r->org.z;
		if ((fvert->z - z) * (bvert->z - z) <= 0.0 && (fvert->x - x) * (bvert->x - x) <= 0.0) {
			if (!hit || fabs(*tp - t) > TOLERANCE)
				*++tp = t;
			hit = TRUE;
		}
		t = (bvert->y - r->org.y) / r->dir.y;
		x = t * r->dir.x + r->org.x;
		z = t * r->dir.z + r->org.z;
		if ((fvert->z - z) * (bvert->z - z) <= 0.0 && (fvert->x - x) * (bvert->x - x) <= 0.0) {
			if (!hit || fabs(*tp - t) > TOLERANCE)
				*++tp = t;
		}
	}

	if (tp == &ts[1]) {
		if ((ts[1] > TOLERANCE && ts[1] < ts[0]) || ts[0] < TOLERANCE) {
			*pt2 = ts[0];
			*pt1 = ts[1];
		} else {
			*pt1 = ts[0];
			*pt2 = ts[1];
		}
	} else
		return(FALSE);
		
	return(*pt1 > 0.0);
}
