#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vort.h"

#define	CMAPSIZE	256

static Window	winder;
static Display	*display;
static Screen	*screen;
static int	screennum;
static Colormap	cmap;

XWMHints	mgrhints = {
	(InputHint | StateHint),	/* flags */
	False,				/* input */
	NormalState,			/* initial_state */
	0,				/* icon pixmap */
	0,				/* icon window */
	0, 0,				/* icon locaation */
	0,				/* icon mask */
	0,				/* Window Group */
};

static Drawable	drawable;
static GC	gc;

static XColor	carray[CMAPSIZE];

extern char	*rindex();

/*
 * program to read in a color-mapped image and display it on X11, greyscale
 * is used if the image is rgb.
 */
main(ac, av)
	int	ac;
	char	**av;
{
	char		*pt, title[BUFSIZ], name[BUFSIZ], buf[BUFSIZ];
	int		i, ox;
	unsigned short	h, w;
	int		val, x, y;
	unsigned char	v, *red, *green, *blue, *alpha;
	image		*im;
	int		bw, depth, mask;
	Window		rootw, childw;
	Visual		*visual;
	XSizeHints	hints;
	XSetWindowAttributes	wattr;

	if (ac != 2) {
		fprintf(stderr, "disp: usage disp file.\n");
		exit(1);
	}

	if ((im = openimage(av[1], "r")) == (image *)NULL) {
		fprintf(stderr, "disp: can't open file %s.\n", av[1]);
		exit(1);
	}

	if ((pt = rindex(av[0], '/')) != (char *)NULL)
		strcpy(name, pt + 1);
	else
		strcpy(name, av[0]);

	display = XOpenDisplay((char *)NULL);

	winder = XDefaultRootWindow(display);

	screennum = XDefaultScreen(display);

	screen = XDefaultScreenOfDisplay(display);

	w = imagewidth(im);
	h = imageheight(im);

	red = (unsigned char *)malloc(w);
	green = (unsigned char *)malloc(w);
	blue = (unsigned char *)malloc(w);
	alpha = (unsigned char *)malloc(w);

	winder = XCreateSimpleWindow(display, XDefaultRootWindow(display), 0, 0, w, h, bw, 0, 0);

	hints.flags = (PPosition | PSize);
	hints.x = 0;
	hints.y = 0;
	hints.width = w;
	hints.height = h;

	XSetStandardProperties(display, winder, name, name, None, av, ac, &hints);
	XSetWMHints(display, winder, &mgrhints);

	drawable = (Drawable)winder;

	/* 
	 *  Set up the color map.  
	 */

	if (name[0] == 'r')
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = i;
			carray[i].red = i << 8;
			carray[i].green = carray[i].blue = 0;
			carray[i].flags = DoRed | DoGreen | DoBlue;
		}
	else if (name[0] == 'g')
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = i;
			carray[i].green = i << 8;
			carray[i].red = carray[i].blue = 0;
			carray[i].flags = DoRed | DoGreen | DoBlue;
		}
	else if (name[0] == 'b') 
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = i;
			carray[i].blue = i << 8;
			carray[i].red = carray[i].green = 0;
			carray[i].flags = DoRed | DoGreen | DoBlue;
		}
	else if (name[0] == 'a')
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = i;
			carray[i].red = carray[i].green = carray[i].blue = i << 8;
			carray[i].flags = DoRed | DoGreen | DoBlue;
		}

	visual = XDefaultVisual(display, screennum);

	cmap = XCreateColormap(display, winder, visual, AllocNone);

	for (i = 0; i != CMAPSIZE; i++)
		XAllocColor(display, cmap, &carray[i]);

	wattr.colormap = cmap;
	XChangeWindowAttributes(display, winder, CWColormap, &wattr);

	XInstallColormap(display, cmap);

	/*
	 * Create Graphics Drawable
	 */
	gc = XDefaultGC(display, screennum);

	XMapRaised(display, winder);
	XSync(display, 0);

	strcpy(name, av[0]);
	strcat(name, ": ");
	strcat(name, imagetitle(im));

	y = h - 1;
	x = 0;
	val = -1;

	if (name[0] == 'r')
		while (readrgbline(im, red, green, blue)) {
			for (ox = x = 0; x < w; x++) {
				if (val != red[x]) {
					if (val != -1) {
						XSetForeground(display, gc, carray[val].pixel);
						XDrawLine(display, drawable, gc, ox, y, x, y);
					}
					val = red[x];
					ox = x;
				}
			}
			if (ox != w - 1) {
				XSetForeground(display, gc, carray[val].pixel);
				XDrawLine(display, drawable, gc, ox, y, x, y);
			}
			XSync(display, 0);
			y--;
		}
	else if (name[0] == 'g')
		while (readrgbline(im, red, green, blue)) {
			for (ox = x = 0; x < w; x++) {
				if (val != green[x]) {
					if (val != -1) {
						XSetForeground(display, gc, carray[val].pixel);
						XDrawLine(display, drawable, gc, ox, y, x, y);
					}
					val = green[x];
					ox = x;
				}
			}
			if (ox != w - 1) {
				XSetForeground(display, gc, carray[val].pixel);
				XDrawLine(display, drawable, gc, ox, y, x, y);
			}
			XSync(display, 0);
			y--;
		}
	else if (name[0] == 'b')
		while (readrgbline(im, red, green, blue)) {
			for (ox = x = 0; x < w; x++) {
				if (val != blue[x]) {
					if (val != -1) {
						XSetForeground(display, gc, carray[val].pixel);
						XDrawLine(display, drawable, gc, ox, y, x, y);
					}
					val = blue[x];
					ox = x;
				}
			}
			if (ox != w - 1) {
				XSetForeground(display, gc, carray[val].pixel);
				XDrawLine(display, drawable, gc, ox, y, x, y);
			}
			XSync(display, 0);
			y--;
		}
	else if (name[0] == 'a')
		while (readrgbaline(im, red, green, blue, alpha)) {
			for (ox = x = 0; x < w; x++) {
				if (val != alpha[x]) {
					if (val != -1) {
						XSetForeground(display, gc, carray[val].pixel);
						XDrawLine(display, drawable, gc, ox, y, x, y);
					}
					val = alpha[x];
					ox = x;
				}
			}
			if (ox != w - 1) {
				XSetForeground(display, gc, carray[val].pixel);
				XDrawLine(display, drawable, gc, ox, y, x, y);
			}
			XSync(display, 0);
			y--;
		}

	XSync(display, 0);

	mask = 0;

	while (mask == 0)
		XQueryPointer(display, winder, &rootw, &childw, &x, &y, &x, &y, &mask);

	XFreeGC(display, gc);
	XUnmapWindow(display, winder);

	exit(0);
}
