#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vort.h"

extern char	*rindex();

#define	CMAPSIZE	256
#define EV_MASK         KeyPressMask|ButtonReleaseMask|ExposureMask|ButtonPressMask

static char		title[BUFSIZ], *myname;
static Display		*display;
static int		theScreen, depth;
static Colormap		cmap;
static Window		winder, rootw;
static GC		theGC;
static Pixmap		pm;
static XImage		*ximage;

/*
 * program to read in a color-mapped image and display it on X11, greyscale
 * is used if the image is rgb.
 */
main(ac, av)
	int	ac;
	char	**av;
{
	char		*mem, *mmem, *data;
	register int	i, j, ox;
	unsigned int	w, h, w2, bytes_per_line;
	int		val, x, y, upsidedown, wreal, mag = 1;
	unsigned char	v, *red, *green, *blue, *line, *l;
	image		*im;
	XEvent		event;
	Visual		*visual;

        if ((myname = rindex(av[0],'/')) == NULL)
                myname = av[0];
        else
                *myname++;

	if (ac < 2) {
		fprintf(stderr, "%s: usage disp file.\n", myname);
		exit(1);
	}

        upsidedown = 0;
        for (i = 1; i < ac && *av[i] == '-'; i++) {
                if (strncmp(av[i], "-m", 2) == 0) {             /* magnify */
                        if (sscanf(av[i] , "-m%d", &mag) != 1) {
                                fprintf(stderr, "%s: bad mag factor\n", myname);
                                exit(1);
                        }

                        if (mag < 1 || mag > 5) {
                                fprintf(stderr, "%s: bad mag factor\n", myname);
                                exit(1);
                        }
                } else if (strncmp(av[i], "-u", 2) == 0) {              /* show
image upside down */
                        upsidedown = 1;
                }
        }

	/*
	 * Big buffer for reading....
	 */
	imagebufsize(3 * 4096);
	if ((im = openimage(av[i], "r")) == (image *)NULL) {
		fprintf(stderr, "disp: can't open file %s.\n", av[i]);
		exit(1);
	}

	strcpy(title, myname);
	strcat(title, ": ");
        if (titlelength(im) != 0)
                strcat(title, imagetitle(im));


	if ((display = XOpenDisplay((char *)NULL)) == NULL) {
		fprintf(stderr, "Can't open display %s\n", XDisplayName((char *)NULL));
		exit(1);
	}

	theScreen = DefaultScreen(display);
	if ((depth = XDisplayPlanes(display, theScreen)) < 8) {
		fprintf(stderr, "You need a 256 colour display device\n");
		exit(1);
	}

	visual = DefaultVisual(display, theScreen);
	rootw = RootWindow(display, theScreen);
	theGC = DefaultGC(display, theScreen);
	cmap = XCreateColormap(display, rootw, visual, AllocAll);

        wreal = imagewidth(im);
        w = wreal * mag;
        h = mag * imageheight(im);

	/*
	 * Make it all 32 bit aligned
	 */
	w2 = w + (w % 4);

	bytes_per_line = w2;
	
	makewindow(w, h);
	setcolormap(im);


	/*
	 * Get mem for data in image
	 */
	if ((mem = data = (char *)malloc((unsigned)(w2 * h))) == NULL) {
		fprintf(stderr, "mem = NULL\n");
		exit(0);
	}

	
	ximage = XCreateImage(display,
			visual,
			depth,
			ZPixmap,
			0,
			data,
			w2, (unsigned int)h,
			8, 0
		);

	if (ximage == (XImage *)NULL) {
		fprintf(stderr, "Unable to create ximage\n");
		exit(1);
	}

	if (upsidedown)
		mem += (h - 1) * bytes_per_line;

	y = h - 1;
	x = 0;
	val = -1;

	line = (unsigned char *)malloc(w2);

	if (colormapped(im)) {
		while (y >= 0) {
			readmappedline(im, line);
			if (mag == 1) {
				bcopy(line, mem, wreal);
				if (upsidedown)
					mem -= bytes_per_line;
				else
					mem += bytes_per_line;
				y--;
			} else {
				for (j = 0; j < mag; j++) {
					mmem = mem;
					for (x = 0; x < wreal; x++)
						for (i = 0; i < mag; i++)
							*mmem++ = line[x];

					if (upsidedown)
						mem -= bytes_per_line;
					else
						mem += bytes_per_line;
				}
                                y -= mag;
			}
		}

	} else {
		red = (u_char *)malloc(wreal);
		green = (u_char *)malloc(wreal);
		blue = (u_char *)malloc(wreal);

		while (y >= 0) {
			readrgbline(im, red, green, blue);
			for (x = 0; x < wreal; x++) 
				line[x] = red[x] * 0.3 + green[x] * 0.59 + blue[x] * 0.11;

			if (mag == 1) {
				bcopy(line, mem, wreal);
				if (upsidedown)
					mem -= bytes_per_line;
				else
					mem += bytes_per_line;
				y--;
			} else {
				for (j = 0; j < mag; j++) {
					mmem = mem;
					for (x = 0; x < wreal; x++) 
						for (i = 0; i < mag; i++)
							*mmem++ = line[x];

					if (upsidedown)
						mem -= bytes_per_line;
					else
						mem += bytes_per_line;
				}
				y -= mag;
			}
		}
	}

	XMapWindow(display, winder);

        /*
         * Wait for Exposure event.
         */
        do {
                XNextEvent(display, &event);
        } while (event.type != Expose);
 
	XSetInputFocus(display, winder, RevertToParent, CurrentTime);




        /*
         * Copy it to the screen
         */

	XPutImage(display, 
		winder,
		theGC, 
		ximage,
		0, 0, 
                0, 0,
                w, h
        );

	XFlush(display);

        /*
         * Wait for keypress or Button press
         */
        do {
                XNextEvent(display, &event);
		if (event.type == Expose) {
			/*
			 * Copy it to the screen
			 */

			XPutImage(display, 
				winder,
				theGC, 
				ximage,
				0, 0, 
				0, 0,
				w, h
			);

			XFlush(display);
		}

        } while (event.type != KeyPress && event.type != ButtonPress);


	XUnmapWindow(display, winder);
	XFreeGC(display, theGC);
	XFreeColormap(display, cmap);
	XDestroyImage(ximage);

	exit(0);
}


setcolormap(im)
	image	*im;
{
	int	i;
	XColor	carray[CMAPSIZE];

	/* 
	 *  Set up the color map.  
	 */

	if (colormapped(im)) {
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = (unsigned long)i;
			carray[i].red = (unsigned short)(im->red[i] << 8);
			carray[i].green = (unsigned short)(im->green[i] << 8);
			carray[i].blue = (unsigned short)(im->blue[i] << 8);
			carray[i].flags = DoRed | DoGreen | DoBlue;
		}
	} else {
		for (i = 0; i < CMAPSIZE; i++) {
			carray[i].pixel = (unsigned long)i;
			carray[i].red = carray[i].green = carray[i].blue = (unsigned short)(i << 8);
			carray[i].flags = DoRed | DoGreen | DoBlue;
		}
	}

	XStoreColors(display, cmap, carray, CMAPSIZE);
}


makewindow(w, h)
	unsigned int	w, h;
{
	unsigned int		wattrmask;
	XSetWindowAttributes	wattr;
	XSizeHints		sizehints;
	XWMHints		wmhints;
	unsigned int		bw = 0;

	sizehints.flags = PPosition | PSize;
	sizehints.width = w;
	sizehints.height = h;
	sizehints.x = 0;
	sizehints.y = 0;


        wattr.background_pixel = BlackPixel(display, theScreen);
        wattr.border_pixel = WhitePixel(display, theScreen);
	wattr.colormap = cmap;
	wattrmask = CWBackPixel | CWBorderPixel | CWColormap;

	winder = XCreateWindow(display,
			rootw,
			0, 0,
			w, h,
			bw,
			depth,
			CopyFromParent,
			CopyFromParent,
			wattrmask,
			&wattr
		);

	XSetWindowColormap(display, winder, cmap);

	XSetStandardProperties(display,
			winder,
			title, 
			myname,
			None,
			(char **)NULL, 0,
			&sizehints
	);

        wmhints.initial_state = NormalState;
        wmhints.input = True;
        wmhints.flags = StateHint | InputHint;
        XSetWMHints(display, winder, &wmhints);

	XSetForeground(display, theGC, WhitePixel(display, theScreen));
	XSetBackground(display, theGC, BlackPixel(display, theScreen));

        XSelectInput(display, winder, EV_MASK);
}
