#include <stdio.h>

#define MAX(a,b)	((a) > (b) ? (a) : (b))
#define MIN(a,b)	((a) < (b) ? (a) : (b))
#define ABS(a)		((a) < 0.0 ? (-a) : (a))

#define	EBUF_SIZE	100		/* size of error message buffer */
#define	LABEL_LEN	50		/* max length of an axis label */

/*
 * fits
 */
#define	NO_LINES	0
#define	STRAIGHT_LINE	1
#define LEAST_SQUARE	2
#define CUBIC_SPLINE	3
#define	POWER_EQN	4
#define	SGR_FIT		5

#define	MAX_FIT		5		/* must be maximum fit number */

/*
 * spline types
 */
#define	FREE		0
#define	CLAMPED		1

/*
 * scalings
 */
#define	LINEAR		0
#define	LOGARITHMIC	1

/*
 * boundaries in which the graph is plotted
 */
#define	XMIN		-0.7
#define	YMIN		-0.7
#define	XMAX		1.0
#define	YMAX		0.8

/*
 * size of line-markers on axes
 */
#define	LINELEN		0.02

/*
 * textsizes
 */
#define	TEXTHEIGHT	0.05
#define	TEXTWIDTH	0.035

/*
 * marker size
 */
#define	MARKERSIZE	0.05

/*
 * A big number (Some PC things don't seem to have this in math.h)
 */
#define BLOODYBIG	1.0e38

extern float	*newm1(), **newm2();

extern float	cardinal[4][4];

/*
 * axis indexes
 */
#define	XIND		0
#define	YIND		1
#define	ZIND		2

#define	AXES		3	/* number of axes */

typedef struct AXISDATA {
	float	min,
		max,
		div;
	int	scaling,
		annotate,
		nticks,
		ntspacing,
		scaleset;
	char	*format,
		*title;
} axisdata;

typedef struct VOPL {
	float		s1, sn,
			markerscale;

	int		fit, 
			degree,
			splinetype,
			grid, 
			startind, arrayind,
			precision,
			markerspacing,
			forceticks;
		
	char		*marker,
			*graphtitle;

	axisdata	axes[AXES];
} vopldev;

extern vopldev	plotdev;

extern	double	log10();

extern	char	*savestr();
extern	char	*malloc();

#define WhatX(x) (plotdev.axes[XIND].scaling == LINEAR ? \
				(x) : (float)log10((double)(x)))
#define WhatY(y) (plotdev.axes[YIND].scaling == LINEAR ? \
				(y) : (float)log10((double)(y)))
#define WhatZ(z) (plotdev.axes[ZIND].scaling == LINEAR ? \
				(z) : (float)log10((double)(z)))
