/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * rlesetbg.c - set the background color (based on repos)
 * 
 * Author:	John W. Peterson & Rod Bogart
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Sat Jun 21 1986
 * Copyright (c) 1986, University of Utah
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif

#include <stdio.h>
#include <svfb_global.h>

char buffer[4096];

main(argc, argv)
int	argc;
char	*argv[];
{
    int new_back[3];
    int buflen;
    int overlay_flag = 0, backcolor_flag = 0;
    struct sv_globals globals, outglobals;
    char * fname = NULL;

    if (scanargs(argc, argv, "% O%- c%-rbak!dgbak!dbbak!d infile%s",
		 &overlay_flag, &backcolor_flag,
		 &(new_back[0]), &(new_back[1]), &(new_back[2]),
		 &fname ) == 0)
    {
	exit(-1);
    }
    if (overlay_flag && backcolor_flag)
    {
	fprintf(stderr, "rlesetbg: Overlay or new color, but not both\n");
	exit(-1);
    }

    if ( fname != NULL && (globals.svfb_fd = fopen( fname, "r" )) == NULL )
    {
	perror( fname );
	exit( 1 );
    }
    else if ( fname == NULL )
	globals.svfb_fd = stdin;
    rle_get_setup_ok( &globals, "rlesetbg", fname );
    outglobals = globals;
    outglobals.svfb_fd = stdout;

    if (overlay_flag)
	outglobals.sv_background = 1;
    else
    {
	outglobals.sv_background = 2;
	outglobals.sv_bg_color = new_back;
    }

    sv_setup( RUN_DISPATCH, &outglobals );

    while ( (buflen = fread(buffer, sizeof(char), 4096, stdin)) > 0 )
    {
	fwrite( buffer, sizeof(char), buflen, stdout );
    }
    exit( 0 );
}
