/* 
 * rlemandl.c - Compute images of the Mandlebrot set in RLE format
 * 
 * Author:	John W. Peterson
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Mon Nov  9 1987
 * Copyright (c) 1987, University of Utah
 */

#include <stdio.h>
#include <math.h>
#include "svfb_global.h"

main( argc, argv )
int argc;
char **argv;
{
    float real, imaginary, width, step;
    float ypos, xpos;
    rle_pixel ** rows;
    int xsize = 256, ysize = 256;
    int x_pixel, y_pixel;
    int junk, verbose = 0;
    register int iter;
    /* May want to use floats...whatever's fastest */
    register double z_r, z_i, z_rs, z_is;
    
    if (! scanargs(argc, argv,
		   "% v%- real!f image!f width!f s%-xsize!dysize!d",
		   &verbose, &real, &imaginary, &width,
		   &junk, &xsize, &ysize ))
	exit( -2 );

    step = width / (float) xsize;

    xpos = real - width / 2.0;
    ypos = imaginary - (step / 2.0) * (float) ysize;

    /* Re-use real as left margin */
    real = xpos;

    /* Change the default sv_globals struct to match what we need */

    sv_globals.svfb_fd = stdout;
    sv_globals.sv_xmax = xsize - 1;
    sv_globals.sv_ymax = ysize - 1;
    sv_globals.sv_ncolors = 1;	/* One output channel */
    sv_globals.sv_alpha = 0;	/* No coverage (alpha) */

    /* Allocate storage for the output row */
    if (rle_row_alloc( &sv_globals, &rows ))
    {
	fprintf( stderr, "rlemandl: malloc failed\n" );
	exit( -2 );
    }

    /* Create the header in the output file */
    sv_setup( RUN_DISPATCH, &sv_globals );

    for (y_pixel = 0; y_pixel < ysize; y_pixel++)
    {
	xpos = real;
	for (x_pixel = 0; x_pixel < xsize; x_pixel++)
	{
	    z_r = 0;
	    z_i = 0;
	    iter = 0;
	    while (iter < 255 && ((z_rs = z_r * z_r) + (z_is = z_i * z_i)) < 4)
	    {
		z_i = 2 * z_r*z_i + ypos;
		z_r = z_rs - z_is + xpos;
		iter++;
	    }
	    rows[0][x_pixel] = (rle_pixel) iter == 1 ? 0 : iter;
	    xpos += step;
	}
	sv_putrow( rows, xsize + 1, &sv_globals );
	if (verbose)
	    if ((y_pixel % 50) == 0)
		fprintf(stderr, "line %d...\n", y_pixel);
	ypos += step;
    }
    sv_puteof( &sv_globals );
    exit( 0 );
}
