/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * rle_addcom.c - Add comment[s] to an RLE file.
 * 
 * Author:	Spencer W. Thomas
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Sun Jan 25 1987
 * Copyright (c) 1987, University of Utah
 */

#include <stdio.h>
#include <svfb_global.h>

/*****************************************************************
 * TAG( main )
 * 
 * Add one or more comments to an RLE file.
 *
 * Usage:
 *	rle_addcom [-d] [-f rlefile] comments ...
 * Inputs:
 *	-d:		Delete matching comments instead of adding any.
 * 	rlefile:	File to add comments to.
 *	comments:	One or more strings.  Each will be inserted as
 *			a separate comment.  They will usually be of the
 *			form "name=value".
 * Outputs:
 * 	Writes modified RLE file to standard output.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */
main( argc, argv )
char **argv;
{
    struct sv_globals outglob;
    char * fname = NULL;
    FILE * rlef = stdin;
    char ** comments = NULL;
    int fflag, delflag = 0, ncomment = 0;
    register int i, j;
    int k;
    char * iscom, *scancom;

    if ( scanargs( argc, argv, "% d%- f%-rlefile!s comments!*s",
		   &delflag, &fflag, &fname, &ncomment, &comments ) == 0 )
	exit( 1 );

    if ( fname != NULL && (rlef = fopen( fname, "r" )) == NULL )
    {
	fprintf( stderr, "%s: ", argv[0] );
	perror( fname );
	exit( 1 );
    }
    else if ( fname == NULL )
	fname = "stdin";

    sv_globals.svfb_fd = rlef;

    /* Read in header */
    rle_get_setup_ok( &sv_globals, "rleaddcom", fname );

    outglob = sv_globals;
    outglob.svfb_fd = stdout;

    /* Copy input to globals struct */
    for ( j = 0; j < ncomment; j++ )
    {
	if ( ! delflag )
	    rle_putcom( comments[j], &outglob );
	else
	    rle_delcom( comments[j], &outglob );
    }

    /* Start output file */
    sv_setup( RUN_DISPATCH, &outglob );

    /* Copy rest of input to output */
    cp( rlef, fname, stdout, "stdout" );

    exit( 0 );
}

/*****************************************************************
 * TAG( cp )
 * 
 * Copy the input file to the output file.
 * Inputs:
 * 	infile:	    	Input file.
 *  	infname:    	Name of input file (for error messages).
 *  	outfile:    	Output file.
 *  	outfname:   	Name of output file.
 * Outputs:
 * 	Performs the copy.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */
cp( infile, infname, outfile, outfname )
FILE *infile;
char * infname;
FILE *outfile;
char * outfname;
{
    char buf[BUFSIZ];
    int n;

    while ( !feof( infile ) )
    {
	n = fread( buf, 1, BUFSIZ, infile );
	if ( n < 0 )
	{
	    fprintf( stderr, "rleldmap: Error reading %s: ", infname );
	    perror("");
	    exit(-1);
	}
	if ( fwrite( buf, 1, n, outfile ) < 0 )
	{
	    fprintf( stderr, "rleldmap: Error writing %s: ", outfname );
	    perror("");
	    exit(-1);
	}
    }
}
