/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * crop.c - Crop an image to the given size.
 * 
 * Author:	Rod Bogart & John W. Peterson
 * 		Computer Science Dept. 
 * 		University of Utah
 * Date:	Mon Jun 23 1986
 * Copyright (c) 1986, University of Utah
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif

#include <stdio.h>
#include <svfb_global.h>

main(argc, argv)
int	argc;
char	*argv[];
{
    rle_pixel **scanline, **rows, **outrows;
    int xlen, xmin, ymin, i, j;
    int xmax, ymax;
    char *infilename = NULL;
    int bottom_row;

    struct sv_globals inglobals, outglobals;

    if (scanargs(argc, argv, "% xmin!dymin!dxmax!dymax!d infile%s",
                 &xmin, &ymin, &xmax, &ymax, &infilename ) == 0)
    {
	exit(-1);
    }

    if (infilename)
    {
	inglobals.svfb_fd = fopen(infilename, "r");
	if (! inglobals.svfb_fd)
	{
	    fprintf( stderr, "crop: can't open %s\n", infilename);
	    exit(-1);
	}
    }
    else
	inglobals.svfb_fd = stdin;

    rle_get_setup_ok( &inglobals, "crop", infilename );

    outglobals = inglobals;
    outglobals.svfb_fd = stdout;
    xlen = xmax - xmin + 1;

    if ((xmin > xmax) || (ymin > ymax))
    {
	fprintf(stderr, "Illegal size for crop: %d, %d to %d, %d\n",
		xmin,ymin,xmax,ymax);
	exit(-1);
    }

    /* should check for disjoint regions */

    outglobals.sv_xmin = xmin;
    outglobals.sv_ymin = ymin;
    outglobals.sv_xmax = xmax;
    outglobals.sv_ymax = ymax;

    sv_setup( RUN_DISPATCH, &outglobals );

    if (outglobals.sv_xmax > inglobals.sv_xmax)
    {
	if (rle_row_alloc( &outglobals, &scanline ))
	    fprintf(stderr, "crop: Ran out of malloc space\n");
    }
    else
    {
	if (rle_row_alloc( &inglobals, &scanline ))
	    fprintf(stderr, "crop: Ran out of malloc space\n");
    }

    if (!(rows = (rle_pixel **)
	  malloc((inglobals.sv_ncolors + inglobals.sv_alpha)
		 * sizeof( rle_pixel * ))))
	  fprintf(stderr, "crop: Ran out of malloc space\n");

    if (!(outrows = (rle_pixel **)
	  malloc((inglobals.sv_ncolors + inglobals.sv_alpha)
		 * sizeof( rle_pixel * ))))
	  fprintf(stderr, "crop: Ran out of malloc space\n");

    if ( inglobals.sv_alpha )
    {
	rows++;			/* So alpha is rows[-1] */
	outrows++;
    }
 
    bottom_row = inglobals.sv_ymin;
    if (inglobals.sv_ymin > outglobals.sv_ymin)
    {
	/* Output blank scanlines if crop region is larger than data */
	sv_putrow(NULL, inglobals.sv_ymin - outglobals.sv_ymin, &outglobals);
	bottom_row = inglobals.sv_ymin;
    }
    else
    if (inglobals.sv_ymin < outglobals.sv_ymin)
    {
	/* Read past extra lower scanlines */
	for( i = -inglobals.sv_alpha; i < inglobals.sv_ncolors; i++ )
	    rows[i] = scanline[i];
	for (i = inglobals.sv_ymin; i < outglobals.sv_ymin; i++)
	    rle_getrow(&inglobals, rows );
	bottom_row = outglobals.sv_ymin;
    }

    for( i = -inglobals.sv_alpha; i < inglobals.sv_ncolors; i++ )
	rows[i] = scanline[i];

    for( i = -inglobals.sv_alpha; i < inglobals.sv_ncolors; i++ )
	outrows[i] = &scanline[i][xmin];
    
    /* Read in image */
    for (j = bottom_row; j <= outglobals.sv_ymax; j++)
    {
        rle_getrow(&inglobals, rows );

	sv_putrow( outrows, xlen, &outglobals );
    }
    sv_puteof( &outglobals );
    exit( 0 );
}
