/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * avg4.c - Reduce image by half in X and Y, producing alphas even
 *          if they weren't there originally.
 * 
 * Author:	Rod Bogart & John W. Peterson
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Fri Jun 20 1986
 * Copyright (c) 1986, University of Utah
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif


#include <stdio.h>
#include <svfb_global.h>

#define MALLOC_ERR {fprintf(stderr, "avg4: ran out of heap space\n");exit(-2);}

static bit_count[16] = {0, 63, 63, 127, 63, 127, 127,
    192, 63, 127, 127, 192, 127, 192, 192, 255};

main(argc, argv)
int	argc;
char	*argv[];
{
    int         row, i, j;
    int		new_xlen,
		new_ylen;
    struct sv_globals inglobals, outglobals;
    rle_pixel **rows0, **rows1, **rowsout;
    rle_pixel *ptr0, *ptr1, *ptrout, *alphptr;
    int		A, chan;
    
    if (argc == 2)
    {
	inglobals.svfb_fd = fopen(argv[1], "r");
	if (! inglobals.svfb_fd)
	{
	    fprintf( stderr, "avg4: can't open %s\n", argv[1]);
	    exit(-1);
	}
    }
    else
	inglobals.svfb_fd = stdin;

    rle_get_setup_ok( &inglobals, "avg4", argv[1] );

    outglobals = inglobals;

    new_xlen = (inglobals.sv_xmax - inglobals.sv_xmin +1 ) / 2;
    new_ylen = (inglobals.sv_ymax - inglobals.sv_ymin +1 ) / 2;
    outglobals.sv_xmin = inglobals.sv_xmin / 2;
    outglobals.sv_ymin = inglobals.sv_ymin / 2;
    outglobals.sv_xmax = outglobals.sv_xmin + new_xlen - 1;
    outglobals.sv_ymax = outglobals.sv_ymin + new_ylen - 1;

    outglobals.sv_alpha = 1;	/* Force alpha in output. */
    SV_SET_BIT( outglobals, SV_ALPHA );

    outglobals.svfb_fd = stdout;
    sv_setup( RUN_DISPATCH, &outglobals );

    /* Oink. */
    if (rle_row_alloc( &inglobals, &rows0 ))
	MALLOC_ERR;

    if (rle_row_alloc( &inglobals, &rows1 ))
	MALLOC_ERR;

    if (rle_row_alloc( &outglobals, &rowsout ))
	MALLOC_ERR;

    for ( j = 0; j < new_ylen*2; j+=2 )
    {
	rle_getrow(&inglobals, rows0 );
	rle_getrow(&inglobals, rows1 );

	for (chan = SV_ALPHA; chan < inglobals.sv_ncolors; chan++)
	{
	    ptr0 = &(rows0[chan][inglobals.sv_xmin]);
	    ptr1 = &(rows1[chan][inglobals.sv_xmin]);
	    ptrout = rowsout[chan];
	    alphptr = rowsout[SV_ALPHA];
	    /*
	     * If we don't start out with an alpha channel in the
	     * original image, then we want to fake one up.  This
	     * works by counting the number of non-zero pixels in the
	     * R, G and B channels.  We set bits in the alpha channel
	     * for the non-zero pixels found, then use bit_count to
	     * convert this to reasonable coverage values.
	     */
	    if ((chan == SV_ALPHA) && (!inglobals.sv_alpha))
	    {
		bzero(alphptr, new_xlen);
	    }
	    else for( i = 0; i < new_xlen; i++)
	    {
		if (!inglobals.sv_alpha)
		{
		    *alphptr |= (*ptr0 ? 1 : 0) | (ptr0[1] ? 2 : 0) |
				(*ptr1 ? 4 : 0) | (ptr1[1] ? 8 : 0);

		    /* calc fake alpha from bit count */
		    if (chan == (inglobals.sv_ncolors - 1))
			*alphptr = bit_count[*alphptr];

		    alphptr++;
		}
		A = (int) *ptr0++ + (int) *ptr0++ +
		    (int) *ptr1++ + (int) *ptr1++;
		*ptrout++ = (rle_pixel) (A / 4);
	    }
	}
	sv_putrow( rowsout, new_xlen, &outglobals );
    }
    sv_puteof( &outglobals );
    exit( 0 );
}


