/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *  Modified at BRL 16-May-88 by Mike Muuss to avoid Alliant STDC desire
 *  to have all "void" functions so declared.
 */
/* 
 * svfb_global.c - Global variable initialization for svfb routines.
 * 
 * Author:	Spencer W. Thomas
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Thu Apr 25 1985
 * Copyright (c) 1985,1986 Spencer W. Thomas
 * 
 * $Header: svfb_global.c,v 2.6 86/02/27 10:05:23 thomas Exp $
 * $Log:	svfb_global.c,v $
 * Revision 2.6  86/02/27  10:05:23  thomas
 * Change for new sv_globals
 * 
 * Revision 2.5  86/02/25  17:32:18  thomas
 * Take out misc.h
 * 
 * Revision 2.4  85/04/26  15:09:27  thomas
 * Add header comment.  Change DTable to sv_DTable.  Changes for new
 * sv_globals structure.
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header: svfb_global.c,v 2.6 86/02/27 10:05:23 thomas Exp $";
#endif

#include <stdio.h>
#include "svfb.h"
#include "svfb_global.h"

extern int	RunSetup(),
		RunSkipBlankLines(),
		RunSetColor(),
		RunSkipPixels(),
		RunNewScanLine(),
		Runputdata(),
		Runputrun(),
		RunputEof();

extern int	DefaultBlockHook();
extern void	NullputEof();

struct sv_dispatch_tab sv_DTable[] = {
    {
	" OB",
	RunSetup,
	RunSkipBlankLines,
	RunSetColor,
	RunSkipPixels,
	RunNewScanLine,
	Runputdata,
	Runputrun,
	DefaultBlockHook,
	RunputEof
    },
};

static int sv_bg_color[3] = { 0, 0, 0 };

struct sv_globals sv_globals = {
    RUN_DISPATCH,		/* dispatch value */
    3,				/* 3 colors */
    sv_bg_color,		/* background color */
    0,				/* (alpha) if 1, save alpha channel */
    2,				/* (background) 0->just save pixels, */
				/* 1->overlay, 2->clear to bg first */
    0, 511,			/* (xmin, xmax) X bounds to save */
    0, 479,			/* (ymin, ymax) Y bounds to save */
    0,				/* ncmap (if != 0, save color map) */
    8,				/* cmaplen (log2 of length of color map) */
    NULL,			/* pointer to color map */
    NULL,			/* pointer to comment strings */
    stdout,			/* output file */
    { 7 }			/* RGB channels only */
    /* Can't initialize the union */
};

/* ARGSUSED */
void
NullputEof(globals)
struct sv_globals * globals;
{
				/* do nothing */
}
