/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * bstring.c - Provide the bcopy and bzero functions if the C library doesn't.
 * 
 * Author:	Mark Bloomenthal
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Fri Aug  1 1986
 * Copyright (c) 1986, University of Utah
 * 
 */

/*****************************************************************
 * TAG( bcopy )
 *
 * Move contents of a block to a new location.
 * For systems without a bcopy system routine.
 */
bcopy( src_ptr, dst_ptr, size )
register int * src_ptr, * dst_ptr;
int size;
{
    register int words;
    register char * byte_src_ptr, * byte_dst_ptr;
    register int bytes;

    /* Tight word copy loop for most or all of the block. */
    words=size/sizeof(int);
    bytes = size - words*sizeof(int);
    while ( words-- ) 
	*dst_ptr++ = *src_ptr++;

    /* Tight byte copy loop for the remainder. */
    byte_src_ptr = (char *)src_ptr;
    byte_dst_ptr = (char *)dst_ptr;
    while ( bytes-- ) 
	*byte_dst_ptr++ = *byte_src_ptr++;
}

/*****************************************************************
 * TAG( bzero )
 * 
 * Set contents of a block to zero.
 * For systems without a bcopy system routine.
 */
bzero( dst_ptr, size ) 
register int * dst_ptr;
int size;
{
    register int words;
    register char * byte_dst_ptr;
    register int bytes;

    /* Tight word copy loop for most or all of the block. */
    words=size/sizeof(int);
    bytes = size - words*sizeof(int);
    while ( words-- ) 
	*dst_ptr++ = 0;

    /* Tight byte copy loop for the remainder. */
    byte_dst_ptr = (char *)dst_ptr;
    while ( bytes-- ) 
	*byte_dst_ptr++ = 0;
}
