/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * cubitorle.c - Convert cubicomp image to an RLE file.
 * 
 * Author:	Rod Bogart
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Thu Nov  6 1986
 * Copyright (c) 1986 Rod Bogart
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif


#include <stdio.h>
#include <svfb_global.h>

main(argc, argv)
int	argc;
char	*argv[];
{
    FILE *cubifiles[4];
    int i, j, oflag=0;
    rle_pixel ** rows;
    int xlen;
    int cubi_xlen, cubi_ylen;
    char *infname = NULL, *outfname = NULL;
    char filename[256];

    if ( scanargs( argc, argv,
		  "% o%-outfile!s inprefix!s",
		  &oflag, &outfname, &infname ) == 0 )
	exit( 1 );

    if (oflag && (sv_globals.svfb_fd = fopen( outfname, "w" )) == NULL )
    {
	perror( outfname );
	exit( 1 );
    }
    if (!oflag) sv_globals.svfb_fd = stdout;

    sprintf(filename,"%s.r8",infname);
    if ( (cubifiles[0] = fopen( filename, "r" )) == NULL)
    {
	perror( filename );
	exit( 1 );
    }
    sprintf(filename,"%s.g8",infname);
    if ( (cubifiles[1] = fopen( filename, "r" )) == NULL)
    {
	perror( filename );
	exit( 1 );
    }
    sprintf(filename,"%s.b8",infname);
    if ( (cubifiles[2] = fopen( filename, "r" )) == NULL)
    {
	perror( filename );
	exit( 1 );
    }

    read_cubi_hdr(cubifiles, &cubi_xlen, &cubi_ylen);

    sv_globals.sv_alpha = 0;
    sv_globals.sv_ncolors = 3;
    sv_globals.sv_xmin = 0;
    sv_globals.sv_xmax = cubi_xlen - 1;
    sv_globals.sv_ymin = 0;
    sv_globals.sv_ymax = cubi_ylen - 1;
    xlen = sv_globals.sv_xmax - sv_globals.sv_xmin + 1;

    sv_setup( RUN_DISPATCH, &sv_globals );

    if (rle_row_alloc( &sv_globals, &rows ))
    {
	fprintf( stderr, "cubitorle: malloc failed\n" );
	exit( -2 );
    }

    for (j=sv_globals.sv_ymin; j <= sv_globals.sv_ymax; j++)
    {
	read_cubi_row( cubifiles, rows );
	sv_putrow( rows, xlen, &sv_globals);
    }

}

read_cubi_hdr(cubifiles, xlen, ylen)
FILE *cubifiles[];
short *xlen, *ylen;
{
    char junk[128];
    short dummy, xmin, ymin, xmax, ymax;

    fread(junk, sizeof(char), 12, cubifiles[0]);
    fread(xlen, sizeof(short), 1, cubifiles[0]);
    fread(ylen, sizeof(short), 1, cubifiles[0]);
    fread(&xmin, sizeof(short), 1, cubifiles[0]);
    fread(&ymin, sizeof(short), 1, cubifiles[0]);
    fread(&xmax, sizeof(short), 1, cubifiles[0]);
    fread(&ymax, sizeof(short), 1, cubifiles[0]);
    fread(junk, sizeof(char), 104, cubifiles[0]);

    fread(junk, sizeof(char), 128, cubifiles[1]);
    fread(junk, sizeof(char), 128, cubifiles[2]);
}

read_cubi_row(cubifiles, rows)
FILE *cubifiles[];
rle_pixel ** rows;
{
    read_cubi_chan(cubifiles[0],rows,0);
    read_cubi_chan(cubifiles[1],rows,1);
    read_cubi_chan(cubifiles[2],rows,2);
}

read_cubi_chan(infile, rows, chan)
FILE * infile;
rle_pixel **rows;
int chan;
{
    static char headchar[3];
    static int scanfull[3] = {-1, -1, -1};
    int xpos = 0, bit;

    while (xpos < 512)
    {
	if (scanfull[chan] == -1)
	    headchar[chan] = fgetc(infile);

	for (bit = 0; bit < 8; bit++)
	    if (scanfull[chan] <= bit)
	    {
		bit_read(infile, headchar[chan], bit, rows, chan, &xpos);
		if (xpos >= 512) 
		{
		    scanfull[chan] = bit + 1;
		    break;
		}
	    }
	if (bit >= 7) scanfull[chan] = -1;
    }
}

bit_read(infile, headchar, bit, rows, chan, xpos)
FILE * infile;
char headchar;
int bit, chan, *xpos;
rle_pixel **rows;
{
    unsigned char runlength, rundata, bytedata;
    int i;

    if (headchar & (1 << bit))
    {
	/* bit set, run data */
	rundata = fgetc(infile);
	runlength = fgetc(infile);
	for (i=(*xpos); i < runlength+(*xpos); i++)
	    rows[chan][i] = rundata;
	*xpos += (int) runlength;
    }
    else
    {
	/* bit not set, byte data */
	bytedata = fgetc(infile);
	rows[chan][*xpos] = bytedata;
	(*xpos)++;
    }
}
