/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * rlepatch.c - Patch images over a larger image.
 * 
 * Author:	John W. Peterson
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Sun Nov 29 1987
 * Copyright (c) 1987, University of Utah
 *
 * This was a quick hack.  It should be changed to use the "raw"
 * routines someday - this would run MUCH faster for sparse patches.
 */

#include <stdio.h>
#include <svfb_global.h>

#define CHECK_MALLOC( ptr, msg ) \
  { if (! (ptr)) {fprintf( stderr, msg ); exit(-2);}}
#define IN_WINDOW(y,wind) ((y >= wind.sv_ymin) && (y <= wind.sv_ymax))

main( argc, argv )
int argc;
char **argv;
{
    struct sv_globals im_globals, *patchglobals, outglobals;
    char * imfilename;
    char ** patchnames;
    rle_pixel ** im_rows, **patch_rows, ** outrows;
    int stdin_used = 0;
    int patches, i, y, c, xlen, width;

    if (! scanargs( argc, argv, "% image!s patches%*s",
		    &imfilename, &patches, &patchnames ))
	exit( -1 );

    patchglobals = (struct sv_globals *) malloc( sizeof( struct sv_globals )
						* patches );
    CHECK_MALLOC( patchglobals, "rlepatch: malloc error\n" );

    /* Setup the main image data structures. */

    if (strcmp( imfilename, "-" ) == 0)
    {
	im_globals.svfb_fd = stdin;
	imfilename = "stdin";	/* For error messages */
	stdin_used++;
    }
    else
	if (! (im_globals.svfb_fd = fopen( imfilename, "r" )))
	{
	    perror( imfilename );
	    exit( -2 );
	}
    rle_get_setup_ok( &im_globals, "rlepatch", imfilename );

    /* Get the patch files set up */
     
    for( i = 0; i < patches; i++ )
    {
	if (strcmp( patchnames[i], "-" ) == 0)
	{
	    if (! stdin_used)
	    {
		patchglobals[i].svfb_fd = stdin;
		patchnames[i] = "stdin";
		stdin_used++;
	    }
	    else
	    {
		fprintf(stderr, "rlepatch: Only use stdin (-) once.\n");
		exit(-1);
	    }
	}
	else
	    if (! (patchglobals[i].svfb_fd = fopen( patchnames[i], "r" )))
	    {
		perror( patchnames[i] );
		exit( -2 );
	    }
	rle_get_setup_ok( &patchglobals[i], "rlepatch", patchnames[i] );

	/* Sanity checks. */

	if ((patchglobals[i].sv_xmin < im_globals.sv_xmin) ||
	    (patchglobals[i].sv_xmax > im_globals.sv_xmax) ||
	    (patchglobals[i].sv_ymin < im_globals.sv_ymin) ||
	    (patchglobals[i].sv_ymax > im_globals.sv_ymax))
	{
	    fprintf( stderr, "rlepatch: file %s is outside %s\n",
		     patchnames[i], imfilename );
	    exit( -2 );
	}

	if ((patchglobals[i].sv_ncolors != im_globals.sv_ncolors) ||
	    (patchglobals[i].sv_alpha != im_globals.sv_alpha))
	{
	    fprintf( stderr,
		    "rlepatch: file %s doesn't have the same channels as %s\n",
		    patchnames[i], imfilename );
	    exit(-2);
	}
    }	

    if (rle_row_alloc( &im_globals, &im_rows ) ||
	rle_row_alloc( &im_globals, &patch_rows ))
    {
	fprintf( stderr, "rlepatch: Malloc error.\n" );
	exit(-2);
    }

    /* Setup output */
    outglobals = im_globals;
    outglobals.svfb_fd = stdout;
    sv_setup( RUN_DISPATCH, &outglobals );

    /*
     * Allocate pointers to the output rows.  Note that sv_putrow
     * expects the pointers to start at sv_xmin, instead of at zero
     * like rle_getrow (Weird Spencerism).
     */
    outrows = (rle_pixel**) malloc( sizeof( rle_pixel** ) *
				(im_globals.sv_alpha + im_globals.sv_ncolors));
    CHECK_MALLOC( outrows, "rlepatch: Malloc error\n" );
    if (im_globals.sv_alpha)
	outrows++;		/* Put alpha at -1 index */

    xlen = outglobals.sv_xmax - outglobals.sv_xmin + 1;
    for( i = -im_globals.sv_alpha; i < im_globals.sv_ncolors; i++ )
	outrows[i] = &(im_rows[i][im_globals.sv_xmin]);

    /* Process the images. */

    for (y = im_globals.sv_xmin; y <= im_globals.sv_xmax; y++)
    {
	rle_getrow( &im_globals, im_rows );

	for (i = 0; i < patches; i++)
	{
	    if (IN_WINDOW( y, patchglobals[i]))
	    {
		rle_getrow( &(patchglobals[i]), patch_rows );
		width = patchglobals[i].sv_xmax - patchglobals[i].sv_xmin + 1;
		for( c = -im_globals.sv_alpha; c < im_globals.sv_ncolors; c++)
		    bcopy( &(patch_rows[c][patchglobals[i].sv_xmin]),
			   &(im_rows[c][patchglobals[i].sv_xmin]), width );
	    }
	}
	sv_putrow( outrows, xlen, &outglobals );
    }
    
    sv_puteof( &outglobals );
    exit( 0 );
}
