/* 
 * getfb.c - Display Extended Run Length Encoding with Alpha1 channel
 *		on BRL libfb frame buffer.
 * 
 * Author:	Paul R. Stay
 * 		Ballistic Research Labratory
 * 		Aberdeen Proving Ground, Md.
 * Date:	Mon Jun 23 1986
 */
static char rcs_ident[] = "$Header$";

#include <stdio.h>
#include <brlcad/fb.h>
#include "svfb_global.h"

#define MAX_PIXELS   1024

main( argc, argv)
int argc;
char ** argv;
{
	FILE *rle_fd;
	FBIO *fbp;
	int r_debug;
	char * rle_file;
	register int i,j;

	unsigned char scanline[4][MAX_PIXELS];	/* Run length scan line */
	unsigned char *rows[4];		/* Character pointers for rle_getrow */
	
	RGBpixel pix[MAX_PIXELS];		/* pixel structure */
	int x_len, y_len;

	argc--; argv++;
	while( argv[0][0] == '-')  {

		switch( argv[0][1] )  {
		case 'd':
			r_debug = 1;
			break;
		default:
			break;
		}
		argc--; argv++;
	}

	rle_file = argv[0];

	if ( (sv_globals.svfb_fd = fopen( rle_file, "r")) < 0 )
		sv_globals.svfb_fd = stdin;

	if( rle_get_setup( &sv_globals ) < 0 )  {
		fprintf(stderr, "getfb: Error reading setup information\n");
		exit(1);
	}

	if (r_debug)
	{
		fprintf( stderr,"Image bounds\n\tmin %d %d\n\tmax %d %d\n",
			sv_globals.sv_xmin, sv_globals.sv_ymin,
			sv_globals.sv_xmax, sv_globals.sv_ymax );
		if ( sv_globals.sv_alpha )
			fprintf( stderr, "Alpha Channel present\n");
		rle_debug(1);
	}

	/* We`re only interested in R, G, & B */
	SV_CLR_BIT(sv_globals, SV_ALPHA);
	for (i = 3; i < sv_globals.sv_ncolors; i++)
		SV_CLR_BIT(sv_globals, i);

	x_len = sv_globals.sv_xmax - sv_globals.sv_xmin + 1;
	y_len = sv_globals.sv_ymax - sv_globals.sv_ymin + 1;

	if( (fbp = fb_open( "", sv_globals.sv_xmax+1, sv_globals.sv_ymax+1 )) == NULL )
		exit(12);

	for ( i = sv_globals.sv_ymin; i <= sv_globals.sv_ymax; i++)  {
		rows[0] = (unsigned char *)-1;
		rows[1] = scanline[1];	
		rows[2] = scanline[2];	
		rows[3] = scanline[3];	
		rle_getrow(&sv_globals, &rows[1] );

		for ( j = 0; j < x_len; j++)
		{
			pix[j][RED] = scanline[1][j];
			pix[j][GRN] = scanline[2][j];
			pix[j][BLU] = scanline[3][j];
		}
		fb_write( fbp, sv_globals.sv_xmin, i, pix, x_len );
	}
	exit(0);
}
