/* 
 * read_med.c - Read a med center (straight gray level) images.
 * 
 * Author:	John W. Peterson
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Mon Jun 23 1986
 * Copyright (c) 1986, University of Utah
 *
 * Here's how to read a tape if you're not Spencer:
 *	mt rew
 *	dd if=/dev/nrmt0	# Skip the tape label (first file only)
 *
 *	dd if=/dev/nrmt0	# skip the filename
 *	dd if=/dev/nrmt0 of=file1.med bs=2k  # Read the file
 *	dd if=/dev/nrmt0	# skip the EOF
 *	dd if=/dev/nrmt0	# skip the filename
 *	dd if=/dev/nrmt0 of=file2.med bs=2k  # Read the file
 *	
 */

#include <stdio.h>
#include "svfb_global.h"

#define and &&
#define or ||

#define HEADERSIZE 64		/* Bubba's header.  Don't mess with it. */
#define ROWSIZE 511		/* How big bubba's pictures are */
#define HEIGHT 480
#define NCHAN 4			/* Assumes at most 3 channels + alpha */

main(argc, argv)
int  argc;
char *argv[];
{
    char achan[ROWSIZE];
    char temp_line[ROWSIZE];
    char *rows[NCHAN];
    char junk;
    int i;
 
    sv_globals.svfb_fd = stdout;
    sv_globals.sv_alpha = 1;
    sv_globals.sv_ncolors = 1;
    sv_globals.sv_xmax = ROWSIZE;
    sv_globals.sv_ymax = HEIGHT;
    sv_setup( RUN_DISPATCH, &sv_globals );

    /* Eat Bubba's header */
    fread( temp_line, 1, HEADERSIZE, stdin );

    /* Blank alpha channel */
    for (i = 0; i < ROWSIZE; i++)
	achan[i] = 255;

    rows[0] = achan;
    for (i = 1; i <= 3; i++) rows[i] = temp_line;

    for (i = 0; i < HEIGHT; i++)
    {
	fread( temp_line, 1, ROWSIZE, stdin );
	sv_putrow( &rows[1], ROWSIZE, &sv_globals );
    }
}

