/*
 * Copyright (C) 1988 Research Institute for Advanced Computer Science.
 * All rights reserved.  The RIACS Software Policy contains specific
 * terms and conditions on the use of this software, and must be
 * distributed with any copies.  This file may be redistributed.  This
 * copyright and notice must be preserved in all copies made of this file.
 */

/*
 * Interface routines for Utah Raster Toolkit
 */

#include <stdio.h>
#include "svfb_global.h"


/*
 * Globals are stored in a structure.
 */

static struct {
    int             width;
    int             height;
    unsigned char **scan;
    int		    row;
} Globals;

rasterInit(fd, width, height)
int fd;
int width;
int height;
{
    FILE           *rleFile;
    int             i;

    Globals.width = width;
    Globals.height = height;
    if (fd == 0) {
	rleFile = stdin;
    } else {
	rleFile = fdopen(fd, "r");
    }
    sv_globals.svfb_fd = rleFile;
    rle_get_setup(&sv_globals);

    if (sv_globals.sv_xmax > width) {
	fprintf(stderr, "Warning: RLE width (%d) exceeds maximum (%d)\n", 
	    sv_globals.sv_xmax, width);
    }
    if (sv_globals.sv_ymax > height) {
	fprintf(stderr, "Warning: RLE height (%d) exceeds maximum (%d)\n", 
	    sv_globals.sv_ymax, height);
    }
    Globals.row = 0;
    Globals.scan = (unsigned char **) malloc((sv_globals.sv_ncolors +
				      sv_globals.sv_alpha) *
				     sizeof(unsigned char *));
    for (i = 0; i < sv_globals.sv_ncolors + sv_globals.sv_alpha; i++)
	Globals.scan[i] = 
	    (unsigned char *)malloc(sv_globals.sv_xmax+1);

    if (sv_globals.sv_alpha) {
	Globals.scan++;
    }
}

rasterRowGet(red, green, blue)
unsigned char *red, *green, *blue;
{
    int             i, j, max;

    if (Globals.row < sv_globals.sv_ymin || Globals.row > sv_globals.sv_ymax) {
	for (i = 0; i < Globals.width; i++) {
	    red[i] = 0;
	    green[i] = 0;
	    blue[i] = 0;
	}
    } else {
	rle_getrow(&sv_globals, Globals.scan);
	max = sv_globals.sv_xmax < Globals.width ?
	    sv_globals.sv_xmax : Globals.width;
	for (i = 0 ; i < max; i++) {
	    red[i] = Globals.scan[0][i];
	    green[i] = Globals.scan[1][i];
	    blue[i] = Globals.scan[2][i];
	}
	for (; i < Globals.width; i++) {
	    red[i] = green[i] = blue[i] = 0;
	}
    }
    Globals.row++;
}

rasterDone()
{
    sv_puteof(&sv_globals);
}
