/* 
 * getren.c - getren - Display images on the HP Rennasance (98720A)
 * 
 * Author:	John W. Peterson & Glenn McMinn
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Tue Aug 18 1987
 * Copyright (c) 1987, John W. Peterson
 *
 * TODO:
 *  - Should warn you if configuration is not sufficient (< 24 bits)
 */

#define MIN(a,b) ( a<b ? a : b)
#include <stdio.h>
#include <starbase.c.h>
#include "svfb_global.h"

#ifndef HP_DEVFILE
#define HP_DEVFILE "/dev/crtren"
#endif

#ifndef HP_DRIVER
#define HP_DRIVER "hp98721"
#endif

#define RASTERHEIGHT 1024	/* Calling inquire_sizes is just too tedious */

main(argc,argv)
int argc; char *argv[];
{
    int fildes;
    int x_len, y_len, x_off = 0, y_off = 0;
    int i, j, map_offset, max_color;
    unsigned char **scan;
    char * filename = NULL;
    int over_flag = 0;
    int pos_flag = 0;
    float tmp;
    float colors[256][3];
    gescape_arg arg1, arg2;

    if (! scanargs( argc, argv, "% pi%-xpos!dypos!d O%- infile%s",
		    &pos_flag, &x_off, &y_off, &over_flag, &filename ))
	exit( -1 );

    if (! over_flag)
	over_flag = INIT;

    if (( fildes = gopen(HP_DEVFILE, OUTDEV,
			 HP_DRIVER, over_flag )) < 0)
	fprintf(stderr, "getren: can't open hp98721\n");

    if (filename)
    {
	if (!(sv_globals.svfb_fd = fopen(filename, "r")))
	{
	    perror("getren");
	    exit(-1);
	}
    }
    else
	sv_globals.svfb_fd = stdin;

    rle_get_setup( &sv_globals );

    /* So we see the whole FB. */
    clip_indicator( fildes, CLIP_OFF );

    arg1.i[0] = FALSE;
    gescape( fildes, SWITCH_SEMAPHORE, &arg1, &arg2 );

    /* This version assumes a full 24-bit machine */
    shade_mode( fildes, CMAP_FULL, 0 );

    if ( sv_globals.sv_ncmap )	/* Use colormap in file */
    {
	map_offset = 1 << sv_globals.sv_cmaplen;
	if (sv_globals.sv_ncmap == 3)
	{
	    for (i = 0; i < 256; i++)
	    {
		colors[i][0] = (float) ((sv_globals.sv_cmap[i] >>8) & 0xFF)
		                        / 255.0;
		colors[i][1] = (float) ((sv_globals.sv_cmap[i+map_offset] >>8)
					& 0xFF) / 255.0;
		colors[i][2] = (float) ((sv_globals.sv_cmap[i+2*map_offset]>>8)
					& 0xFF) / 255.0;
	    }
	}
	else
	if (sv_globals.sv_ncmap == 1)
        {
	    for (i = 0; i < 256; i++)
	    {
		tmp = (float) ((sv_globals.sv_cmap[i] >> 8) * 0xFF);
		colors[i][0] = tmp;
		colors[i][1] = tmp;
		colors[i][2] = tmp;
	    }
	}
	else
	{
	    fprintf(stderr,
		    "getren: Sorry, don't grock N channel color maps\n");
	    exit(-1);
	}
    }
    else
    {
	/* Set the color map to default */
	for (i = 0; i < 256; i++)
	{
	    tmp = (float) i / 255.0;
	    colors[i][0] = tmp;
	    colors[i][1] = tmp;
	    colors[i][2] = tmp;
	}
    }
    define_color_table( fildes, 0, 256, colors );

    x_len = sv_globals.sv_xmax - sv_globals.sv_xmin + 1;
    y_len = sv_globals.sv_ymax - sv_globals.sv_ymin + 1;
    if (pos_flag)
    {
	if (pos_flag == 1)	/* -i, incremental position */
	{
	    x_off = sv_globals.sv_xmin + x_off;
	    y_off += sv_globals.sv_ymin;
	}
    }
    else
    {
	x_off = sv_globals.sv_xmin;
	y_off = sv_globals.sv_ymin;
    }
	
    y_off = RASTERHEIGHT - y_off; /* Invert origin */

    /* This gets rid of the left margin slop in the scanline. */
    sv_globals.sv_xmax -= sv_globals.sv_xmin;
    sv_globals.sv_xmin = 0;

    if (rle_row_alloc( &sv_globals, &scan ))
	fprintf(stderr, "getren: malloc failed\n");

    /* Display each scanline. */

    y_len = MIN( RASTERHEIGHT, y_len );
    for ( i = 0; i < y_len ; i ++)
    {
	rle_getrow(&sv_globals, scan );

	for (j = SV_RED; j < sv_globals.sv_ncolors; j++)
	{
	    /* HP numbers channels backwards from URT */
	    bank_switch( fildes, 2-j, 0 );
	    dcblock_write( fildes, x_off, y_off - i,
			  x_len, 1, scan[j] );
	}

	/* KLUDGE for black and white.  */
	while (j <= SV_BLUE)
	{
	    bank_switch( fildes, 2-j, 1 );
	    dcblock_write( fildes, x_off, y_off - i,
			  x_len, 1, scan[0] );
	    j++;
	}
    }
}

