/* 
 * getiris.c - Whoop up an rle with 24 bits ( no mex ).
 * 
 * Author:	Glenn McMinn
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Tue Feb  3 1987
 * Copyright (c) 1987 Glenn McMinn
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif


#define MIN(a,b) ( a<b ? a : b)

#include "gl.h"
#include "device.h"
#include "stdio.h"
#include "svfb_global.h"

main(argc,argv)
int argc;
char **argv;
{
        int x_len, y_len;
	int i;
	unsigned char **scan;
	FILE * rlefile = stdin;
	Device val;

	/* This program runs without mex running. */
	if ( ismex())
	{
		fprintf( stderr, "getiris:  can't run under mex!\n");
		exit(0);
	}
	ginit();

	/* Turn off cursor so that picture doesn't have a glich. */
	cursoff();
	RGBmode();
	gconfig();
	RGBcolor(0, 0, 0);
	clear();

	/* Setup mouse buttons so that they are queued. */
	qdevice( LEFTMOUSE );
	qdevice( RIGHTMOUSE );
	qdevice( MIDDLEMOUSE );
	qreset();

	/* Take input from file argument or stdin. */ 	
	rlefile = fopen(argv[1], "r");
	if (!rlefile) rlefile = stdin;
	sv_globals.svfb_fd = rlefile;
	rle_get_setup( &sv_globals );

	x_len = sv_globals.sv_xmax - sv_globals.sv_xmin + 1;
	y_len = sv_globals.sv_ymax - sv_globals.sv_ymin + 1;
	sv_globals.sv_xmax -= sv_globals.sv_xmin;
	sv_globals.sv_xmin = 0;

	/* Grab a scanline. */
	scan = (unsigned char **) malloc( (sv_globals.sv_ncolors +
				       sv_globals.sv_alpha) *
				      sizeof( unsigned char * ) );
	for ( i = 0; i < sv_globals.sv_ncolors + sv_globals.sv_alpha; i++ )
	    scan[i] = (unsigned char *)malloc( x_len );

	if ( sv_globals.sv_alpha )
	{
	    scan++;
	}

	/* Display each scanline. */
        for ( i = 0; i < MIN(y_len,768) ; i ++)
	{
		rle_getrow(&sv_globals, scan );

		cmov2i(0, i);
		writeRGB(x_len, scan[0], scan[1], scan[2]);
	}

	/* Wait for a mouse button push. */
	qread( &val);

	/* Set the iris back up so that it is not scrogged. */
	singlebuffer();
	gconfig();
	clear();
	gexit();
}
