/* 
 * mix.c - Merge "gray level" images into an RLE image
 * 
 * Author:	John W. Peterson
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Tue Feb  3 1987
 * Copyright (c) 1987, John W. Peterson
 *
 * Useage: mix [-w] redfile greenfile bluefile
 *
 * mix takes three files of gray scale images (specified as 512x512 byte
 * images) and converts them into a single three channel RLE file.  If -w
 * is specified, it converts a single 512x512 byte file into an RLE file.
 * This program was written to deal with output from a local video 
 * digitizer.
 */

#include <stdio.h>
#include <svfb_global.h>


main(argc, argv)
int argc;
char **argv;
{
    char *rfilename = NULL, *gfilename = NULL, *bfilename = NULL;
    FILE *r_fd = NULL, *g_fd = NULL, *b_fd = NULL;
    rle_pixel ** rows;
    int buflen, i;
    int one_flag = NULL;

    if (!scanargs(argc, argv, "% w%- rfile%s gfile%s bfile%s", &one_flag,
		  &rfilename, &gfilename, &bfilename))
	exit(-1);

    sv_globals.sv_ymax = 511;	/* Assume other defaults are what we want. */

    if (one_flag)
	sv_globals.sv_ncolors = 1;
    else
	sv_globals.sv_ncolors = 3;

    sv_globals.sv_alpha = 0;
    sv_globals.svfb_fd = stdout;

    sv_setup( RUN_DISPATCH, &sv_globals );

    if (rle_row_alloc( &sv_globals, &rows ))
	{fprintf(stderr, "mix: malloc failed\n"); exit(-1); }

    if (rfilename)
	if (! (r_fd = fopen(rfilename, "r")))
	    fprintf(stderr, "mix: Can't open %s.\n", rfilename);
    if (gfilename)
	if (! (g_fd = fopen(gfilename, "r")))
	    fprintf(stderr, "mix: Can't open %s.\n", gfilename);
    if (bfilename)
	if (! (b_fd = fopen(bfilename, "r")))
	    fprintf(stderr, "mix: Can't open %s.\n", bfilename);

    if (one_flag && (g_fd || b_fd))
	{ fprintf(stderr, "mix: only one channel used with -w\n"); exit(-1); }

    for (i = 0; i < 512; i++)
    {
	if (r_fd)
	{
	    if (!(512 == fread(rows[SV_RED], sizeof(rle_pixel), 512, r_fd)))
		fprintf("mix: didn't read 512\n");
	}
	else
	    bzero( rows[SV_RED], 512 );

	if (g_fd)
	{
	    if (!(512 == fread(rows[SV_GREEN], sizeof(rle_pixel), 512, g_fd)))
		fprintf("mix: didn't read 512\n");
	}
	else
	    { if (!one_flag) bzero( rows[SV_GREEN], 512 ); }

	if (b_fd)
	{
	    if (!(512 == fread(rows[SV_BLUE], sizeof(rle_pixel), 512, b_fd)))
		fprintf("mix: didn't read 512\n");
	}
	else
	    { if (!one_flag) bzero( rows[SV_BLUE], 512 ); }

	sv_putrow( rows, 512, &sv_globals );
    }
}
