/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notices are 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * graytorle.c - Create an RLE image from gray pixels.
 * 
 * Author:	Michael J. Banks
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Wed Jun 22 1988
 * Copyright (c) 1988, University of Utah
 */

#include <stdio.h>
#include "svfb_global.h"

typedef FILE	*FILPTR;

/*
 * usage : graytorle xsize ysize [-h hdrsize] [-o outfile] [-a] files ...
 *
 *    xsize,ysize	Size of input files.
 *    -h hdrsize	Input file header to discard.
 *    -o outfile	Output file name.
 *    -a		Uses first input file as alpha channel.
 */

main(argc, argv)
int  argc;
char *argv[];
{
    FILPTR *inpfil;		/* Input file pointers. */
    FILE *outfil;		/* Output file pointer. */
    int xsize, ysize;		/* Image size. */
    int hsize, hflag = 0;	/* Image header size. */
    int aflag = 0;		/* Alpha channel flag. */
    int oflag = 0;		/* Output file flag. */
    int files;			/* Number of files. */
    char **fname;		/* List of input file names. */
    char *oname;		/* Output file name. */
    rle_pixel **outrow;		/* Output buffer. */
    int i, row;
    char *trash;

    if (! scanargs( argc,argv,
	"% xsize!d ysize!d h%-hdrsize!d o%-outfile!s a%- files!*s",
	    &xsize, &ysize,
	    &hflag, &hsize,
	    &oflag, &oname,
	    &aflag,
	    &files, &fname ))
	exit( -1 );

    /* 
     * Get enough file pointers for all input files that are specified,
     * and try to open them.
     */

    inpfil = (FILPTR *)malloc( sizeof( FILPTR ) * files );
    for ( i=0; i<files; i++ )
    {
	if ( (inpfil[i] = fopen( fname[i], "r" )) == NULL )
	{
	    perror( fname[i] );
	    exit( -1 );
	}
    }

    /* If an output file is specified, open it. Otherwise use stdout. */

    if ( oflag )
    {
	if ( (outfil = fopen( oname, "w" )) == NULL )
	{
	    perror( oname );
	    exit( -1 );
	}
    }
    else
	outfil = stdout;


    /* Throw away file headers. */

    if ( hflag && (hsize > 0) ) 
    {
	trash = (char *)malloc( hsize );

	for ( i=0; i<files; i++ )
	    fread( trash, 1, hsize, inpfil[i] );

	free( trash );
    }

    /* Adjust alpha channnel flag to use as index. */

    if ( aflag ) 
	aflag = 1;
    else
	aflag = 0;

    /* Initialize globals and allocate image row storage. */

    sv_globals.sv_alpha = aflag;
    sv_globals.sv_ncolors = files - aflag;
    sv_globals.sv_xmax = xsize - 1;
    sv_globals.sv_ymax = ysize - 1;
    sv_globals.svfb_fd = outfil;
    for ( i = -aflag; i<sv_globals.sv_ncolors; i++)
	SV_SET_BIT( sv_globals, i );
    sv_setup( RUN_DISPATCH, &sv_globals );

    if (rle_row_alloc( &sv_globals, &outrow ))
    {
	fprintf(stderr, "Ran out of heap space!!\n");
	exit(-2);
    }

    /* Combine rows and write to output file.  Adjust for alpha. */

    for ( row=0; row<ysize; row++)
    {
	for ( i = -aflag; i<files-aflag; i++ )
	    fread( outrow[i], 1, xsize, inpfil[i+aflag] );
	sv_putrow( outrow, xsize, &sv_globals );
    }
}

