/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * tobw.c - Filter to change an RLE file to B&W.
 * 
 * Author:	Spencer W. Thomas
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Tue Feb 25 1986
 * Copyright (c) 1986, University of Utah
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif

#include <stdio.h>
#include <math.h>
#include "svfb_global.h"

/*****************************************************************
 * TAG( main )
 * 
 * Usage: tobw [-t] [-o outfile] [infile]
 * 
 * Inputs:
 *	-t:		If specified, output a 3-channel image (all three
 *			the same).
 * 	infile:		Input (color) RLE file.  Stdin used if not
 *			specified.
 * Outputs:
 * 	outfile:	Output (black & white) RLE file.  Stdout used
 *			if not specified.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */

main( argc, argv )
char **argv;
{
    char * infname = NULL, * outfname = NULL;
    FILE * infile = stdin, * outfile = stdout;
    int oflag = 0, tflag = 0, y, nrow, nscan, i;
    long file_index;
    struct sv_globals out_glob;
    unsigned char ** scan, *outscan[4];
    unsigned char * buffer;

    if ( scanargs( argc, argv, "% t%- o%-outfile!s infile%s",
		    &tflag, &oflag, &outfname, &infname ) == 0 )
	exit( 1 );

    if ( infname != NULL && (infile = fopen( infname, "r" )) == NULL )
    {
	perror( infname );
	exit( 1 );
    }

    sv_globals.svfb_fd = infile;

    rle_get_setup_ok( &sv_globals, "tobw", infname );

    if ( sv_globals.sv_ncolors == 1 )
    {
	fprintf( stderr, "%s is already black & white\n",
		    infname ? infname : "stdin" );
	exit( 0 );
    }
    if ( sv_globals.sv_ncolors < 3 )
    {
	fprintf( stderr, "%s is not RGB",
		    infname ? infname : "stdin" );
	exit( 0 );
    }
    if ( sv_globals.sv_alpha )
	SV_SET_BIT( sv_globals, SV_ALPHA );

    if ( outfname != NULL && (outfile = fopen( outfname, "w" )) == NULL )
    {
	perror( outfname );
	exit( 1 );
    }

    out_glob = sv_globals;

    sv_globals.sv_xmax -= sv_globals.sv_xmin;
    sv_globals.sv_xmin = 0;
    nrow = sv_globals.sv_xmax + 1;
    nscan = (sv_globals.sv_ymax - sv_globals.sv_ymin + 1);
    buffer = (unsigned char *)malloc( nrow );
    scan = (unsigned char **) malloc( (sv_globals.sv_ncolors +
				       sv_globals.sv_alpha) *
				      sizeof( unsigned char * ) );

    for ( i = 0;
	  i < sv_globals.sv_ncolors + sv_globals.sv_alpha;
	  i++ )
	scan[i] = (unsigned char *)malloc( nrow );

    if ( sv_globals.sv_alpha )
    {
	scan++;
	outscan[0] = scan[-1];
    }
    outscan[1] = buffer;
    /* If 3 channel output, reference the line 3 times */
    if ( tflag )
	outscan[2] = outscan[3] = buffer;

    if ( ! tflag )
	out_glob.sv_ncolors = 1;
    else
	out_glob.sv_ncolors = 3;

    if ( sv_globals.sv_background != NULL )
    {
	out_glob.sv_bg_color = (int *)malloc( sizeof( int ) );
	rgb_to_bw( &sv_globals.sv_bg_color[0],
		   &sv_globals.sv_bg_color[1],
		   &sv_globals.sv_bg_color[2],
		   &out_glob.sv_bg_color[0], 1 );
    }

    out_glob.svfb_fd = outfile;

    sv_setup( RUN_DISPATCH, &out_glob );

    while ( (y = rle_getrow( &sv_globals, scan )) <=
	    sv_globals.sv_ymax )
    {
	rgb_to_bw( scan[0], scan[1], scan[2], buffer, nrow );
	sv_putrow( &outscan[1], nrow, &out_glob );
    }
    sv_puteof( &out_glob );
    exit( 0 );
}
