/* 
 * rlehisto.c - Create histogram image of an RLE file.
 * 
 * Author:	Rod Bogart
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Thu Nov  6 1986
 * Copyright (c) 1986 Rod Bogart
 * 
 * Flags:
 *    -r ratio	Scale height of histogram by "ratio"
 *    -t	Print totals of each value in each channel.
 *    -h	Height of image.
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif


#include <stdio.h>
#include <svfb_global.h>

#define MAXCHAN 10

main(argc, argv)
int	argc;
char	*argv[];
{
    FILE *rlefile, *outfile;
    float ratio = 2.0;
    int i, j, total, tflag=0, rflag=0, oflag=0;
    int hist_height = 480;
    struct sv_globals inglobals;
    rle_pixel ** rows, ** rowsout;
    rle_pixel *pixptr;
    float *pixelcount[256];
    int	chan, nchan;
    char *infname = NULL, *outfname = NULL;

    if ( scanargs( argc, argv,
		  "% r%-ratio!f h%-hist_height!d t%- o%-outfile!s infile%s",
		  &rflag, &ratio, &i, &hist_height, &tflag,
		  &oflag, &outfname, &infname ) == 0 )
	exit( 1 );

    if ( infname != NULL &&
	(inglobals.svfb_fd = fopen( infname, "r" )) == NULL )
    {
	perror( infname );
	exit( 1 );
    }
    if (infname == NULL) inglobals.svfb_fd = stdin;
    if (oflag && (sv_globals.svfb_fd = fopen( outfname, "w" )) == NULL )
    {
	perror( outfname );
	exit( 1 );
    }
    if (!oflag) outfile = stdout;

    if (ratio < 0.0)
    {
	    fprintf( stderr, "Ratio must be positive\n");
	    exit( 1 );
    }

    rle_get_setup_ok( &inglobals, "rlehisto", infname );

    inglobals.sv_xmax -= inglobals.sv_xmin;
    inglobals.sv_xmin = 0;
    inglobals.sv_alpha = (inglobals.sv_alpha==1) ? 1 : 0;
    sv_globals.sv_alpha = inglobals.sv_alpha;
    sv_globals.sv_ncolors = inglobals.sv_ncolors;
    sv_globals.sv_xmin = 0;
    sv_globals.sv_xmax = 511;
    sv_globals.sv_ymin = 0;
    sv_globals.sv_ymax = hist_height;

    nchan = inglobals.sv_ncolors + inglobals.sv_alpha;

    if (!tflag)
	sv_setup( RUN_DISPATCH, &sv_globals );

    if ( (rle_row_alloc( &sv_globals, &rowsout )) ||
	 (rle_row_alloc( &inglobals, &rows ) ))
    {
	fprintf( stderr, "rlehisto: malloc failed\n" );
	exit( -2 );
    }

    for ( j = 0; j < 256; j++)
    {
	pixelcount[j] = (float *) malloc(sizeof(float) * nchan);
	for (chan=0; chan < nchan; chan++)
	{
	    pixelcount[j][chan] = 0;
	}
    }

    for (j=inglobals.sv_ymin; j < inglobals.sv_ymax; j++)
    {
	rle_getrow(&inglobals, rows);
	for (chan=0; chan < nchan; chan++)
	{
	    pixptr = rows[chan];
	    for (i=0; i < inglobals.sv_xmax + 1; i++)
	    {
		pixelcount[ *pixptr ][ chan ] += 1.0;
		pixptr++;
	    }
	}
    }

    /* after entire image has been read in, output the histogram */

    if (tflag)
    {
	for (chan = 0; chan < nchan; chan++)
	{
	    fprintf(outfile, "\nTotals for channel %d\n\n",
			chan - inglobals.sv_alpha);
	    for (j = 0; j < 256; j++)
	    {
		fprintf(outfile, "  %3d   %d\n", j, (int) pixelcount[j][chan]);
	    }
	}
    }
    else
    {
	for (i = 0; i < hist_height; i++)
	{
	    for (chan = 0; chan < nchan; chan++)
	    {
		for (j = 0; j < 256; j++)
		{
		    if (pixelcount[j][chan] > 0)
		    {
			rowsout[chan][j*2] = rowsout[chan][1+j*2] = 255;
			pixelcount[j][chan] -= ratio;
		    }
		    else
		    {
			rowsout[chan][j*2] = rowsout[chan][1+j*2] = 0;
		    }
		}
	    }
	    sv_putrow( rowsout, 512, &sv_globals);
	}
    }
}
