/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * repos.c - Reposition RLE image.
 * 
 * Author:	Rod Bogart & John W. Peterson
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Sat Jun 21 1986
 * Copyright (c) 1986, University of Utah
 * 
 */
#ifndef lint
static char rcs_ident[] = "$Header:$";
#endif

#include <stdio.h>
#include <svfb_global.h>

char buffer[4096];

main(argc, argv)
int	argc;
char	*argv[];
{
    int buflen, xlen, ylen, xpos, ypos, posflag=0;
    int incflag=0, xinc, yinc;
    char * infilename = NULL;

    struct sv_globals inglobals, outglobals;

    if (scanargs(argc, argv, "% p%-xpos!dypos!d i%-xinc!dyinc!d infile%s",
                 &posflag, &xpos, &ypos, &incflag, &xinc, &yinc,
		 &infilename) == 0)
    {
	exit(-1);
    }

    if (infilename)
    {
	inglobals.svfb_fd = fopen(infilename, "r");
	if (! inglobals.svfb_fd)
	{
	    fprintf( stderr, "repos: can't open %s\n", infilename);
	    exit(-1);
	}
    }
    else
	inglobals.svfb_fd = stdin;

    rle_get_setup_ok( &inglobals, "repos", infilename );

    outglobals = inglobals;
    outglobals.svfb_fd = stdout;
    xlen = inglobals.sv_xmax - inglobals.sv_xmin;
    ylen = inglobals.sv_ymax - inglobals.sv_ymin;

    if (posflag)
    {
	outglobals.sv_xmin = xpos;
	outglobals.sv_ymin = ypos;
	outglobals.sv_xmax = xpos + xlen;
	outglobals.sv_ymax = ypos + ylen;
    }
    else if (incflag)
    {
	outglobals.sv_xmin = inglobals.sv_xmin + xinc;
	outglobals.sv_ymin = inglobals.sv_ymin + yinc;
	outglobals.sv_xmax = inglobals.sv_xmax + xinc;
	outglobals.sv_ymax = inglobals.sv_ymax + yinc;
    }
    else
    {
	/* nothing specified on command line, assume -p 0 0 */
	outglobals.sv_xmin = 0;
	outglobals.sv_ymin = 0;
	outglobals.sv_xmax = xlen;
	outglobals.sv_ymax = ylen;
    }

    if ((outglobals.sv_xmin < 0) || (outglobals.sv_ymin < 0))
    {
	fprintf(stderr, "Negative boundaries are not allowed!!!\n");
	exit( -1 );
    }

    sv_setup( RUN_DISPATCH, &outglobals );

    while ( (buflen = fread(buffer, sizeof(char), 4096,
			    inglobals.svfb_fd)) > 0 )
    {
	fwrite( buffer, sizeof(char), buflen, stdout );
    }
}
