/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is 
 * preserved on all copies.
 * 
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the 
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/* 
 * rle_putcom.c - Add a picture comment to the globals struct.
 * 
 * Author:	Spencer W. Thomas
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Mon Feb  2 1987
 * Copyright (c) 1987, University of Utah
 */

#include <stdio.h>
#include <svfb_global.h>

/*****************************************************************
 * TAG( match )
 * 
 * Match a name against a test string for "name=value" or "name".
 * If it matches name=value, return pointer to value part, if just
 * name, return pointer to NUL at end of string.  If no match, return NULL.
 *
 * Inputs:
 * 	n:	Name to match.  May also be "name=value" to make it easier
 *		to replace comments.
 *	v:	Test string.
 * Outputs:
 * 	Returns pointer as above.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */
static char *
match( n, v )
register char *n;
register char *v;
{
    for ( ; *n != '\0' && *n != '=' && *n == *v; n++, v++ )
	;
    if (*n == '\0' || *n == '=')
	if ( *v == '\0' )
	    return v;
	else if ( *v == '=' )
	    return ++v;

    return NULL;
}

/*****************************************************************
 * TAG( rle_putcom )
 * 
 * Put a comment into the globals struct.
 * Inputs:
 * 	value:		Value to add to comments.
 *	globals:	Globals struct to add to.
 * Outputs:
 * 	globals:	Modified globals struct.
 *	Returns previous value;
 * Assumptions:
 * 	value pointer can be used as is (data is NOT copied).
 * Algorithm:
 * 	Find match if any, else add at end (realloc to make bigger).
 */
char *
rle_putcom( value, globals )
char * value;
struct sv_globals * globals;
{
    register char ** cp;
    char * v;
    int i;

    if ( globals->sv_comments == NULL )
    {
	globals->sv_comments = (char **)malloc( 2 * sizeof(char *) );
	globals->sv_comments[0] = value;
	globals->sv_comments[1] = NULL;
    }
    else
    {
	for ( i = 2, cp = globals->sv_comments; *cp != NULL; i++, cp++ )
	    if ( match( value, *cp ) != NULL )
	    {
		v = *cp;
		*cp = value;
		return v;
	    }
	/* Not found */
	globals->sv_comments = (char **)realloc( globals->sv_comments,
						 i * sizeof(char *) );
	globals->sv_comments[--i] = NULL;
	globals->sv_comments[--i] = value;
    }

    return NULL;
}

/*****************************************************************
 * TAG( rle_delcom )
 * 
 * Delete a comment from globals struct.
 * Inputs:
 * 	name:		Name of comment to delete.
 *	globals:	Globals to delete comment from.
 * Outputs:
 * 	globals:	Modified globals struct.
 *	Returns original comment value.
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */
char *
rle_delcom( name, globals )
char * name;
struct sv_globals *globals ;
{
    register char ** cp;
    char * v = NULL;

    if ( globals->sv_comments == NULL )
	return NULL;
    else
    {
	for ( cp = globals->sv_comments; *cp != NULL; cp++ )
	    if ( match( name, *cp ) != NULL )
	    {
		v = *cp;
		for ( ; *cp != NULL; cp++ )
		    *cp = cp[1];
		break;
	    }
	/* Not found */
    }

    if ( *globals->sv_comments == NULL )
	globals->sv_comments = NULL;

    return v;
}
