/* 
 * getqcr.c - Image display for the Matrix QCR-Z
 * 
 * Author:	John W. Peterson
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Wed Jan 20 1988
 * Copyright (c) 1988, University of Utah
 *
 * BUGS
 *  verbose flag should turn on "reading red..." type messages.
 *  Should handle single channel images as black and white.
 */

#include <stdio.h>
#include "qcr.h"
#include "svfb_global.h"

main (argc, argv)
int argc;
char ** argv;
{
    rle_pixel * camera_data = NULL, * cdptr;
    rle_pixel ** rows;
    char * filename;
    int color = 0;
    int y, i, ysize;
    int verbose_flag = 0, double_flag = 0, exposures = 1, exp_flag = 0;
    int center_flag = 0, pos_flag = 0, fourK = 0, xstart = 0, ystart = 0;

    if (! scanargs( argc, argv,
		   "% fname!s v%- d%- c%- f%- p%-xpos!dyposn!d e%-num!d",
		   &filename, &verbose_flag, &double_flag, &center_flag,
		   &fourK, &pos_flag, &xstart, &ystart,
		   &exp_flag, &exposures ))
	exit(-1);

    sv_globals.sv_ncolors = 1;	/* Assume at least one */
    init_qcr( verbose_flag );

    if (double_flag)
	exposures = 2;

    while( color < sv_globals.sv_ncolors )
    {
	if (! (sv_globals.svfb_fd = fopen( filename, "r" )))
	{
	    perror("getqcr");
	    exit(-2);
	}

	rle_get_setup_ok( &sv_globals, "getqcr", filename );

	if (! pos_flag)
	{
	    xstart = sv_globals.sv_xmin;
	    ystart = sv_globals.sv_ymin;
	}

	sv_globals.sv_xmax -= sv_globals.sv_xmin;
	sv_globals.sv_xmin = 0;
	ysize = (sv_globals.sv_ymax - sv_globals.sv_ymin + 1);

	if (! camera_data)	/* Only allocate once */
	{
	    rows = (rle_pixel **) malloc( sv_globals.sv_ncolors
					 * sizeof( rle_pixel * ));
	    camera_data = (rle_pixel *)
		malloc( (sv_globals.sv_xmax + 1) * ysize);

	    if (! (rows && camera_data))
	    {
		fprintf(stderr, "getqcr: out of memory\n");
		exit(-2);
	    }
	}

	/* Only read one color at a time, never alpha */
	for (i = -sv_globals.sv_alpha; i < sv_globals.sv_ncolors; i++)
	    SV_CLR_BIT( sv_globals, i );
	SV_SET_BIT( sv_globals, color );

	rows[color] = camera_data;

	if (center_flag)
	    set_up_qcr( sv_globals.sv_xmax + 1, ysize, ysize, 0 );
	else
	    set_up_qcr_nc( xstart, ystart,
			   sv_globals.sv_xmax + 1, ysize, fourK );

	for (y = sv_globals.sv_ymin; y <= sv_globals.sv_ymax; y++)
	{
	    rle_getrow( &sv_globals, rows );
	    rows[color] = &(rows[color][sv_globals.sv_xmax+1]);
	}

	for ( i = 0; i < exposures; i++)
	    send_pixel_image( color, camera_data,
			      (sv_globals.sv_xmax + 1) * ysize);

	fclose( sv_globals.svfb_fd );
	color++;
    }
    exit( 0 );
}
