#! /bin/awk -f
#
# Massage the makefile to include or remove specific device programs.
#
# #define lines set symbols for inclusion
#
# Everything between #ifdef/#endif will be processed as follows:
# If the symbol is defined, then
#	Any line beginning #@ has the #@ removed.  Other lines are unchanged.
# If the symbol is not defined, then
# 	Any line not beginning with a # has a #@ inserted at the beginning.
#

BEGIN		{ processing = 0; emitting = 0; emit = "" }

/^#define/	{ syms[$2] = 1; }

/^#ifdef/	{ processing = 1; including = syms[$2]; print; next; }

/^#endif/	{ processing = 0; }

/^#ifadd/	{ 
    if ( syms[$2] == 1 ) vars[$3] = vars[$3] " " $4;
}

emitting == 1 && $1 == emit{
    printf( "%s = %s\n", $1, vars[$1] );
    emitting = 0;
    next;
}

/^#emit/	{ emitting = 1; emit = $2; }


/^#@/ && processing == 1 && including == 1 {
    printf( "%s\n", substr( $0, 3 ) );
    next;
}

processing == 1 && including != 1 && /^[^#]/ {
    printf( "#@%s\n", $0 );
    next;
}

{ print; }
