#include <stdio.h>
#include "annotation.h"

static ANNOTATION	* note_head = NULL;
static ANNOTATION	* note_tail = NULL;

void
setup_annotation (file_name, routine)

char		* file_name;
void		( * routine) ();

{
char		* ptr;
int		x;
int		y;
int		length;
char		line[256];
FILE		* in;

in = fopen (file_name, "r");
if (in == NULL) {
    fprintf (stderr, "annotation file %s is not readable\n", file_name);
    return;
    }

while ( ! feof (in) ) {

    if ( fgets (line, 256, in) == NULL) break;

    length = strlen (line);
    if (length == 0) continue;
    if (line[length - 1] == '\n') line[length - 1] = '\0';
    if (sscanf (line, "[%d,%d]", &x, &y) != 2) {
	fprintf (stderr, "Improper annotation: `%s'\n", line);
	fprintf (stderr, "Format is `[1,1]text'\n");
	fclose (in);
	return;
	}

    for (ptr = line; *ptr != '\0' && *ptr != ']'; ptr++) {}
    if (*ptr == '\0') {
	fprintf (stderr, "Program bug: should have given an improper annotation\n");
	fprintf (stderr, "line was `%s'\n", line);
	fclose (in);
	return;
	}

    ptr++;

    add_to_annotation (x, y, ptr);

    if (routine != NULL) (*routine) (x, y, ptr);

    }


fclose (in);

}

void
add_to_annotation (x, y, string)

int			x;
int			y;
char			* string;

{
ANNOTATION	* note;
int		length;
char		* str;

length = strlen (string);
str = (char *) malloc (length + 1);
if (str == NULL) {
    perror ("setup_annotation malloc");
    return;
    }

strcpy (str, string);

note = (ANNOTATION *) malloc (sizeof (ANNOTATION));
if (note == NULL) {
    perror ("setup_annotation malloc");
    return;
    }
note->next = NULL;

if (note_head == NULL) note_head = note;
if (note_tail != NULL) note_tail->next = note;
note_tail = note;

note->x = x;
note->y = y;
note->string = str;

}

ANNOTATION	* 
find_closest_annotation (given_x, given_y, max_distance)

int			given_x;
int			given_y;
int			max_distance;

{
register ANNOTATION	* note;
register ANNOTATION	* closest;
register int		x;
register int		y;
register int		closest_distance;
register int		distance;

closest = NULL;
closest_distance = max_distance * max_distance; /* max distance to find */

for (note = note_head; note != NULL; note = note->next) {

    x = note->x - given_x;
    y = note->y - given_y;
    distance = (x * x) + (y * y);
    if (distance < closest_distance) {
	closest = note;
	closest_distance = distance;
	}

    }

return (closest);

}

ANNOTATION *
find_next_annotation (cur)

ANNOTATION *		cur;

{
ANNOTATION *		ret;

if (cur == NULL || cur->next == NULL) return (note_head);
else return (cur->next);

}

