/* 
 * rle_to_gray.c - Convert an rle image into simple gray level image.
 * 
 * Author:	Eliot M. Weitz
 * 		Computer Science Dept.
 * 		University of Utah
 * Date:	Sun Feb  1 1987
 * Copyright (c) 1987, Eliot M. Weitz
 */

#include "stdio.h"
#include "svfb_global.h"

main(argc,argv)
int argc;
char *argv[];
{
    char head[1024];
    unsigned char scanline[4][512], outline[512], *rows[5];
    int nscan, row, i;

    char *rle_file;
    FILE *fp, *fopen();

    if ( ! scanargs( argc, argv, 
		    "rle_to_gray r!-rle_file!s" ,&i , &rle_file)) exit(1);


    fp = fopen(rle_file,"r");
    sv_globals.svfb_fd = fp;
    rle_get_setup( &sv_globals );

    nscan = (sv_globals.sv_ymax - sv_globals.sv_ymin + 1);
    sprintf(head,"Image %s nrows = %d ncols = 512",rle_file,nscan);
    write(1,head,1024);
    for (i=0; (i<4); i++)
	rows[i] = scanline[i];
    rows[4] = outline;
    for (row=0; (row<nscan); row++)
    {
	rle_getrow( &sv_globals, &rows[1]);
	rgb_to_bw( rows[1], rows[2], rows[3], rows[4], 512);
	write(1,outline,512);
    }
}
