.TH Touchup 1 "26 March 1988"
.SH NAME
touchup \- a bitmap graphics editor for Sun raster files
.SH SYNOPSIS
.B touchup
[ \fB\-x width ]
[ \fB\-y height ]
[ \fB\-n ]
[ \fB\-p ]
.SH DESCRIPTION
.IX "touchup command"  ""  "\fLtouchup\fP \(em bitmap editor"
.IX edit  bitmaps
.IX "screen bitmaps"  edit
.LP
.I Touchup
is an editor for bitmap raster files in \fISun raster file\fP\^(5)\fR 
format.
.SH OPTIONS
.IP \fB\-x
\fItouchup\fP will start up with the width of the drawing area given
by the argument after -x.
Otherwise, the default drawing area has a width of 1152 pixels
.IP \fB\-y
\fItouchup\fP will start up with the height of the drawing area given
by the argument after -y.
Otherwise, the default drawing area has a height of 900 pixels
.IP \fB\-p
\fItouchup\fP will start up with a drawing area of 900x1152 if this option
is used.
These dimensions are more suitable for printing out pages of text on the
laser printer, since drawing area is in proportion to normal paper size.
.IP \fB\-n
This option disables the 'undo' command so that \fItouchup\fP
will require less memory.  The use of this
option will make the color version much more
usable, by freeing up a large amount of the memory.

.SH COMMANDS
.LP
To edit a bitmap, type `\fBtouchup\fP'.  
A \fIraster file\fP
file name may be typed into the file name field once the program has started.
If it exists, the \fIraster file\fP must be in \fISun Rasterfile\fP\^(5) format.
When the program starts, it displays a single large window containing
five subwindows.
From top to bottom, the five subwindows are:
.IP "1)" 5
The topmost subwindow, an option subwindow, 
allows you to set global parameters for the entire drawing area and
specify operations for loading and saving files.
The options are:
.RS 
.IP "\fB(Load)\fP" 10
Read in the raster file specified in the file name field.
.IP "\fBLoad:Cut/Paste buffer\fP" 10
When the load cycle is set to this mode all raster files will be loaded into
the Cut/Paste buffer, then it can be previewed with the "view" feature.
Note: When a color image is loaded in the Cut/Paste buffer the color map for
that image is lost. The colormap is only loaded in when a color image is
loaded on to the drawing area, with option 'Load:entire image'.
.IP "\fBLoad:entire image\fP" 10
When the load cycle is set to this mode all raster files will be loaded into
the drawing area and the size of the drawing area will be restricted to the
size of the raster file.  If the image has depth greater then one then the
colormap is loaded in so that the can be properly view.
.IP "\fB(Save)\fP"
Write the current raster file onto disk with the name in the file name field.
.IP "\fBSave:Cut/Paste buffer\fP" 10
When the save cycle is set to this mode only the current Cut/Paste buffer
will be saved to the file in the filename field.
.IP "\fBSave:entire image\fP" 10
When the save cycle is set to this mode the current image in the drawing
area will be saved to a file in the filename field.
.IP "\fBSave:standard format\fP" 10
When the save cycle is set to this mode the current image
will be saved out in the standard Sun raster file format.
.IP "\fBSave:compress\fP" 10
When the save cycle is set to this mode the current image 
will be saved out in the Sun raster file
BYTE_ENCODED format.  This will often compress the file to one half
the normal size. One of the problems with saving a file in compressed
format is that the 'screenload' command will then not be able to read the
file.
.IP "\fB(Quit)\fP"
Quit the program.
.IP "\fBFile name:\fP"
The file name of the current bitmap. When you are typing in the file name
the ESC key can be used to do standard csh filename completion.
.IP "\fBGrid:none\fP"
When Grid is set to some value other that "none" every bitmap operation
will be forced to the closest grid point.  The number after Grid is the number of
pixels between each grid point.  The actual grid is not visible.
.IP "\fB(undo)\fP"
When this button pressed the last operation effecting the drawing area will be removed.
.IP "\fB(view)\fP"
When this button is pressed a window will be displayed containing
one of two possible images, depending on the "view" cycle.
.IP "\fBview:man page\fP"
This will set the view to the manual page entry for Touchup, so that when
the "view" button is pressed, a window containing the manual page
will be displayed.
.IP "\fBview:Cut/Paste\fP"
This will set the view to the current Cut/Paste buffer, so that when
the "view" button is pressed, a window with current Cut/Paste buffer
will be displayed.
.IP "\fBview:Touchup info\fP"
This will set the view to the copyright notice for touchup, so that when
the "view" button is pressed, a window with the copyright notice
will appear.
.IP "\fBBorders:Yes\fP"
This cycle determines is borders are drawn on filled reactangles
and filled polygons.
.IP "\fBDraw color:Black\fP"
This cycle determines the color for DRAWing points, the border of
filled reactangles, the border of filled polygons, the FILL color, and lines.
.IP "\fBtext string:\fP"
This is the string that is copied to the bitmap when the TEXT command is used.
.IP "\fBfonts:ABC\fP"
This cycle determines the font for the text when the TEXT command is used.
.IP "\fBMessages\fP"
The bottom line of this window is a message subwindow, which displays
messages, prompts, and warnings.
.RE
.RE
.IP "2)" 5
The second subwindow, the subwindow on the lefthand edge of the main window,
is the pattern subwindow.  This subwindow contains all of the paint
and fill patterns that can be used to draw pictures.
The current pattern is selected by placing the mouse cursor on top of
the pattern that you want and pressing the LEFT mouse button.
.IP "\fB(Define pattern)\fP"
Before this button is pressed, select a point on the drawing area that
you wish to have as a new paint pattern, then press "Define pattern" the
area centered at the selected point will then become the last paint pattern
in the pattern window.
.IP "3)" 5
The third subwindow is the command subwindow. This window is the one that
is on the right hand side of the main window. To select a command place the
the mouse cursor on top of the command that you want and press the LEFT
mouse button.
.IP "\fBTEXT\fP" 10
First move to the Text string field in the topmost window and type in the
text that you wish to place on the bitmap.  Then use the SELECT POINT mode
to select a point within the drawing area.  Once both of these two things are
done press the TEXT command icon with "ABC" on it, and the current
text string will be placed on to the bitmap in the currently selected font.
.IP "\fBMAGNIFY\fP" 10
First use the SELECT POINT mode to select a point within the drawing area that
you wish to look at in detail.  Then press the command icon for MAGNIFY
and a new subwindow with a magnified view of the selected area will be displayed.
In the top line of the MAGNIFY subwindow you can set the magnification to any
value between one and twenty.  When the mouse cursor is within the magnified
drawing area, there are three possible commands.  The LEFT mouse button will
change the current bit to the opposite color and then continue to draw in
that color.  When the MIDDLE mouse button is held down and moved, it will change
the area of the bitmap that is magnified.  When you are editing color images
the RIGHT mouse button will change the current drawing color to the color of
the pixel the mouse cursor is on top of.
.IP "\fBSELECT REGION\fP" 10
First click the picture of the box made of dotted lines.
Then move to the drawing area and press the LEFT button when
the cursor is at the desired position and continue to hold the
LEFT button down while you drag the box to the opposite corner of the
region you wish to select.
If you double click SELECT REGION then the entire drawing area will be
selected.
If you need to select an area bigger than the drawing window,
first select one of the corners of the region with the LEFT mouse
button.  Then scroll the window so that the other corner of the
region you want is now visible.  Place the cursor on top of the
other corner of the region you want and press the the MIDDLE
mouse button.
.IP "\fBSELECT POINT\fP" 10
First click the picture of the cross hairs.
Then press the LEFT mouse button down and a cross hair
will appear; move the mouse while holding the LEFT mouse button down and the
cross hair will follow it. Releasing the
the button will leave the cross hair.
.IP "\fBLASSO\fP"
First select the picture of the LASSO, (right above the paint brush), then
move the mouse to the drawing area.  To LASSO a object hold down the LEFT mouse
button and encircle the object that you wish to capture while the LEFT
button is pressed.  When you let go of the LEFT mouse button the selected
object will first be highlighted and then it will be copied into the Cut/Paste
buffer. Then you will be placed into MOVE mode, this function is documented
in the Cut/Paste buffer operations section.
.IP "\fBFLOOD FILL\fP"
First select a point on the drawing area that is inside a closed polygon region.
When the FLOOD FILL icon is pressed, it will start at the selected point and
fill outward until it hits a border.
Note: FLOOD FILL will fill with the current DRAW COLOR value (on a mono sun).
When FLOOD FILL is used on a color sun it will fill with the currently selected
color and it will fill until it gets to a border made of the current color.
.IP "\fBPAINT\fP"
Once the PAINT command is selected, whenever the LEFT mouse button is pressed,
a region of the drawing area will be painted with the current pattern and
the size of this region will be determined by the current brush size.
Whenever the paint command is selected a brush menu will appear in the window
below the command subwindow. The current brush size can be set by placing the
cursor on top of a brush size within the brush menu and pressing the LEFT
mouse button.
.IP "\fBDRAW POINTS\fP"
Once this command is selected, whenever the LEFT mouse button is pressed within the
drawing area a single pixel of the current DRAW COLOR will be placed at
the location of the mouse cursor.
.IP "\fBLINE\fP"
Left button down marks the end point of a
line; moving with the button down
rubber bands a line; releasing button
draws the line.
.IP "\fBERASE\fP"
Pressing the LEFT button down will ERASE a small square region and
moving with the button down will 
continue ERASing until the LEFT button
is released. If a region is already selected when the ERASE icon is pressed
the specified region will be erased. If you double click the ERASE icon the
entire drawing area will be erased.
.IP "\fBRECTANGLE\fP"
Like \fBLINE\fP except draws a rectangle.
.IP "\fBRECTANGLE Filled\fP"
Like \fBLINE\fP except draws a rectangle that is filled with the currently
selected pattern, from the pattern menu.
.IP "\fBCIRCLE\fP"
Move the mouse cursor to the center of the circle that you with to draw
and hold down the LEFT mouse button, then while continuing to hold the LEFT
mouse button down extend the cursor to the radius of the circle that you want
and then release the LEFT mouse button.
.IP "\fBOVAL\fP"
Like \fBCIRCLE\fP except draws a oval.

.IP "\fBPOLYGON\fP"
Once this command is selected, move to the drawing area and press the LEFT mouse
button when the cursor is at the first vertex of the polygon that
you wish to draw.  Then continue to use the LEFT mouse button to select vertice
of the polygon.  When you have selected all of the vertice that you want, press
the RIGHT button to close the polygon.
.IP "\POLYGON FILLED\fP"
Like \fBPOLYGON\fP except it fills the polygon with the currently selected
pattern from the pattern subwindow.
.IP "4)" 5
The subwindow below the command subwindow, is the extra command subwindow.  There are two possible
windows that will appear within this subwindow, the first is the brush size menu
which is described in the PAINT command documentation.  The other menu that
will appear in this subwindow is the Cut/Paste buffer command menu.
This subwindow will only be visible when the SELECT REGION command is pressed.
This menu has the following commands.
.IP "\fBMIRROR\fP"
This command will create a mirror image of the currently
selected region.
.IP "\fBFLIP\fP"
This command will FLIP the currently selected region upside down.
.IP "\fBINVERSE\fP"
This command will INVERSE the currently selected region.
.IP "\fBROTATE\fP"
This command will ROTATE the currently selected region ninity degree
clockwise.
.IP "\fBCOPY\fP"
This command will place a copy of the currently selected region into the
Cut/Paste buffer.
.IP "\fBPASTE\fP"
First use the SELECT POINT command to select the upper right hand corner
of where you wish to place the Cut/Paste buffer.  Then press the PASTE
command icon and the contents of the current Cut/Paste buffer will be copied
to the drawing area.
.IP "\fBMOVE\fP"
First use either COPY, CUT, or Load:Cut/Paste buffer to put an image into
the current Cut/Paste buffer.  Once the MOVE command has been selected,
move the mouse to the drawing area and hold down the RIGHT mouse button.
As long as the RIGHT mouse button is held down, you can position the image
where you like.  Then let go of the RIGHT mouse button to place a copy of
the image on the drawing area.
.IP "\fBCUT\fP"
This command will place a copy of the currently selected region into the
Cut/Paste buffer and then it will fill the selected region with the
currently selected pattern.
.IP "5)" 5
The last subwindow is the drawing area, which is in the center of the main
window.
.RE
.SH "PRINTING FILES:"
.LP
Save a image out to a file and use the following Unix command to
dump the image to a full page picture on an Apple Laser Writer or any
other PostScript laser printer, where
file_name is the file name of an image created in Touchup.

.LP
When the picture is wider than it is high use the following command:

	 % pssun -s 8 10.5 -r file_name | lpr -Plw


.LP
When the picture is higher than it is wide use this command:

	 % pssun -s 8 10.5 file_name | lpr -Plw

.LP
When the picture is part of a document use this command:

     	 % pssun -S 6 -l 1.5 3 file_name | lpr -Plw
.LP
Images can also to sent to a IMPRESS laser printers with a command
similar to the following, where "/u5/sr/local/bin/imPf2" is the location
of the INPRINT program and "newcanon" is the name of the IMPRESS laser printer.

   % cat file_name | /u5/sr/local/bin/imPf2 | lpr -Pnewcanon


.SH "TYPICAL QUESTIONS:"
.IP "\fBHow do I select an area bigger than the drawing window ???\fP" 5

.LP
First go to SELECT REGION mode then select one of the corners of the region with the LEFT mouse
button.  Then scroll the drawing area subwindow so that the other corner of the
region you want is now visible.  Place the cursor on top of the
other corner of the region you want and press the the MIDDLE
mouse button.


.IP "\fBHow do I merge two different pictures in to one picture ???\fP" 5
.LP
When booting up Touchup the default drawing area is 1152 x 900,
which is the full screen size of the Sun graphics screen.  When
you load a new picture
the drawing area is restricted to the size of the picture that you loaded.
What you need to do is start up Touchup and load the first picture
into the Cut/Paste buffer by changing the cycle next to the load
button from "Load: Entire image" to "Load: Cut/Paste buffer" and then
press the load button.  The file will then be in the cut/paste
buffer and you can PASTE it or MOVE it to where ever you like.
Then load the second picture into the Cut/Paste buffer and PASTE that
picture where ever you like.


.IP "\fBHow do I make part of a picture into an icon ???\fP" 5

.LP
Use a program such as the "The Portable Bitmap Toolkit" by Jef
Poskanzer(jef@lbl-rtsg.arpa)
This can be ftped from zap.mit.edu, I also have a copy
rolled out on tape if you do not have access to zap.mit.edu.


.IP "\fBHow do I convert other image format to Sun rasterfile format ???\fP" 5
.IP "\fBHow do I convert Sun rasterfile format to other image formats ???\fP" 5

.LP
Use a program such as the "The Portable Bitmap Toolkit" by Jef
Poskanzer(jef@lbl-rtsg.arpa)
This can be ftped from zap.mit.edu, I also have a copy
rolled out on tape if you do not have access to zap.mit.edu.


.IP "\fBWhat does SAVE COMPRESSED mean ???\fP" 5

.LP
This means that the image will be saved out in the Sun rasterfile
BYTE_ENCODED format.  This will often compress the file to one half
of the normal size. One of the problems with saving a file in compressed
format is that 'screenload' command will then not be able to read the
file.


.SH FILES
\fI/usr/include/rasterfile.h\fP \- Sun raster file format
.SH SEE ALSO
.IR pssun (1),
.IR rastps (1),
.IR suntools (1),
.IR screendump (1),
.IR sceeenload (1)
.IR rasterfile (5)
.SH BUGS
.LP
Touchup has not been totally debugged for use with color images.
.LP
If you try to FLOOD FILL an area that has a VERY complex pattern and covers
a large area it is possible to over flow the stack and cause a core dump.
.SH Author
 Ray Kreisel
 Computer Science Department
 SUNY at Stony Brook
 Stony Brook NY 11794
.LP
 UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
 ARPA-Internet: rayk@sbcs.sunysb.edu
 CSnet: rayk@suny-sb
.LP
"If I get home before daylight, I just might get some sleep tonight...."
