
/**************************************************************************
   Touchup a bitmap graphics editor for the Sun Workstation running SunView
   Copyright (c) 1988 by Raymond Kreisel
   1/22/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

	   Ray Kreisel
	   CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

	   UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
	   ARPA-Internet: rayk@sbcs.sunysb.edu			
	   CSnet: rayk@suny-sb
	   (If nobody is home at any of the above addresses try:
		S72QKRE@TOWSONVX.BITNET			        )

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/
/**************************************************************************
	file: interface.c
	purpose: this file contains all of the window defs for touchup

	modifications:
		date:	Tue Mar 22 22:04:58 EST 1988
		author:	rayk
		changes:add comments
**************************************************************************/

#include"header.h"


Cursor fat_cursor;


static short icon_data[] = {
#include "touchup.icon"
};
static mpr_static(touchup_pr, 64, 64, 1, icon_data);

static short cursor_data[] = {
#include "fat_cursor"
};
static mpr_static(my_fat_cursor, 16, 16, 1, cursor_data);



    Frame base_frame,fat_frame,color_frame,command_frame;
    Canvas canvas,fat_canvas,color_canvas;
    Pixwin *pw,*fat_pw,*color_pw;
static Scrollbar	vertical_sb, horizontal_sb;
    Panel       panel,fat_panel,color_panel,pattern_panel,
		brush_panel,region_panel,command_panel;
    Panel_item magnify_cycle,grid_cycle,view_cycle;
    Panel_item  file_panel,brush_choice,mono_cycle,save_cycle,border_cycle,
		msg_string,color_button,text_panel,current_pattern,
		load_cycle,pattern_choice,command_choice,region_choice,
		compress_cycle,text_size_item,undo_button;

   struct pixrect *pattern[PATTERN_NO];
   struct pixrect *brushes[BRUSH_NO];
  

/*
 * Build all of the window that we need for touchup
 */
init_windows(argc,argv) int argc; char *argv[];
{

    base_frame = window_create(NULL,FRAME,
		FRAME_ARGS,	argc,argv,
		FRAME_LABEL,    "TouchUp version 2.2",
		FRAME_ICON,	    icon_create(ICON_IMAGE, &touchup_pr, 0),
		FRAME_INHERIT_COLORS,  TRUE,
		WIN_FONT,	main_font,
		WIN_WIDTH,	1030,
		WIN_HEIGHT,	675+ATTR_ROW(10),
		WIN_X,		10,
		WIN_Y,		10,
		0);
    panel = window_create(base_frame, PANEL,
	     PANEL_LABEL_BOLD,    	 TRUE,
	     WIN_FONT,		 	 main_font,
	     WIN_X,			 0,
	     WIN_Y,			 3,
	     WIN_HEIGHT,		 ATTR_ROW(5),
		0);



    vertical_sb = scrollbar_create((char*)0);
    horizontal_sb = scrollbar_create((char*)0);

    canvas = 
        window_create(base_frame, CANVAS, 
	    WIN_VERTICAL_SCROLLBAR,	vertical_sb,
	    WIN_HORIZONTAL_SCROLLBAR,	horizontal_sb,
	    WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS,WIN_MOUSE_BUTTONS,
					LOC_DRAG,
					LOC_MOVE, 
					0,
	    WIN_EVENT_PROC, 		handle_event,
	    WIN_WIDTH,			780,
/*	    WIN_HEIGHT,		 	650, */
	    WIN_X,			PATTERN_SIZE*2+70,
	    WIN_Y,			ATTR_ROW(7)+12,
	    CANVAS_AUTO_SHRINK,		FALSE,
	    CANVAS_AUTO_EXPAND,		FALSE,
	    CANVAS_FIXED_IMAGE,		FALSE,
	    CANVAS_RETAINED,		TRUE,
	    CANVAS_WIDTH,		image_wid,
	    CANVAS_HEIGHT,		image_hgt,
	    WIN_BELOW,			panel,
	    0),


    pw = canvas_pixwin(canvas);


    command_panel = window_create(base_frame, PANEL,
	     WIN_FONT,			main_font,
/*	     WIN_X,			 1000-(COMMAND_SIZE*2+32), */
	     WIN_Y,			 ATTR_ROW(6)+12,
	     WIN_WIDTH,			 COMMAND_SIZE*2+5,
	     WIN_HEIGHT,		 COMMAND_SIZE*COMMAND_NO/2+9,
	     WIN_RIGHT_OF,		 canvas,
	     WIN_BELOW,			 panel,
		0);

   command_choice = panel_create_item(command_panel, PANEL_CHOICE, 
	     PANEL_LABEL_BOLD,    	 TRUE,
	     PANEL_SHOW_MENU,		 FALSE,
	     PANEL_LAYOUT,		PANEL_VERTICAL,
	     PANEL_VALUE, 		6,
	     PANEL_LABEL_X,		10,
	     PANEL_LABEL_Y,		4,
	     PANEL_DISPLAY_LEVEL,	PANEL_ALL,
	     PANEL_FEEDBACK,		PANEL_INVERTED,
	     PANEL_CHOICE_IMAGES,	&command12_pr,&command5_pr,
					&command13_pr,&command14_pr,
					&command1_pr,&command6_pr,
					&command15_pr,&command3_pr,
					&command4_pr,&command16_pr,
					&command11_pr,&command10_pr,
					&command2_pr,&command7_pr,
					&command9_pr,&command8_pr,
					0,
	     PANEL_CHOICE_XS,		1,51,1,51,1,51,
					1,51,1,51,1,51,
					1,51,1,51,
					0,
	     
	     PANEL_CHOICE_YS,		1,1,
					50,50,
					99,99,
					148,148,
					197,197,
					246,246,
					295,295,
					344,344,
					0,
	     PANEL_NOTIFY_PROC, 	command_handle,
	     0);


    brush_panel = window_create(base_frame, PANEL,
	     WIN_FONT,			main_font,
	     WIN_SHOW,			TRUE,
	     WIN_X,			 1000-(COMMAND_SIZE*2+32),
	     WIN_Y,			 COMMAND_SIZE*COMMAND_NO/2+9+ATTR_ROW(6)+14,
	     WIN_WIDTH,			 COMMAND_SIZE*2+5,
/*	     WIN_HEIGHT,		 COMMAND_SIZE*4+15, */
	     WIN_BELOW,			 command_panel,
	     WIN_RIGHT_OF,		 canvas,
		0);

   brush_choice = panel_create_item(brush_panel, PANEL_CHOICE, 
	     PANEL_LABEL_BOLD,    	 TRUE,
	     PANEL_SHOW_MENU,		 FALSE,
	     PANEL_LAYOUT,		PANEL_VERTICAL,
	     PANEL_VALUE, 		3,
	     PANEL_LABEL_X,		10,
	     PANEL_LABEL_Y,		4,
	     PANEL_DISPLAY_LEVEL,	PANEL_ALL,
	     PANEL_FEEDBACK,		PANEL_MARKED,
	     PANEL_CHOICE_IMAGES,	&brush1_pr,&brush2_pr,
					&brush3_pr,&brush4_pr,
					&brush5_pr,&brush6_pr,
					0,
	     PANEL_CHOICE_XS,		51,51,51,51,51,51,
					0,
	     
	     PANEL_CHOICE_YS,		1,
					35,69,
					103,137,
					171,
					0,
	     PANEL_MARK_XS,		3,
					0,
	     
	     PANEL_MARK_YS,		1,
					35,69,
					103,137,
					171,
					0,
	     0);

  brushes[0] = &brush1_pr;
  brushes[1] = &brush2_pr;
  brushes[2] = &brush3_pr;
  brushes[3] = &brush4_pr;
  brushes[4] = &brush5_pr;
  brushes[5] = &brush6_pr;




    region_panel = window_create(base_frame, PANEL,
	     WIN_FONT,			main_font,
	     WIN_SHOW,			FALSE,
	     WIN_X,			 1000-(COMMAND_SIZE*2+32),
	     WIN_Y,			 COMMAND_SIZE*COMMAND_NO/2+9+ATTR_ROW(6)+14,
	     WIN_WIDTH,			 COMMAND_SIZE*2+5,
/*	     WIN_HEIGHT,		 COMMAND_SIZE*4+4, */
	     WIN_BELOW,			 command_panel,
	     WIN_RIGHT_OF,		 canvas,
		0);

   region_choice = panel_create_item(region_panel, PANEL_CHOICE, 
	     PANEL_LABEL_BOLD,    	 TRUE,
	     PANEL_SHOW_MENU,		 FALSE,
	     PANEL_LAYOUT,		PANEL_VERTICAL,
	     PANEL_VALUE, 		5,
	     PANEL_LABEL_X,		10,
	     PANEL_LABEL_Y,		4,
	     PANEL_DISPLAY_LEVEL,	PANEL_ALL,
	     PANEL_FEEDBACK,		PANEL_INVERTED,
	     PANEL_CHOICE_IMAGES,	&reg_command2_pr,&reg_command3_pr,
					&reg_command4_pr,&reg_command7_pr,
					&reg_command5_pr,&reg_command6_pr,
					&reg_command8_pr,&reg_command1_pr,
					0,
	     PANEL_CHOICE_XS,		1,51,1,51,1,51,1,51,
					0,
	     
	     PANEL_CHOICE_YS,		1,1,
					50,50,
					99,99,
					148,148,
					0,
	     PANEL_NOTIFY_PROC, 	region_handle,
	     0);


    pattern_panel = window_create(base_frame, PANEL,
	     WIN_FONT,			main_font,
	     WIN_X,			 0,
	     WIN_Y,			ATTR_ROW(6)+12,
 	     WIN_BELOW,			panel,
	     WIN_WIDTH,			 PATTERN_SIZE*2+65,
/*	     WIN_HEIGHT,		 PATTERN_SIZE*PATTERN_NO/2+22, */
		0);

   (void)panel_create_item(pattern_panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, PATTERN_SIZE*PATTERN_NO/2+40,
     PANEL_LABEL_IMAGE, panel_button_image(panel, "define pattern", 14, (Pixfont *)0),
     PANEL_NOTIFY_PROC, pattern_define,
     0);

   pattern_choice = panel_create_item(pattern_panel, PANEL_CHOICE, 
	     PANEL_LABEL_BOLD,    	 TRUE,
	     PANEL_SHOW_MENU,		 FALSE,
	     PANEL_LAYOUT,		PANEL_VERTICAL,
	     PANEL_LABEL_X,		10,
	     PANEL_LABEL_Y,		4,
	     PANEL_VALUE, 		0,
	     PANEL_DISPLAY_LEVEL,	PANEL_ALL,
	     PANEL_FEEDBACK,		PANEL_MARKED,
	     PANEL_NOTIFY_PROC, 	select_pattern,
	     PANEL_CHOICE_IMAGES,	&pattern1_pr,&pattern2_pr,&pattern3_pr,
					&pattern4_pr,&pattern5_pr,
					&pattern6_pr,&pattern7_pr,
					&pattern8_pr,&pattern9_pr,
					&pattern10_pr,
	     				&pattern11_pr,&pattern12_pr,&pattern13_pr,
					&pattern14_pr,&pattern15_pr,
					&pattern16_pr,&pattern17_pr,
					&pattern18_pr,&pattern19_pr,
					&pattern20_pr,
	     				&pattern21_pr,&pattern22_pr,&pattern23_pr,
					&pattern24_pr,&pattern25_pr,
					&pattern26_pr,&pattern27_pr,
					&pattern28_pr,&pattern29_pr,
					&pattern30_pr,
	     				&pattern31_pr,&pattern32_pr,&pattern33_pr,
					&pattern34_pr,&pattern35_pr,
					&pattern36_pr,&pattern37_pr,
					&pattern38_pr,&pattern39_pr,
					&pattern40_pr,0,
	     PANEL_CHOICE_XS,		25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,0,
	     
	     PANEL_CHOICE_YS,		1+35,33+35,65+35,97+35,129+35,161+35,193+35,225+35,257+35,289+35,
					321+35,353+35,385+35,417+35,449+35,481+35,513+35,545+35,577+35,609+35,
	     				1+35,33+35,65+35,97+35,129+35,161+35,193+35,225+35,257+35,289+35,
					321+35,353+35,385+35,417+35,449+35,481+35,513+35,545+35,577+35,609+35,0,
	     PANEL_MARK_XS,		3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,0,
	     PANEL_MARK_YS,		8+35,40+35,72+35,104+35,136+35,168+35,200+35,232+35,266+35,296+35,
					328+35,360+35,392+35,426+35,456+35,488+35,520+35,552+35,584+35,616+35,
	     				8+35,40+35,72+35,104+35,136+35,168+35,200+35,232+35,266+35,296+35,
					328+35,360+35,392+35,426+35,456+35,488+35,520+35,552+35,584+35,616+35,0,

     0);

  pattern[0] = &pattern1_pr;
  pattern[1] = &pattern2_pr;
  pattern[2] = &pattern3_pr;
  pattern[3] = &pattern4_pr;
  pattern[4] = &pattern5_pr;
  pattern[5] = &pattern6_pr;
  pattern[6] = &pattern7_pr;
  pattern[7] = &pattern8_pr;
  pattern[8] = &pattern9_pr;
  pattern[9] = &pattern10_pr;
  pattern[10] = &pattern11_pr;
  pattern[11] = &pattern12_pr;
  pattern[12] = &pattern13_pr;
  pattern[13] = &pattern14_pr;
  pattern[14] = &pattern15_pr;
  pattern[15] = &pattern16_pr;
  pattern[16] = &pattern17_pr;
  pattern[17] = &pattern18_pr;
  pattern[18] = &pattern19_pr;
  pattern[19] = &pattern20_pr;
  pattern[20] = &pattern21_pr;
  pattern[21] = &pattern22_pr;
  pattern[22] = &pattern23_pr;
  pattern[23] = &pattern24_pr;
  pattern[24] = &pattern25_pr;
  pattern[25] = &pattern26_pr;
  pattern[26] = &pattern27_pr;
  pattern[27] = &pattern28_pr;
  pattern[28] = &pattern29_pr;
  pattern[29] = &pattern30_pr;
  pattern[30] = &pattern31_pr;
  pattern[31] = &pattern32_pr;
  pattern[32] = &pattern33_pr;
  pattern[33] = &pattern34_pr;
  pattern[34] = &pattern35_pr;
  pattern[35] = &pattern36_pr;
  pattern[36] = &pattern37_pr;
  pattern[37] = &pattern38_pr;
  pattern[38] = &pattern39_pr;
  pattern[39] = &pattern40_pr;

   current_pattern = panel_create_item(pattern_panel, PANEL_MESSAGE, 
     PANEL_ITEM_X, ATTR_COL(6),
     PANEL_ITEM_Y, 3,
     PANEL_LABEL_IMAGE, &pattern1_pr,
     0);

    color_frame = window_create(base_frame,FRAME,
		FRAME_LABEL,    "Color Pallet",
	        FRAME_SHOW_LABEL, TRUE,
		WIN_FONT,	main_font,
		WIN_WIDTH,	PALET_BLOCK*16+9,
		WIN_HEIGHT,	PALET_BLOCK*(16+3)+20+ATTR_ROW(2),
		WIN_X,		650,
		WIN_Y,		10,
		0);

    color_canvas = 
        window_create(color_frame, CANVAS, 
	    WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS, WIN_MOUSE_BUTTONS,
					LOC_DRAG,
					LOC_MOVE, 
					0,
	    WIN_EVENT_PROC, 		color_handle_event,
		WIN_X,		0,
		WIN_Y,		ATTR_ROW(2)+5,
	    CANVAS_WIDTH,		PALET_BLOCK*16,
	    CANVAS_HEIGHT,		PALET_BLOCK*(16+3),
	    CANVAS_AUTO_SHRINK,		FALSE,
	    CANVAS_FIXED_IMAGE,		FALSE,
	    CANVAS_AUTO_EXPAND,		TRUE,
	    CANVAS_REPAINT_PROC,	draw_colormap,
	    CANVAS_RESIZE_PROC,		draw_colormap,
	    0),

    color_pw = canvas_pixwin(color_canvas);

    color_panel = window_create(color_frame, PANEL,
	     PANEL_LABEL_BOLD,    	 TRUE,
		WIN_FONT,	main_font,
	     WIN_X,			 0,
	     WIN_Y,			 3,
	     WIN_WIDTH,			 PALET_BLOCK*16+1,
	     WIN_HEIGHT,		 ATTR_ROW(1)+4,
		0);


   (void)panel_create_item(color_panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_LABEL_IMAGE, panel_button_image(color_panel, "done", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, color_done,
     0);



   
    fat_frame = window_create(base_frame,FRAME,
		FRAME_LABEL,    "Big bits",
	        FRAME_SHOW_LABEL, TRUE,
		WIN_CURSOR,	cursor_create(CURSOR_IMAGE, &my_fat_cursor,0),
		WIN_FONT,	main_font,
		WIN_WIDTH,	ATTR_COL(31),
		WIN_HEIGHT,	ATTR_ROW(24),
	     WIN_X,			 0,
	     WIN_Y,			ATTR_ROW(8)+12,
		0);

    fat_canvas = 
        window_create(fat_frame, CANVAS, 
	    WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS,WIN_MOUSE_BUTTONS,
					LOC_DRAG,
					LOC_MOVE, 
					0,
	    WIN_CURSOR,			cursor_create(CURSOR_IMAGE, &my_fat_cursor,0),
	    WIN_EVENT_PROC, 		fat_handle_event,
		WIN_X,		0,
		WIN_Y,		ATTR_ROW(2)+5,
	    CANVAS_WIDTH,		ATTR_COL(30),
	    CANVAS_HEIGHT,		ATTR_ROW(14),
	    CANVAS_AUTO_SHRINK,		TRUE,
	    CANVAS_FIXED_IMAGE,		FALSE,
	    CANVAS_AUTO_EXPAND,		TRUE,
	    CANVAS_RETAINED,		TRUE,
	    0),

    fat_pw = canvas_pixwin(fat_canvas);

    fat_panel = window_create(fat_frame, PANEL,
	     PANEL_LABEL_BOLD,    	 TRUE,
		WIN_FONT,	main_font,
	     WIN_X,			 0,
	     WIN_Y,			 3,
	     WIN_WIDTH,			 ATTR_COL(30),
	     WIN_HEIGHT,		 ATTR_ROW(1)+4,
		0);
   
    magnify_cycle = 
	panel_create_item(fat_panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(8),
	    PANEL_ITEM_Y, ATTR_ROW(0),
	    PANEL_LABEL_STRING, "Magnification:",
	    PANEL_CHOICE_STRINGS, "1x", "2x","3x","4x",
				  "5x","6x","7x","8x","9x",
				  "10x","11x","12x","13x","14x",
				  "15x","16x","17x","18x","19x",
				  "20x", 0,
	    PANEL_VALUE, 8,
	    PANEL_NOTIFY_PROC, fat_parms,
	    0);

   (void)panel_create_item(fat_panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_LABEL_IMAGE, panel_button_image(fat_panel, "done", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, fat_done,
     0);


   (void)panel_create_item(panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(8),
     PANEL_ITEM_Y, ATTR_ROW(1),
     PANEL_LABEL_IMAGE, panel_button_image(panel, "view", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, viewer,
     0);

    view_cycle =
	panel_create_item(panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(16),
	    PANEL_ITEM_Y, ATTR_ROW(1),
	    PANEL_LABEL_STRING, "View:",
	    PANEL_CHOICE_STRINGS, "Touchup info", "man page (help)", "Cut/Paste buffer", 0,
	    PANEL_VALUE, 1,
	    0);

   (void)panel_create_item(panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(8),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_LABEL_IMAGE, panel_button_image(panel, "load", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, load_file,
     0);
    load_cycle =
	panel_create_item(panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(16),
	    PANEL_ITEM_Y, ATTR_ROW(0),
	    PANEL_LABEL_STRING, "Load:",
	    PANEL_CHOICE_STRINGS, "entire image", "Cut/Paste buffer", 0,
	    PANEL_VALUE, LOAD_ALL,
	    0);

   (void)panel_create_item(panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(45),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_LABEL_IMAGE, panel_button_image(panel, "save", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, save_file,
     0);

    save_cycle =
	panel_create_item(panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(53),
	    PANEL_ITEM_Y, ATTR_ROW(0),
	    PANEL_LABEL_STRING, "Save:",
	    PANEL_CHOICE_STRINGS, "entire image", "Cut/Paste buffer", 0,
	    PANEL_VALUE, SAVE_ALL,
	    0);

    compress_cycle =
	panel_create_item(panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(53),
	    PANEL_ITEM_Y, ATTR_ROW(1),
	    PANEL_LABEL_STRING, "Save:",
	    PANEL_CHOICE_STRINGS, "Standard format","Compressed",0,
	    PANEL_VALUE, 0,
	    0);

   (void)panel_create_item(panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_LABEL_IMAGE, panel_button_image(panel, "quit", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, quit,
     0);

   undo_button = panel_create_item(panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, ATTR_ROW(2),
     PANEL_LABEL_IMAGE, panel_button_image(panel, "undo", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, undo_screen,
     0);

    grid_cycle =
	panel_create_item(panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(8),
	    PANEL_ITEM_Y, ATTR_ROW(2),
	    PANEL_LABEL_STRING, "Grid size:",
	    PANEL_CHOICE_STRINGS, "none","5","10","15","20","25","30",0,
	    PANEL_VALUE, grid_size,
	    PANEL_NOTIFY_PROC, change_parms,
	    0);

    border_cycle =
	panel_create_item(panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(30),
	    PANEL_ITEM_Y, ATTR_ROW(2),
	    PANEL_LABEL_STRING, "Borders:",
	    PANEL_CHOICE_STRINGS, "No","Yes",0,
	    PANEL_VALUE, 1,
	    0);

   file_panel=panel_create_item(panel, PANEL_TEXT, 
     PANEL_ITEM_X, ATTR_COL(80),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_VALUE, file_name,
     PANEL_VALUE_DISPLAY_LENGTH, 35,
     PANEL_LABEL_STRING, "Filename:",
     PANEL_NOTIFY_PROC, make_new_name,
     PANEL_NOTIFY_STRING, "\033",
     PANEL_VALUE_STORED_LENGTH, MAX_FILE_NAME,
     PANEL_SHOW_MENU, FALSE,
     0);

   text_panel=panel_create_item(panel, PANEL_TEXT, 
     PANEL_ITEM_X, ATTR_COL(80),
     PANEL_ITEM_Y, ATTR_ROW(1),
     PANEL_VALUE, "",
     PANEL_VALUE_DISPLAY_LENGTH, 32,
     PANEL_LABEL_STRING, "Text string:",
     PANEL_VALUE_STORED_LENGTH, MAX_FILE_NAME,
     PANEL_SHOW_MENU, FALSE,
     0);


        text_size_item = panel_create_item(panel,PANEL_CYCLE,
                                          PANEL_ITEM_X, ATTR_COL(80),
                                          PANEL_ITEM_Y, ATTR_ROW(2),
					  PANEL_LABEL_STRING, "Fonts:",
                                          PANEL_CHOICE_STRINGS, "ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
								"ABC abc 123",
                                                                0,
                                          PANEL_CHOICE_FONTS, 
                                         		      cour_r_10,
                                                              cour_r_12,
                                                              cour_r_16,
                                                              cour_r_24,
							      cour_b_10,
                                                              cour_b_12,
                                                              cour_b_16,
                                                              cour_b_24,
                                                              serif_r_10,
                                                              serif_r_11,
                                                              serif_r_16,
							      screen_r_7,
							      screen_r_11,
							      screen_r_12,
							      screen_r_14,
							      screen_b_12,
							      screen_b_14,
							      pcfont_b_14,
							      pcfont_r_14,
                                                              0,
                                          0);


    mono_cycle =
	panel_create_item(panel, PANEL_CYCLE,
	    PANEL_ITEM_X, ATTR_COL(48),
	    PANEL_ITEM_Y, ATTR_ROW(2),
	    PANEL_LABEL_STRING, "Draw color",
	    PANEL_CHOICE_STRINGS, "WHITE", "BLACK",
				   0,
	    PANEL_VALUE, 1,
	    PANEL_NOTIFY_PROC, change_parms,
	    0);

   color_button = panel_create_item(panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(52),
     PANEL_ITEM_Y, ATTR_ROW(2),
     PANEL_SHOW_ITEM, FALSE,
     PANEL_LABEL_IMAGE, panel_button_image(panel, "color", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, color_mode,
     0);

   msg_string = panel_create_item(panel, PANEL_MESSAGE, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, ATTR_ROW(4),
     PANEL_LABEL_BOLD,    TRUE,
     PANEL_LABEL_STRING, "",
     0);

  fat_cursor = window_get(canvas,WIN_CURSOR);
  cursor_set(fat_cursor,CURSOR_OP,PIX_SRC^PIX_DST,0);
  window_set(canvas,WIN_CURSOR,fat_cursor,0);

  fat_cursor = window_get(fat_canvas,WIN_CURSOR);
  cursor_set(fat_cursor,CURSOR_OP,PIX_SRC^PIX_DST,0);
  window_set(fat_canvas,WIN_CURSOR,fat_cursor,0);

}

