
/**************************************************************************
   Touchup a bitmap graphics editor for the Sun Workstation running SunView
   Copyright (c) 1988 by Raymond Kreisel
   1/22/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

	   Ray Kreisel
	   CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

	   UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
	   ARPA-Internet: rayk@sbcs.sunysb.edu			
	   CSnet: rayk@suny-sb
	   (If nobody is home at any of the above addresses try:
		S72QKRE@TOWSONVX.BITNET			        )

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/
/**************************************************************************
	file: info.c
	purpose: this file has the functions that had the "view" pop up
		window.  You can view the "man page", copyright notice
		with the picture of the author (me), and the cut/paste
   		buffer

	modifications:
		date:	Tue Mar 22 22:04:58 EST 1988
		author:	rayk
		changes:add comments
**************************************************************************/

#include "header.h"

#include <suntool/textsw.h>

Frame view_frame;
Canvas view_canvas;
Pixwin *view_pw;
Panel view_panel;
int view_flag=FALSE;


/*
 * this function will read in the copyright notice
 * with my picture on it and display it in a new window
 */
info_init()
{
FILE *fp,*fopen();
int color_map=NULL;
struct pixrect *temp_pr;

   fp = fopen(INFO_IMAGE,"r");
   if (!fp)
   {
      ERROR("I Could not find the information file !!!!");
      view_flag = FALSE;
      fclose(fp);
      return(0);
   }
   temp_pr = (struct pixrect *)pr_load(fp,color_map);
   if (!temp_pr)
   {
      ERROR("I Could not find the information file !!!!");
      view_flag = FALSE;
      fclose(fp);
      return(0);
   }
   view_init(temp_pr,"Information on Touchup");
   MY_pr_destroy(temp_pr);
   fclose(fp);
}


/*
 * this function will let you view the cut/paste buffer
 * in a seperate window
 */
view_cut_paste()
{
   if (cut_buffer_pr)
   {
     view_init(cut_buffer_pr,"The current Cut/Paste Buffer");
   }
   else
   {
     ERROR("The CUT/PASTE buffer is empty.");
   }
}


/*
 * we got a button click on "view"
 * check out what we need to view
 */
#define VIEW_INFO 0
#define VIEW_HELP 1
#define VIEW_CUT_PASTE 2
viewer()
{
   switch((int)panel_get_value(view_cycle)) {
	case VIEW_INFO: info_init();
	  	   break;
	case VIEW_CUT_PASTE: view_cut_paste();
	  		break;
	case VIEW_HELP: view_help();
   }
}


/*
 * close up the view window
 */
view_done()
{
   if (view_flag)
   {
     window_set(view_frame, FRAME_NO_CONFIRM, TRUE, 0);
     window_destroy(view_frame);
     view_flag = FALSE;  
   }
}


/*
 * this function will take a pixrect and create a new window
 * which we can view it in
 */
view_init(view_pr,frame_label)
struct pixrect *view_pr;
char *frame_label;
{
Rect *r;

   if (view_flag)
   {
      view_done();
   }
   view_flag = TRUE;

    r = (Rect *) window_get(base_frame, WIN_RECT);
    view_frame = window_create(base_frame,FRAME,
		FRAME_LABEL,    frame_label,
	        FRAME_SHOW_LABEL, TRUE,
		WIN_SHOW,	TRUE,
		WIN_FONT,	main_font,
		WIN_WIDTH,	view_pr->pr_size.x+20,
		WIN_HEIGHT,	view_pr->pr_size.y+60,
	        WIN_X,		(r->r_width - view_pr->pr_size.x+20)/2,
	        WIN_Y,		(r->r_height - view_pr->pr_size.y+50)/4,
		0);

    view_canvas = 
        window_create(view_frame, CANVAS, 
	    WIN_CONSUME_PICK_EVENTS,	WIN_NO_EVENTS,WIN_MOUSE_BUTTONS,
					LOC_DRAG, LOC_WINENTER,
					LOC_MOVE, 
					0,
		WIN_X,		0,
		WIN_Y,		ATTR_ROW(2)+5,
	    CANVAS_WIDTH,		view_pr->pr_size.x+5,
	    CANVAS_HEIGHT,		view_pr->pr_size.y+5,
	    CANVAS_AUTO_SHRINK,		TRUE,
	    CANVAS_FIXED_IMAGE,		FALSE,
	    CANVAS_AUTO_EXPAND,		TRUE,
	    CANVAS_RETAINED,		TRUE,
	    0),

    view_pw = canvas_pixwin(view_canvas);

    if (view_pr->pr_depth > 1)
    {
	pw_setcmsname(view_pw, "ray kreisel");
	pw_putcolormap(view_pw, 0,256,temp_red,temp_green,temp_blue);
    }

    view_panel = window_create(view_frame, PANEL,
	     PANEL_LABEL_BOLD,    	 TRUE,
		WIN_FONT,	main_font,
	     WIN_X,			 0,
	     WIN_Y,			 3,
	     WIN_HEIGHT,		 ATTR_ROW(1)+4,
		0);
   
   (void)panel_create_item(view_panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_LABEL_IMAGE, panel_button_image(view_panel, "done", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, view_done,
     0);

  /* write the image files to the canvas */

   pw_write(view_pw,0,0,view_pr->pr_size.x,
		 view_pr->pr_size.y,PIX_SRC, view_pr,0,0);
}   


/*
 * this function is used to view the man page
 */
#define VIEW_HELP_FLAG 2
view_help()
{
Rect *r;

   if (!file_exist(HELP_FILE))
   {
      ERROR("I cannot find the man page for touchup !!!");
      return(0);
   }

   if (view_flag == VIEW_HELP_FLAG)
   {
      (void)window_set(view_frame, WIN_SHOW, TRUE, 0);
      return(0);
   }
   else
   {
      if (view_flag)
 	 view_done();
   }
   view_flag = VIEW_HELP_FLAG;

    r = (Rect *) window_get(base_frame, WIN_RECT);
    view_frame = window_create(base_frame,FRAME,
		FRAME_LABEL,    "Help window",
	        FRAME_SHOW_LABEL, TRUE,
		WIN_SHOW,	TRUE,
		WIN_FONT,	main_font,
	        WIN_X,		(r->r_width - 600+20)/2,
	        WIN_Y,		(r->r_height - 512+50)/4,
		0);

    view_panel = window_create(view_frame, PANEL,
	     PANEL_LABEL_BOLD,    	 TRUE,
		WIN_FONT,	main_font,
	     WIN_X,			 0,
	     WIN_Y,			 3,
	     WIN_HEIGHT,		 ATTR_ROW(1)+4,
		0);
   
   (void)panel_create_item(view_panel, PANEL_BUTTON, 
     PANEL_ITEM_X, ATTR_COL(0),
     PANEL_ITEM_Y, ATTR_ROW(0),
     PANEL_LABEL_IMAGE, panel_button_image(view_panel, "done", 5, (Pixfont *)0),
     PANEL_NOTIFY_PROC, view_done,
     0);


    (void)window_create(view_frame, TEXTSW,
		WIN_ERROR_MSG, 		"I cannot find the man page for touchup",
                WIN_X,                  0,
		WIN_Y,			ATTR_ROW(2)+5,
                WIN_HEIGHT,             512,
                WIN_WIDTH,              600,
		TEXTSW_FONT,		main_font,
                TEXTSW_IGNORE_LIMIT,    TEXTSW_INFINITY,
                TEXTSW_AUTO_INDENT,     TRUE,
                TEXTSW_BROWSING,        TRUE,
                TEXTSW_DISABLE_LOAD,    TRUE,
                TEXTSW_DISABLE_CD,      TRUE,
        	TEXTSW_FILE,    	HELP_FILE,
                0);

  window_fit(view_frame);
}   


