
/**************************************************************************
   Touchup a bitmap graphics editor for the Sun Workstation running SunView
   Copyright (c) 1988 by Raymond Kreisel
   1/22/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

	   Ray Kreisel
	   CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

	   UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
	   ARPA-Internet: rayk@sbcs.sunysb.edu			
	   CSnet: rayk@suny-sb

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/
/**************************************************************************
	file: confirmer.c
	purpose: This file contains a simple confirmer copied from the
	 Sunview manual that has been souped up a little

	modifications:
		date:	Tue Mar 22 22:04:58 EST 1988
		author:	rayk
		changes:add comments
**************************************************************************/

#include <stdio.h>
#include <sys/file.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/walkmenu.h>
#include <suntool/scrollbar.h>
#include <math.h>
#include <pixrect/pixrect_hs.h>

extern Panel panel;

static Frame  init_confirmer();
static void yes_no();

/***************************************************************
        confirm
        purpose: To display a window on the base_frame Sunwindow
                force the user to answer the question by selecting
		either YES or NO
        parameter:
                message: The question to asked.
        returns:
		1 : if the user answered YES
		0 : if the user answered NO
 ***************************************************************/
int confirm(message)
char     *message; 
{
	Frame     confirmer;
	int       answer;

/* create the confirmer */
	confirmer = init_confirmer(message);
	window_bell(panel);
/* make the user answer */
 	answer = (int) window_loop(confirmer);

/* destroy the confirmer */
	window_set(confirmer, FRAME_NO_CONFIRM, TRUE, 0);
	window_destroy(confirmer);

    	return answer;
}

static Frame
init_confirmer(message)
char     *message; 
{ 
extern   Frame  base_frame;
Frame           confirmer;
Panel           panel;
Panel_item      message_item;
int 	        left, top, width, height;
Rect	        *r;
struct pixrect  *pr;

/* create the confirmer base frame */
	confirmer = window_create(base_frame, FRAME, 
                                  FRAME_SHOW_LABEL, FALSE,
				  0);

/* create the single panel subwindow */
	panel = window_create(confirmer, PANEL, 0);

/* put in the message */
	message_item = panel_create_item(panel, PANEL_MESSAGE,
					PANEL_LABEL_STRING, message,
					0);

	pr = panel_button_image(panel, "NO", 3, 0);
	width = 2 * pr->pr_width + 10;

  	r = (Rect *) panel_get(message_item, PANEL_ITEM_RECT);

/* center the yes/no buttons under the message */
	left = (r->r_width - width) / 2;
	if (left < 0)
	    left = 0;
	top = rect_bottom(r) + 5;

        panel_create_item(panel, PANEL_BUTTON,
                  PANEL_ITEM_X, left,
	          PANEL_ITEM_Y, top,
	          PANEL_LABEL_IMAGE, pr,
	          PANEL_CLIENT_DATA, FALSE,
		  PANEL_NOTIFY_PROC, yes_no,
		  0);
 
        panel_create_item(panel, PANEL_BUTTON,
	          PANEL_LABEL_IMAGE, panel_button_image(panel, "YES", 3, 0),
	          PANEL_CLIENT_DATA, TRUE,
		  PANEL_NOTIFY_PROC, yes_no,
		  0);
 

	window_fit(panel);
	window_fit(confirmer);

/* center the confirmer frame in the base frame */
	r = (Rect *) window_get(base_frame, WIN_RECT);

	width = (int) window_get(confirmer, WIN_WIDTH);
	height = (int) window_get(confirmer, WIN_HEIGHT);

	left = (r->r_width - width) / 2;
	top = (r->r_height - height) / 3;

        if (left < 0) 
            left = 0; 
 	if (top < 0)
	    top = 0;

	window_set(confirmer, WIN_X, left, WIN_Y, top,
			0);

        left = left + (width - width/3);
        top = top + height / 2;      
	window_set(base_frame, WIN_MOUSE_XY, left, top,  0);

	return confirmer;
}

/* yes/no notify proc */
static void
yes_no(item, event)
Panel_item   item;
Event        *event;
{
	window_return(panel_get(item, PANEL_CLIENT_DATA));
}

