
/**************************************************************************
   Touchup a bitmap graphics editor for the Sun Workstation running SunView
   Copyright (c) 1988 by Raymond Kreisel
   1/22/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

	   Ray Kreisel
	   CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

	   UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
	   ARPA-Internet: rayk@sbcs.sunysb.edu			
	   CSnet: rayk@suny-sb
	   (If nobody is home at any of the above addresses try:
		S72QKRE@TOWSONVX.BITNET			        )

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/
/**************************************************************************
	file: ffill.c
	purpose: this file has the functions that do flood fill

	modifications:
		date:	Tue Mar 22 22:04:58 EST 1988
		author:	rayk
		changes:add comments
**************************************************************************/

#include "header.h"


/*
 * let's go into flood fill mode because we got a button click on flood fill
 */
fill_mode(item, event)
Panel_item      item;
Event           *event;
{
int x,y;


  if (select_pt_x != -1)
      {
         print_msg("Hold down the RIGHT mouse button to cancel flood fill.");
  	 x = select_pt_x;
         y = select_pt_y;
	 clean_point();
	 save_screen();
	 pw_put(pw,x,y,cur_color^1);
	 if (ffill(x,y,cur_color))
		ERROR("Flood fill cancelled !!");
	 else
	    hide_msg();
      }
  else
      {
	ERROR("Select point first, then select flood fill");
	set_select_mode();
      }
}


#define FILL_CANCEL 1

/*
 * this is a simple recursive flood fill that will work
 * on mono bitmaps
 * call it will the start x,y coordinates and the color
 * to fill with, which is also the bounary color
 */
ffill(x,y,n)
int x,y,n;
{
int flag;
register i,j,k,bx;

        if (window_get(canvas, WIN_EVENT_STATE, MS_RIGHT))
            return(FILL_CANCEL);

	if (x<0 || x>=image_wid || y<0 || y>=image_hgt || pw_get(pw,x,y)==n)
		return(0);
	pw_put(pw,x,y,n);
        bx = x-1;
	for (i=x-1;i>=0;i--) {
		if (pw_get(pw,i,y)!=n)
			bx = i;
		else 
		    {
			pw_vector(pw,bx,y,x,y, PIX_SRC,n);
			break;
		    }
		}
        bx = x+1;
	for (j=x+1;j<image_wid;j++)
		if (pw_get(pw,j,y)!=n)
			bx = j;
		else 
		     {
			pw_vector(pw,bx,y,x,y, PIX_SRC,n);
			break;
		     }

        flag = 0;
	for (k=i+1;k<j;k++)
	{
		if (y>0 && pw_get(pw,k,y-1)!=n)
			flag = ffill(k,y-1,n);
		if (y<image_hgt-1 && pw_get(pw,k,y+1)!=n)
			flag = ffill(k,y+1,n);
                if (flag) break;
	}
return(flag);
}

