
/**************************************************************************
   Touchup a bitmap graphics editor for the Sun Workstation running SunView
   Copyright (c) 1988 by Raymond Kreisel
   1/22/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

	   Ray Kreisel
	   CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

	   UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
	   ARPA-Internet: rayk@sbcs.sunysb.edu			
	   CSnet: rayk@suny-sb
	   (If nobody is home at any of the above addresses try:
		S72QKRE@TOWSONVX.BITNET			        )

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/
/**************************************************************************
	file:color_palet.c
	purpose: This file contains that functions that handle the color
		map for usage with color suns

	modifications:
		date:	Tue Mar 22 22:04:58 EST 1988
		author:	rayk
		changes:add comments
**************************************************************************/

#include "header.h"
#include <sunwindow/cms_mono.h>

/*
 * Lets go into color mode, scotty
 *
 */
set_color()
{
  panel_set(mono_cycle,PANEL_SHOW_ITEM, FALSE,0);
  panel_set(color_button,PANEL_SHOW_ITEM, TRUE,0);
}


/*
 * Back to mono mode
 *
 */
set_mono()
{
/* set the color map to mono ******** */
  cms_monochromeload(red,green,blue);
  my_put_colormap();
  panel_set(color_button,PANEL_SHOW_ITEM, FALSE,0);
  panel_set(mono_cycle,PANEL_SHOW_ITEM, TRUE,0);
}

/*
 * Set the colormap for all of the windows
 */
unsigned char temp_red[256],temp_green[256],temp_blue[256];

my_put_colormap()
{
Pixwin *temp_pw;

  pw_setcmsname(pw, "ray kreisel");
  pw_putcolormap(pw, 0,256,red,green,blue);
  pw_setcmsname(fat_pw, "ray kreisel");
  pw_putcolormap(fat_pw, 0,256,red,green,blue);
  pw_setcmsname(color_pw, "ray kreisel");
  pw_putcolormap(color_pw, 0,256,red,green,blue);

  bcopy(red,temp_red,256);
  bcopy(green,temp_green,256);
  bcopy(blue,temp_blue,256);
  temp_red[0] = -1;
  temp_green[0] = -1;
  temp_blue[0] = -1;
  temp_red[1] = 0;
  temp_green[1] = 0;
  temp_blue[1] = 0;

  temp_pw = (Pixwin *)window_get(panel, WIN_PIXWIN);
  pw_setcmsname(temp_pw, "ray kreisel");
  pw_putcolormap(temp_pw, 0,256,red,green,blue);

  temp_pw = (Pixwin *)window_get(command_panel, WIN_PIXWIN);
  pw_setcmsname(temp_pw, "ray kreisel");
  pw_putcolormap(temp_pw, 0,256,red,green,blue);

  temp_pw = (Pixwin *)window_get(region_panel, WIN_PIXWIN);
  pw_setcmsname(temp_pw, "ray kreisel");
  pw_putcolormap(temp_pw, 0,256,red,green,blue);

  temp_pw = (Pixwin *)window_get(pattern_panel, WIN_PIXWIN);
  pw_setcmsname(temp_pw, "ray kreisel");
  pw_putcolormap(temp_pw, 0,256,red,green,blue);

  temp_pw = (Pixwin *)window_get(brush_panel, WIN_PIXWIN);
  pw_setcmsname(temp_pw, "ray kreisel");
  pw_putcolormap(temp_pw, 0,256,red,green,blue);

}

color_mode(item, event)
Panel_item      item;
Event           *event;
{
    (void)window_set(color_frame, WIN_SHOW, TRUE, 0);
    draw_colormap();
}


/*
 * Draw the colormap up on a canvas in the color palet window
 */
draw_colormap()
{
int i;
  for (i=0;i<256;i++)
    pw_write(color_pw,(i%16)*PALET_BLOCK,i/16*PALET_BLOCK,PALET_BLOCK,PALET_BLOCK,PIX_COLOR(i) | PIX_SRC,NILPR,0,0);
  update_cur_color(0,0,cur_color);
}



/*
 * Get rid of the color palet
 */
color_done(item, event)
Panel_item      item;
Event           *event;
{
    (void)window_set(color_frame, WIN_SHOW, FALSE, 0);
}


/*
 * Make an event handle for the mouse envent of the color palet
 * Let the use pick a block on the color palet and set the current
 * color a cordingly
 */
color_handle_event(canvas_local, event, arg)
Canvas  canvas_local;
Event   *event;
caddr_t arg;
{
    if (event_is_up(event))
       return;
    switch (event_id(event)) {
	 case MS_LEFT:
		update_cur_color(event_x(event),event_y(event),0);
		break;
	}
}


/*
 * Redraw the currrent color at the bottom of the color palet
 */
update_cur_color(x,y,value)
{
  if (value)
   {
    cur_color= value;
   }
  else
   {
     if ((x >= PALET_BLOCK*16) || (y >= PALET_BLOCK*16))
	   return(0);
     cur_color = x/PALET_BLOCK + y/PALET_BLOCK*16;
   }
  pw_write(color_pw,0,PALET_BLOCK*16+8,PALET_BLOCK*16,PALET_BLOCK*2,PIX_COLOR(cur_color) | PIX_SRC,NILPR,0,0);
}

