
/**************************************************************************
   Touchup a bitmap graphics editor for the Sun Workstation running SunView
   Copyright (c) 1988 by Raymond Kreisel
   1/22/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

	   Ray Kreisel
	   CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

	   UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
	   ARPA-Internet: rayk@sbcs.sunysb.edu			
	   CSnet: rayk@suny-sb
	   (If nobody is home at any of the above addresses try:
		S72QKRE@TOWSONVX.BITNET			        )

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/

/**************************************************************************
	file: circle.c
	purpose: This file contains that routines that draw circles
		on the screen. A UNDOCUMENTED Sunview function "pw_polypoint"
		is used to get the list of points that make the circle
		on to the screen AMAZINGLY FAST.
		The points that make up the circle are calculated with
		bresenhams (sp?) incremental circle algorithm.

	modifications:
		date:	Tue Mar 22 22:04:58 EST 1988
		author:	rayk
		changes:add comments
**************************************************************************/

#include "header.h"

struct  pr_pos  ptlist[MAX_PTS];

draw_circle(pw, center_x,center_y, radius,ROP)
int		center_x,center_y;
Pixwin            *pw;
int                radius,ROP;
{
struct pr_pos      center;

        int             x,y,
                        error, numpts;

	if (radius==0) return(0);
	center.x = center_x;
	center.y = center_y;

           x = 0; y = radius; numpts = 0;
           error = 3 - (radius << 1);

           while (x < y)
           {
             ptlist[numpts].x=center.x+x;   ptlist[numpts++].y=center.y+y;
             ptlist[numpts].x=center.x-x;   ptlist[numpts++].y=center.y+y;
             ptlist[numpts].x=center.x+x;   ptlist[numpts++].y=center.y-y;
             ptlist[numpts].x=center.x-x;   ptlist[numpts++].y=center.y-y;
             ptlist[numpts].x=center.x+y;   ptlist[numpts++].y=center.y+x;
             ptlist[numpts].x=center.x-y;   ptlist[numpts++].y=center.y+x;
             ptlist[numpts].x=center.x+y;   ptlist[numpts++].y=center.y-x;
             ptlist[numpts].x=center.x-y;   ptlist[numpts++].y=center.y-x;
   
             if (error < 0)
                error = error + (x << 2) + 6;
             else
                error = error + ((x-y--) << 2) + 10;
             x++;
           }  /* end of while (x , y) */
   
           if (x == y)
           {
             ptlist[numpts].x=center.x+x;   ptlist[numpts++].y=center.y+y;
             ptlist[numpts].x=center.x-x;   ptlist[numpts++].y=center.y+y;
             ptlist[numpts].x=center.x+x;   ptlist[numpts++].y=center.y-y;
             ptlist[numpts].x=center.x-x;   ptlist[numpts++].y=center.y-y;
           }

	   my_pw_polypoint(pw,0,0,numpts,ptlist,PIX_SET);
}  /* end of function draw_circle() */   



my_pw_polypoint(temp_pw,off_x,off_y,count_pts,ptlist, ROP)
Pixwin *temp_pw;
int off_x,off_y,count_pts;
struct pr_pos ptlist[];
int ROP;
{

  if (image_depth > 1)
  {
    while(--count_pts > 0)
    {
      pw_rop(temp_pw,off_x+ptlist[count_pts].x,off_y+ptlist[count_pts].y,1,1
  	,PIX_COLOR(cur_color) | PIX_SRC ,pattern[0],0,0);
    }
  }
  else
  {
    pw_polypoint(temp_pw,off_x,off_y,count_pts,ptlist,ROP);
  }
}
