/*
 *  tek.c  
 *  copyright 1988 Ronald Florence
 *
 *    as "tek" - Tek4014 picture files to CGI or WY99
 *      -w  Accu-Weather maps
 *    as "poly" - reads points for polyline on CGI or WY99
 *      -s  read xmin, ymin, xmax, ymax scaling points first 
 *          (default is 4096 x 3120)
 *    both:
 *      -p  use plotter or printer (default display)
 *      -a  preserve aspect ratio
 *
 *    bugs: SIGINT doesn't work with wy99 modes.  Possible solution is to
 *	poll terminal on every iteration, with terminal set in raw mode.
 */

#include  <signal.h>
#include  <stdio.h>
#include  <termio.h>
#include  <fcntl.h>

#define  int		short		/* for CGI functions	*/
#define	 CRT		(wout[45] == 0)
#define	 To_tek		"\033[?38h"
#define	 To_vt220	"\033[?38l"
#define	 Clr_tek	"\033\f"
#define  Vt_reset	"\033!p"

int	dev;			/* device id */
static  int	tty;
struct  termio new, old;
static  int  tek;		/* =1 if invoked as tek */
static  char  *progn;
static  char  *dspec[] = {"CGIDISP", "CGIPRNT", 0 };

main (argc, argv)
     int	argc;
     char	**argv;
{
  FILE  *fi = stdin;
  int	win[19], 		/* device input info */
       	wout[66], 		/* device output info */
        h = 0, 
	aspect = 0,		/* map to max CGI space */
	opt = 0,
	sig_handle(), quit_wyse();
	char	*device, *p, *getenv(), *strrchr(); 

  progn = (p = strrchr(*argv, '/')) ? p + 1 : *argv;	
  tek = strcmp(progn, "poly");
  if (strlen(getenv("ASPECT")))
    aspect = 3;

  while (argc-- && **++argv == '-') 
    for (p = *argv+1; *p; p++)
      switch (*p) 
	{
	case 'w' :
	  if (tek)
	    ++opt;
	  else
	    usage();
	  break;
	case 's' :
	  if (!tek)
	    ++opt;
	  else
	    usage();
	  break;
	case 'p' :
	  ++h;
	  break;
	case 'a' :
	  aspect = 3;
	  break;
	default :
	  usage();
	}
				/* we cannot do freopen(stdin) for the */
				/* input because the CGI functions */
				/* read from stdin  */
  if (argc > 0 && (fi = fopen(*argv, "r")) == NULL)  
    {
      printf("%s: can't open %s\n", progn, *argv);
      exit (-1);
    }
				/* open /dev/tty to read keystrokes */
  tty = open("/dev/tty", O_RDWR);
  ioctl(tty, TCGETA, &new);
  ioctl(tty, TCGETA, &old);
				/* wyse 99 terminal? */
  if (!h && !strncmp(getenv("TERM"), "wy99", 4))
    {
				 /* not this easy, alas ... */
      signal(SIGINT, quit_wyse);
      printf("%s%s", To_tek, Clr_tek);
      if (tek)
	vt_tek(fi, opt);
      else
	tekpts(fi, opt);
      fflush(stdout);
      getkey();
      quit_wyse();
    }
				/* check for valid CGI device */
  for ( ; (device = dspec[h]) && getenv(dspec[h]) == NULL; h++) ;
  if (!device)
    {
      printf("%s: no device\n", progn);
      exit (-1);
    }
  signal( SIGHUP, sig_handle );
  signal( SIGINT, sig_handle );
  signal( SIGQUIT, SIG_IGN );

  win[0] = aspect;
  win[1] = 1;			/* solid line */
  win[2] = 1;			/* line color */
  win[3] = 1;			/* marker type . */
  win[4] = 1;			/* marker color */
  win[5] = 1;			/* graphics text font */
  win[6] = 1;			/* graphics text color */
  win[7] = 0;			/* fill interior style */
  win[8] = 0;			/* fill style index */
  win[9] = 1;			/* fill color index */
  win[10] = 1;			/* prompt for paper changes */
  for (h = 0; device[h]; h++)
    win[11+h] = device[h];
  win[18] = ' ';

  if (v_opnwk(win, &dev, wout) < 0) 
    {
      printf("%s: error %d opening %s\n", progn, -vq_error(), device);
      exit (-1);
    }	
  if (tek)
    tekdecode(fi, opt);
  else
    do_poly(fi, opt);
  if (CRT)  
    getkey();
  v_clswk(dev);
}


usage ()
{
  printf("usage: %s file\n", tek ? "tek [-wpa]" : "poly [-spa]");
  exit (-1);
}


err (func)
     char  func[];
{
  int	errnum;

  errnum = strcmp(func, "data") ? -(vq_error()) : 0;
  v_clswk(dev);
  if (errnum)
    printf ("%s: error no. %d in CGI function %s\n", progn, errnum, func);
  else
    printf (tek ? "tek: too many data points\n" : "poly: invalid scaling points\n");
  exit (-2);
}


int  sig_handle (sig)
     int  sig;
{
  v_clswk( dev );
  exit( sig );
}

getkey()
{
  char	c;

  new.c_lflag &= ~(ECHO|ICANON);
  new.c_cc[VMIN] = 1;
  ioctl(tty, TCSETAW, &new);
  read(tty, &c, 1);
  ioctl(tty, TCSETA, &old);
}

int  quit_wyse ()		/* needs all of it to restore wy99 */
{
  fflush (stdout);
  fprintf (stderr, "%s%s", Clr_tek, To_vt220);
  sleep (1);
  fprintf (stderr, "%s", Vt_reset);
  exit (0);
}

