/*
 *  tekpts.c
 *  copyright 1988 Ronald Florence 
 */

#include <stdio.h>

#define	 Tekx  	4096.0
#define	 Teky  	3120.0

vt_tek (infile, weather)
     FILE	*infile;
     int	weather;
{
     register	c, escape = 0;

     while ((c = getc(infile)) != EOF)
       {
	 if (weather)
	   switch (escape)
	     {
	     case 0 :
	       if (c == 0x1b)	/* escape */
		 escape = 1;
	       break;
	     case 1 :
	       escape = (c >= '8' && c <= ';') ? 2 : 0;
	       break;
	     case 2 :
	       if (c == 'P')
		 return;
	       escape = 0;
	       break;
	     }
	 putchar(c);
       }
   }


tekpts (infile, scaled)
     FILE  *infile;
     int   scaled;
{
  register tx, ty;
  double  xscale = 1.0, yscale = 1.0, ix, iy, sxlo, sxhi, sylo, syhi;
  int  	  xadd = 0, yadd = 0;

  if (scaled)
    {
				/* read and check the scaling points */
      if ( fscanf(infile, "%lf%lf%lf%lf", &sxlo, &sylo, &sxhi, &syhi ) == EOF 
	  || sxlo >= sxhi
	  || sylo >= syhi )
	err ("data");
				/* rescale */
      xscale = Tekx / (sxhi - sxlo);
      yscale = Teky / (syhi - sylo);
      xadd = -sxlo * xscale;
      yadd = -sylo * yscale;
    }

  putchar(0x1d);		/* tek vector mode */
  while ( fscanf(infile, "%lf%lf", &ix, &iy) != EOF )
    {
      tx = ix * xscale + xadd;
      ty = iy * yscale + yadd;
				/* clip */
      if (tx >= Tekx)
	tx = Tekx - 1;
      if (tx < 0)
	tx = 0;
      if (ty >= Teky)
	ty = Teky -1;
      if (ty < 0)
	ty = 0;
				/* The fancy way is to send hiy, */
				/* loy, and hix only when they change. */
				/* This works.   We shift the high */
				/* part by 7 instead of 5 and shift */
				/* the low part by 2 because we scale */
				/* the Tek at 4096 x 3120 */
      putchar(0x20 | ((ty >> 7) & 0x1f)); /* hi y */
      putchar(0x60 | ((ty >> 2) & 0x1f)); /* low y */
      putchar(0x20 | ((tx >> 7) & 0x1f)); /* hi x */
      putchar(0x40 | ((tx >> 2) & 0x1f)); /* low x */
    }
  putchar(0x1f);		/* end tek vector mode */
}

