/*
 *	poly.c 
 *	copyright 1988 Ronald Florence
 */

#include        <stdio.h>

#define	int	short		/* for CGI functions	*/
#define Maxpts  1000
#define Vdimax  32000
#define Tekx    4096.0
#define Teky    3120.0

extern int	dev;		/* device id */

static double  xscale = Vdimax / Tekx,
               yscale = Vdimax / Teky;


do_poly (infile, scaled)
     FILE  *infile;
     int   scaled;
{
  double  ix, iy, txlo, txhi, tylo, tyhi;
  int  ptc = 0, pts [Maxpts], xadd = 0, yadd = 0;

  if (scaled) {
				/* read and check the scaling points */
    if ( fscanf(infile, "%lf%lf%lf%lf", &txlo, &tylo, &txhi, &tyhi ) == EOF 
	|| txlo >= txhi
	|| tylo >= tyhi )
      err ("data");
				/* rescale */
    xscale = Vdimax / (txhi - txlo);
    yscale = Vdimax / (tyhi - tylo);
    xadd = -txlo * xscale;
    yadd = -tylo * yscale;
  }
				/* read one xy point at a time */
  while ( fscanf(infile, "%lf%lf", &ix, &iy) != EOF )  {
				/* put them out when we have Maxpts / 2 */
    if ( ptc >= Maxpts )  {
	if (v_pline (dev, (ptc / 2), pts) < 0 )  
	  err ("v_pline");
				/* copy the last points to the first */
	pts [0] = pts [ptc -2];
	pts [1] = pts [ptc -1];
				/* and set counter to start over */
	ptc = 2;
    }
				/* scale the points for the array */
    pts [ptc++] = ix * xscale + xadd;
    pts [ptc++] = iy * yscale + yadd;
  }
				/* make sure we get the tail end */
  if ( ptc > 2 && v_pline (dev, (ptc / 2), pts) < 0 )  
    err ("v_pline");
}
